/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\u0010 \u0001)B\u0001\u0002\u000f\u0001\u0003\u0002\u0004%I!\u000f\u0005\t{\u0001\u0011\t\u0019!C\u0005}!AA\t\u0001B\u0001B\u0003&!\b\u0003\u0005F\u0001\t\u0005\r\u0011\"\u0003G\u0011!Q\u0005A!a\u0001\n\u0013Y\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0015B$\t\u00119\u0003!\u00111A\u0005\neB\u0001b\u0014\u0001\u0003\u0002\u0004%I\u0001\u0015\u0005\t%\u0002\u0011\t\u0011)Q\u0005u!A1\u000b\u0001BA\u0002\u0013%\u0011\b\u0003\u0005U\u0001\t\u0005\r\u0011\"\u0003V\u0011!9\u0006A!A!B\u0013Q\u0004B\u0002-\u0001\t\u0003\t\u0013\fC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u001d\u0004\u0001\u0015!\u0003b\u0011\u001dA\u0007A1A\u0005\n%Da!\u001c\u0001!\u0002\u0013Q\u0007b\u00028\u0001\u0005\u0004%\te\u001c\u0005\u0007y\u0002\u0001\u000b\u0011\u00029\t\u000ba\u0003A\u0011\u0001@\t\u000f\u0005E\u0001\u0001\"\u0015\u0002\u0014\u001d9\u00111F\u0010\t\u0002\u00055bA\u0002\u0010 \u0011\u0003\ty\u0003\u0003\u0004Y/\u0011\u0005\u0011q\u0007\u0005\b\u0003s9B\u0011AA\u001e\u0011\u001d\tId\u0006C\u0001\u0003KBq!!\u000f\u0018\t\u0003\t\u0019\bC\u0004\u0002:]!\t!a \t\u0013\u0005\u001du#!A\u0005\n\u0005%%A\u0006*jI\u001e,'+Z4sKN\u001c\u0018n\u001c8XSRD7k\u0012#\u000b\u0005\u0001\n\u0013A\u0003:fOJ,7o]5p]*\u0011!eI\u0001\u0006[2d\u0017N\u0019\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011c\u0001\u0001,eA\u0019A&L\u0018\u000e\u0003}I!AL\u0010\u00035\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'/\u00117h_JLG\u000f[7\u0011\u00051\u0002\u0014BA\u0019 \u0005Q\u0011\u0016\u000eZ4f%\u0016<'/Z:tS>tWj\u001c3fYB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\ta1+\u001a:jC2L'0\u00192mK\u0006A1\u000f^3q'&TX-F\u0001;!\t\u00194(\u0003\u0002=i\t1Ai\\;cY\u0016\fAb\u001d;faNK'0Z0%KF$\"a\u0010\"\u0011\u0005M\u0002\u0015BA!5\u0005\u0011)f.\u001b;\t\u000f\r\u0013\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002\u0013M$X\r]*ju\u0016\u0004\u0013!\u00048v[&#XM]1uS>t7/F\u0001H!\t\u0019\u0004*\u0003\u0002Ji\t\u0019\u0011J\u001c;\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002@\u0019\"91)BA\u0001\u0002\u00049\u0015A\u00048v[&#XM]1uS>t7\u000fI\u0001\te\u0016<\u0007+\u0019:b[\u0006a!/Z4QCJ\fWn\u0018\u0013fcR\u0011q(\u0015\u0005\b\u0007\"\t\t\u00111\u0001;\u0003%\u0011Xm\u001a)be\u0006l\u0007%A\tnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:\fQ#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002@-\"91iCA\u0001\u0002\u0004Q\u0014AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002\na\u0001P5oSRtD#\u0002.\\9vs\u0006C\u0001\u0017\u0001\u0011\u0015AT\u00021\u0001;\u0011\u0015)U\u00021\u0001H\u0011\u0015qU\u00021\u0001;\u0011\u0015\u0019V\u00021\u0001;\u0003!9'/\u00193jK:$X#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\f\u0013\u0001D8qi&l\u0017N_1uS>t\u0017B\u00014d\u0005QaU-Y:u'F,\u0018M]3t\u000fJ\fG-[3oi\u0006IqM]1eS\u0016tG\u000fI\u0001\bkB$\u0017\r^3s+\u0005Q\u0007C\u00012l\u0013\ta7M\u0001\tTcV\f'/\u001a3MeU\u0003H-\u0019;fe\u0006AQ\u000f\u001d3bi\u0016\u0014\b%A\u0005paRLW.\u001b>feV\t\u0001\u000f\u0005\u0002cc&\u0011!o\u0019\u0002\u0010\u000fJ\fG-[3oi\u0012+7oY3oi\"\u001a!\u0003\u001e>\u0011\u0005UDX\"\u0001<\u000b\u0005]\u001c\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011P\u001e\u0002\u0006'&t7-Z\u0011\u0002w\u0006)\u0001G\f\u001d/a\u0005Qq\u000e\u001d;j[&TXM\u001d\u0011)\u0007M!(\u0010F\u0001[Q\u001d!\u0012\u0011AA\u0004\u0003\u0017\u00012aMA\u0002\u0013\r\t)\u0001\u000e\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA\u0005\u0003\u0005mRk]3![2t#/Z4sKN\u001c\u0018n\u001c8/\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u0004s/\u001b;iA\u0015d\u0017m\u001d;jG:+G\u000fU1sC6\u0004S\b\t\u0019/a9\u0002cj\u001c;fAQDW\r\t3fM\u0006,H\u000e\u001e\u0011sK\u001e\u0004\u0016M]1nA%\u001c\b\u0005\r\u00181c\u00012wN\u001d\u0011SS\u0012<WMU3he\u0016\u001c8/[8o/&$\bnU$EY\u0001\u0012W\u000f\u001e\u0011jg\u0002\u0002d\u0006\r\u0011g_J\u0004C*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\u0018\"\u0005\u00055\u0011!\u0002\u001a/a9\u0002\u0004f\u0001\u000buu\u0006Y1M]3bi\u0016lu\u000eZ3m)\u0015y\u0013QCA\u0013\u0011\u001d\t9\"\u0006a\u0001\u00033\tqa^3jO\"$8\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"I\u0001\u0007Y&t\u0017\r\\4\n\t\u0005\r\u0012Q\u0004\u0002\u0007-\u0016\u001cGo\u001c:\t\r\u0005\u001dR\u00031\u0001;\u0003%Ig\u000e^3sG\u0016\u0004H\u000fK\u0002\u0001ij\faCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\t\u0003Y]\u0019BaFA\u0019eA\u00191'a\r\n\u0007\u0005UBG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003[\tQ\u0001\u001e:bS:$RbLA\u001f\u0003'\n)&a\u0016\u0002Z\u0005m\u0003bBA 3\u0001\u0007\u0011\u0011I\u0001\u0006S:\u0004X\u000f\u001e\t\u0007\u0003\u0007\nI%!\u0014\u000e\u0005\u0005\u0015#bAA$G\u0005\u0019!\u000f\u001a3\n\t\u0005-\u0013Q\t\u0002\u0004%\u0012#\u0005c\u0001\u0017\u0002P%\u0019\u0011\u0011K\u0010\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u000b\u0015K\u0002\u0019A$\t\u000baJ\u0002\u0019\u0001\u001e\t\u000b9K\u0002\u0019\u0001\u001e\t\u000bMK\u0002\u0019\u0001\u001e\t\u000f\u0005u\u0013\u00041\u0001\u0002\u001a\u0005q\u0011N\\5uS\u0006dw+Z5hQR\u001c\b\u0006B\ru\u0003C\n#!a\u0019\u0002\u000bEr\u0003G\f\u0019\u0015\u0017=\n9'!\u001b\u0002l\u00055\u0014q\u000e\u0005\b\u0003\u007fQ\u0002\u0019AA!\u0011\u0015)%\u00041\u0001H\u0011\u0015A$\u00041\u0001;\u0011\u0015q%\u00041\u0001;\u0011\u0015\u0019&\u00041\u0001;Q\rQBO\u001f\u000b\n_\u0005U\u0014qOA=\u0003wBq!a\u0010\u001c\u0001\u0004\t\t\u0005C\u0003F7\u0001\u0007q\tC\u000397\u0001\u0007!\bC\u0003O7\u0001\u0007!\bK\u0002\u001cij$RaLAA\u0003\u0007Cq!a\u0010\u001d\u0001\u0004\t\t\u0005C\u0003F9\u0001\u0007q\tK\u0002\u001dij\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0015\u0001\u00026bm\u0006LA!!'\u0002\u0010\n1qJ\u00196fGRDsaFA\u0001\u0003\u000f\tY\u0001K\u0002\u0018ijDsAFA\u0001\u0003\u000f\tY\u0001K\u0002\u0017ij\u0004")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel> {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SquaredL2Updater updater;
    private final GradientDescent optimizer;

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, Vector vector) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public RidgeRegressionModel createModel(Vector weights, double intercept) {
        return new RidgeRegressionModel(weights, intercept);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 0.01, 1.0);
    }
}

