/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Predict;
import org.apache.spark.mllib.tree.model.Split;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u00181\u0001uB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t7\u0002\u0011\t\u0011)A\u0005\u001f\"AQ\f\u0001BA\u0002\u0013\u0005a\f\u0003\u0005e\u0001\t\u0005\r\u0011\"\u0001f\u0011!a\u0007A!A!B\u0013y\u0006\u0002\u00038\u0001\u0005\u0003\u0007I\u0011A8\t\u0011Y\u0004!\u00111A\u0005\u0002]D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006K\u0001\u001d\u0005\ty\u0002\u0011\t\u0019!C\u0001{\"Q\u0011Q\u0001\u0001\u0003\u0002\u0004%\t!a\u0002\t\u0013\u00055\u0001A!A!B\u0013q\bBCA\t\u0001\t\u0005\r\u0011\"\u0001\u0002\u0014!Q\u00111\u0005\u0001\u0003\u0002\u0004%\t!!\n\t\u0015\u0005-\u0002A!A!B\u0013\t)\u0002\u0003\u0006\u00020\u0001\u0011\t\u0019!C\u0001\u0003cA!\"!\u000f\u0001\u0005\u0003\u0007I\u0011AA\u001e\u0011)\t\t\u0005\u0001B\u0001B\u0003&\u00111\u0007\u0005\u000b\u0003\u000b\u0002!\u00111A\u0005\u0002\u0005E\u0002BCA%\u0001\t\u0005\r\u0011\"\u0001\u0002L!Q\u0011\u0011\u000b\u0001\u0003\u0002\u0003\u0006K!a\r\t\u0015\u0005U\u0003A!a\u0001\n\u0003\t9\u0006\u0003\u0006\u0002d\u0001\u0011\t\u0019!C\u0001\u0003KB!\"a\u001b\u0001\u0005\u0003\u0005\u000b\u0015BA-\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!!&\u0001\t\u0003\n9\n\u0003\u0004^\u0001\u0011\u0005\u0011q\u0016\u0005\t\u0003\u000f\u0004A\u0011\u0001\u001a\u0002J\"9\u00111\u001a\u0001\u0005\u0002Ir\u0005bBAg\u0001\u0011\u0005!G\u0014\u0005\t\u0003\u001f\u0004A\u0011\u0001\u001a\u0002R\"Q\u0011q\u001b\u0001\u0012\u0002\u0013\u0005!'!7\t\u0011\u00055\b\u0001\"\u00013\u0003_<\u0001B!\u00041\u0011\u00031$q\u0002\u0004\b_AB\tA\u000eB\t\u0011\u001d\tyG\tC\u0001\u0005'AqA!\u0006#\t\u0003\u00119\u0002C\u0004\u0003\u001e\t\"\tAa\b\t\u000f\t%\"\u0005\"\u0001\u0003,!9!q\u0006\u0012\u0005\u0002\tE\u0002b\u0002B\u001bE\u0011\u0005!q\u0007\u0005\b\u0005w\u0011C\u0011\u0001B\u001f\u0011\u001d\u0011\tE\tC\u0001\u0005\u0007BqAa\u0012#\t\u0003\u0011I\u0005C\u0004\u0003P\t\"\tA!\u0015\t\u000f\tU#\u0005\"\u0001\u0003X!I!q\f\u0012\u0002\u0002\u0013%!\u0011\r\u0002\u0005\u001d>$WM\u0003\u00022e\u0005)Qn\u001c3fY*\u00111\u0007N\u0001\u0005iJ,WM\u0003\u00026m\u0005)Q\u000e\u001c7jE*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qDi\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}*\u0015B\u0001$A\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA5*D\u0001J\u0015\tQe'\u0001\u0005j]R,'O\\1m\u0013\ta\u0015JA\u0004M_\u001e<\u0017N\\4\u0002\u0005%$W#A(\u0011\u0005}\u0002\u0016BA)A\u0005\rIe\u000e\u001e\u0015\u0004\u0003MK\u0006C\u0001+X\u001b\u0005)&B\u0001,7\u0003)\tgN\\8uCRLwN\\\u0005\u00031V\u0013QaU5oG\u0016\f\u0013AW\u0001\u0006c9\u0002d\u0006M\u0001\u0004S\u0012\u0004\u0003f\u0001\u0002T3\u00069\u0001O]3eS\u000e$X#A0\u0011\u0005\u0001\fW\"\u0001\u0019\n\u0005\t\u0004$a\u0002)sK\u0012L7\r\u001e\u0015\u0004\u0007MK\u0016a\u00039sK\u0012L7\r^0%KF$\"AZ5\u0011\u0005}:\u0017B\u00015A\u0005\u0011)f.\u001b;\t\u000f)$\u0011\u0011!a\u0001?\u0006\u0019\u0001\u0010J\u0019)\u0007\u0011\u0019\u0016,\u0001\u0005qe\u0016$\u0017n\u0019;!Q\r)1+W\u0001\tS6\u0004XO]5usV\t\u0001\u000f\u0005\u0002@c&\u0011!\u000f\u0011\u0002\u0007\t>,(\r\\3)\u0007\u0019\u0019F/I\u0001v\u0003\u0015\tdF\r\u00181\u00031IW\u000e];sSRLx\fJ3r)\t1\u0007\u0010C\u0004k\u000f\u0005\u0005\t\u0019\u00019)\u0007\u001d\u0019F/A\u0005j[B,(/\u001b;zA!\u001a\u0001b\u0015;\u0002\r%\u001cH*Z1g+\u0005q\bCA \u0000\u0013\r\t\t\u0001\u0011\u0002\b\u0005>|G.Z1oQ\rI1+W\u0001\u000bSNdU-\u00194`I\u0015\fHc\u00014\u0002\n!9!NCA\u0001\u0002\u0004q\bf\u0001\u0006T3\u00069\u0011n\u001d'fC\u001a\u0004\u0003fA\u0006T3\u0006)1\u000f\u001d7jiV\u0011\u0011Q\u0003\t\u0006\u007f\u0005]\u00111D\u0005\u0004\u00033\u0001%AB(qi&|g\u000eE\u0002a\u0003;I1!a\b1\u0005\u0015\u0019\u0006\u000f\\5uQ\ra1+W\u0001\ngBd\u0017\u000e^0%KF$2AZA\u0014\u0011!QW\"!AA\u0002\u0005U\u0001fA\u0007T3\u000611\u000f\u001d7ji\u0002B3AD*Z\u0003!aWM\u001a;O_\u0012,WCAA\u001a!\u0015y\u0014qCA\u001b!\t\u0001\u0007\u0001K\u0002\u0010'f\u000bA\u0002\\3gi:{G-Z0%KF$2AZA\u001f\u0011!Q\u0007#!AA\u0002\u0005M\u0002f\u0001\tT3\u0006IA.\u001a4u\u001d>$W\r\t\u0015\u0004#MK\u0016!\u0003:jO\"$hj\u001c3fQ\r\u00112+W\u0001\u000ee&<\u0007\u000e\u001e(pI\u0016|F%Z9\u0015\u0007\u0019\fi\u0005\u0003\u0005k'\u0005\u0005\t\u0019AA\u001aQ\r\u00192+W\u0001\u000be&<\u0007\u000e\u001e(pI\u0016\u0004\u0003f\u0001\u000bT3\u0006)1\u000f^1ugV\u0011\u0011\u0011\f\t\u0006\u007f\u0005]\u00111\f\t\u0004A\u0006u\u0013bAA0a\t!\u0012J\u001c4pe6\fG/[8o\u000f\u0006Lgn\u0015;biND3!F*Z\u0003%\u0019H/\u0019;t?\u0012*\u0017\u000fF\u0002g\u0003OB\u0001B\u001b\f\u0002\u0002\u0003\u0007\u0011\u0011\f\u0015\u0004-MK\u0016AB:uCR\u001c\b\u0005K\u0002\u0018'f\u000ba\u0001P5oSRtDCEA\u001b\u0003g\n9(a\u001f\u0002\u0000\u0005\r\u0015qQAF\u0003\u001fCQ!\u0014\rA\u0002=CC!a\u001dT3\")Q\f\u0007a\u0001?\"\"\u0011qO*Z\u0011\u0015q\u0007\u00041\u0001qQ\u0011\tYh\u0015;\t\u000bqD\u0002\u0019\u0001@)\t\u0005}4+\u0017\u0005\b\u0003#A\u0002\u0019AA\u000bQ\u0011\t\u0019iU-\t\u000f\u0005=\u0002\u00041\u0001\u00024!\"\u0011qQ*Z\u0011\u001d\t)\u0005\u0007a\u0001\u0003gAC!a#T3\"9\u0011Q\u000b\rA\u0002\u0005e\u0003\u0006BAH'fC3\u0001G*u\u0003!!xn\u0015;sS:<GCAAM!\u0011\tY*!+\u000f\t\u0005u\u0015Q\u0015\t\u0004\u0003?\u0003UBAAQ\u0015\r\t\u0019\u000bP\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\u0006)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\u000biK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\u0003Ec\u00019\u00022\"9\u00111\u0017\u000eA\u0002\u0005U\u0016\u0001\u00034fCR,(/Z:\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/5\u0003\u0019a\u0017N\\1mO&!\u0011qXA]\u0005\u00191Vm\u0019;pe\"\"!dUAbC\t\t)-A\u00032]Er\u0003'\u0001\u0005eK\u0016\u00048i\u001c9z)\t\t)$\u0001\bok6$Um]2f]\u0012\fg\u000e^:\u0002\u0019M,(\r\u001e:fK\u0012+\u0007\u000f\u001e5\u0002\u001fM,(\r\u001e:fKR{7\u000b\u001e:j]\u001e$B!!'\u0002T\"A\u0011Q\u001b\u0010\u0011\u0002\u0003\u0007q*\u0001\u0007j]\u0012,g\u000e\u001e$bGR|'/A\rtk\n$(/Z3U_N#(/\u001b8hI\u0011,g-Y;mi\u0012\nTCAAnU\ry\u0015Q\\\u0016\u0003\u0003?\u0004B!!9\u0002j6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0011a\u000bQ\u0005\u0005\u0003W\f\u0019OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqb];ciJ,W-\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0004b!a=\u0002~\u0006Ub\u0002BA{\u0003stA!a(\u0002x&\t\u0011)C\u0002\u0002|\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\n\u0005!\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005m\b\tK\u0002\u0001\u0005\u000b\u00012\u0001\u0016B\u0004\u0013\r\u0011I!\u0016\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0004\u0001MK\u0016\u0001\u0002(pI\u0016\u0004\"\u0001\u0019\u0012\u0014\u0007\trD\t\u0006\u0002\u0003\u0010\u0005IQ-\u001c9us:{G-\u001a\u000b\u0005\u0003k\u0011I\u0002\u0003\u0004\u0003\u001c\u0011\u0002\raT\u0001\n]>$W-\u00138eKb\fQ!\u00199qYf$\"\"!\u000e\u0003\"\t\r\"Q\u0005B\u0014\u0011\u0019\u0011Y\"\na\u0001\u001f\")Q,\na\u0001?\")a.\na\u0001a\")A0\na\u0001}\u0006qA.\u001a4u\u0007\"LG\u000eZ%oI\u0016DHcA(\u0003.!1!1\u0004\u0014A\u0002=\u000bqB]5hQR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0004\u001f\nM\u0002B\u0002B\u000eO\u0001\u0007q*A\u0006qCJ,g\u000e^%oI\u0016DHcA(\u0003:!1!1\u0004\u0015A\u0002=\u000bA\"\u001b8eKb$v\u000eT3wK2$2a\u0014B \u0011\u0019\u0011Y\"\u000ba\u0001\u001f\u0006Y\u0011n\u001d'fMR\u001c\u0005.\u001b7e)\rq(Q\t\u0005\u0007\u00057Q\u0003\u0019A(\u0002\u001f5\f\u0007PT8eKNLe\u000eT3wK2$2a\u0014B&\u0011\u0019\u0011ie\u000ba\u0001\u001f\u0006)A.\u001a<fY\u0006\t2\u000f^1si&sG-\u001a=J]2+g/\u001a7\u0015\u0007=\u0013\u0019\u0006\u0003\u0004\u0003N1\u0002\raT\u0001\bO\u0016$hj\u001c3f)\u0019\t)D!\u0017\u0003\\!1!1D\u0017A\u0002=CqA!\u0018.\u0001\u0004\t)$\u0001\u0005s_>$hj\u001c3f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\u0005Y\u0006twM\u0003\u0002\u0003n\u0005!!.\u0019<b\u0013\u0011\u0011\tHa\u001a\u0003\r=\u0013'.Z2u\u0001")
public class Node
implements scala.Serializable,
Logging {
    private final int id;
    private Predict predict;
    private double impurity;
    private boolean isLeaf;
    private Option<Split> split;
    private Option<Node> leftNode;
    private Option<Node> rightNode;
    private Option<InformationGainStats> stats;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Node getNode(int n, Node node) {
        return Node$.MODULE$.getNode(n, node);
    }

    public static int startIndexInLevel(int n) {
        return Node$.MODULE$.startIndexInLevel(n);
    }

    public static int maxNodesInLevel(int n) {
        return Node$.MODULE$.maxNodesInLevel(n);
    }

    public static boolean isLeftChild(int n) {
        return Node$.MODULE$.isLeftChild(n);
    }

    public static int indexToLevel(int n) {
        return Node$.MODULE$.indexToLevel(n);
    }

    public static int parentIndex(int n) {
        return Node$.MODULE$.parentIndex(n);
    }

    public static int rightChildIndex(int n) {
        return Node$.MODULE$.rightChildIndex(n);
    }

    public static int leftChildIndex(int n) {
        return Node$.MODULE$.leftChildIndex(n);
    }

    public static Node apply(int n, Predict predict, double d, boolean bl) {
        return Node$.MODULE$.apply(n, predict, d, bl);
    }

    public static Node emptyNode(int n) {
        return Node$.MODULE$.emptyNode(n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public Predict predict() {
        return this.predict;
    }

    public void predict_$eq(Predict x$1) {
        this.predict = x$1;
    }

    public double impurity() {
        return this.impurity;
    }

    public void impurity_$eq(double x$1) {
        this.impurity = x$1;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void isLeaf_$eq(boolean x$1) {
        this.isLeaf = x$1;
    }

    public Option<Split> split() {
        return this.split;
    }

    public void split_$eq(Option<Split> x$1) {
        this.split = x$1;
    }

    public Option<Node> leftNode() {
        return this.leftNode;
    }

    public void leftNode_$eq(Option<Node> x$1) {
        this.leftNode = x$1;
    }

    public Option<Node> rightNode() {
        return this.rightNode;
    }

    public void rightNode_$eq(Option<Node> x$1) {
        this.rightNode = x$1;
    }

    public Option<InformationGainStats> stats() {
        return this.stats;
    }

    public void stats_$eq(Option<InformationGainStats> x$1) {
        this.stats = x$1;
    }

    public String toString() {
        return new StringBuilder(43).append("id = ").append(this.id()).append(", isLeaf = ").append(this.isLeaf()).append(", predict = ").append(this.predict()).append(", impurity = ").append(this.impurity()).append(", ").append(new StringBuilder(18).append("split = ").append(this.split()).append(", stats = ").append(this.stats()).toString()).toString();
    }

    public double predict(Vector features) {
        double d;
        if (this.isLeaf()) {
            d = this.predict().predict();
        } else {
            Enumeration.Value value = ((Split)this.split().get()).featureType();
            Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
            d = !(value != null ? !value.equals(value2) : value2 != null) ? (features.apply(((Split)this.split().get()).feature()) <= ((Split)this.split().get()).threshold() ? ((Node)this.leftNode().get()).predict(features) : ((Node)this.rightNode().get()).predict(features)) : (((Split)this.split().get()).categories().contains((Object)BoxesRunTime.boxToDouble((double)features.apply(((Split)this.split().get()).feature()))) ? ((Node)this.leftNode().get()).predict(features) : ((Node)this.rightNode().get()).predict(features));
        }
        return d;
    }

    public Node deepCopy() {
        None$ leftNodeCopy = this.leftNode().isEmpty() ? None$.MODULE$ : new Some((Object)((Node)this.leftNode().get()).deepCopy());
        None$ rightNodeCopy = this.rightNode().isEmpty() ? None$.MODULE$ : new Some((Object)((Node)this.rightNode().get()).deepCopy());
        return new Node(this.id(), this.predict(), this.impurity(), this.isLeaf(), this.split(), (Option<Node>)leftNodeCopy, (Option<Node>)rightNodeCopy, this.stats());
    }

    public int numDescendants() {
        return this.isLeaf() ? 0 : 2 + ((Node)this.leftNode().get()).numDescendants() + ((Node)this.rightNode().get()).numDescendants();
    }

    public int subtreeDepth() {
        return this.isLeaf() ? 0 : 1 + package$.MODULE$.max(((Node)this.leftNode().get()).subtreeDepth(), ((Node)this.rightNode().get()).subtreeDepth());
    }

    public String subtreeToString(int indentFactor) {
        String prefix = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(indentFactor);
        return this.isLeaf() ? new StringBuilder(0).append(prefix).append(new StringBuilder(10).append("Predict: ").append(this.predict().predict()).append("\n").toString()).toString() : new StringBuilder(0).append(prefix).append(new StringBuilder(4).append("If ").append(Node.splitToString$1((Split)this.split().get(), true)).append("\n").toString()).append(((Node)this.leftNode().get()).subtreeToString(indentFactor + 1)).append(prefix).append(new StringBuilder(6).append("Else ").append(Node.splitToString$1((Split)this.split().get(), false)).append("\n").toString()).append(((Node)this.rightNode().get()).subtreeToString(indentFactor + 1)).toString();
    }

    public int subtreeToString$default$1() {
        return 0;
    }

    public Iterator<Node> subtreeIterator() {
        return scala.package$.MODULE$.Iterator().single((Object)this).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterator)this.leftNode().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.subtreeIterator()).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().empty())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Iterator)this.rightNode().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.subtreeIterator()).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().empty()));
    }

    private static final String splitToString$1(Split split, boolean left) {
        String string;
        Enumeration.Value value = split.featureType();
        Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = left ? new StringBuilder(14).append("(feature ").append(split.feature()).append(" <= ").append(split.threshold()).append(")").toString() : new StringBuilder(13).append("(feature ").append(split.feature()).append(" > ").append(split.threshold()).append(")").toString();
        } else {
            Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = left ? new StringBuilder(14).append("(feature ").append(split.feature()).append(" in ").append(split.categories().mkString("{", ",", "}")).append(")").toString() : new StringBuilder(18).append("(feature ").append(split.feature()).append(" not in ").append(split.categories().mkString("{", ",", "}")).append(")").toString();
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    public Node(int id, Predict predict, double impurity, boolean isLeaf, Option<Split> split, Option<Node> leftNode, Option<Node> rightNode, Option<InformationGainStats> stats) {
        this.id = id;
        this.predict = predict;
        this.impurity = impurity;
        this.isLeaf = isLeaf;
        this.split = split;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.stats = stats;
        Logging.$init$((Logging)this);
    }
}

