/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.math.BigDecimal;
import java.util.BitSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.execution.datasources.Partition;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;
import scala.util.Try$;

public final class PartitioningUtils$ {
    public static final PartitioningUtils$ MODULE$;
    private final String DEFAULT_PARTITION_NAME;
    private final Seq<DataType> org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder;
    private final BitSet charToEscape;

    static {
        new PartitioningUtils$();
    }

    public String DEFAULT_PARTITION_NAME() {
        return this.DEFAULT_PARTITION_NAME;
    }

    public PartitionSpec parsePartitions(Seq<Path> paths, String defaultPartitionName, boolean typeInference) {
        PartitioningUtils.PartitionValues partitionValues;
        block4: {
            PartitionSpec partitionSpec2;
            block3: {
                Tuple2 tuple2;
                Seq pathsWithPartitionValues;
                block2: {
                    pathsWithPartitionValues = (Seq)paths.flatMap((Function1)new Serializable(defaultPartitionName, typeInference){
                        public static final long serialVersionUID = 0L;
                        private final String defaultPartitionName$1;
                        private final boolean typeInference$1;

                        public final Iterable<Tuple2<Path, PartitioningUtils.PartitionValues>> apply(Path path) {
                            return Option$.MODULE$.option2Iterable(PartitioningUtils$.MODULE$.parsePartition(path, this.defaultPartitionName$1, this.typeInference$1).map((Function1)new Serializable(this, path){
                                public static final long serialVersionUID = 0L;
                                private final Path path$1;

                                public final Tuple2<Path, PartitioningUtils.PartitionValues> apply(PartitioningUtils.PartitionValues x$1) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.path$1), (Object)x$1);
                                }
                                {
                                    this.path$1 = path$1;
                                }
                            }));
                        }
                        {
                            this.defaultPartitionName$1 = defaultPartitionName$1;
                            this.typeInference$1 = typeInference$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    if (!pathsWithPartitionValues.isEmpty()) break block2;
                    partitionSpec2 = PartitionSpec$.MODULE$.emptySpec();
                    break block3;
                }
                Seq<PartitioningUtils.PartitionValues> resolvedPartitionValues = this.resolvePartitions((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)pathsWithPartitionValues);
                partitionValues = (PartitioningUtils.PartitionValues)resolvedPartitionValues.head();
                if (partitionValues == null) break block4;
                Seq<String> columnNames = partitionValues.columnNames();
                Seq<Literal> literals = partitionValues.literals();
                Tuple2 tuple22 = tuple2 = new Tuple2(columnNames, literals);
                Seq columnNames2 = (Seq)tuple22._1();
                Seq literals2 = (Seq)tuple22._2();
                Seq fields = (Seq)((TraversableLike)columnNames2.zip((GenIterable)literals2, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(Tuple2<String, Literal> x0$1) {
                        Tuple2<String, Literal> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Literal literal = (Literal)tuple2._2();
                            if (literal != null) {
                                DataType dataType = literal.dataType();
                                StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
                                return structField;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq partitions = (Seq)((TraversableLike)resolvedPartitionValues.zip((GenIterable)pathsWithPartitionValues, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Partition apply(Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> x0$2) {
                        Tuple2<PartitioningUtils.PartitionValues, Tuple2<Path, PartitioningUtils.PartitionValues>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            PartitioningUtils.PartitionValues partitionValues = (PartitioningUtils.PartitionValues)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (partitionValues != null) {
                                Seq<Literal> literals = partitionValues.literals();
                                if (tuple22 != null) {
                                    Path path = (Path)tuple22._1();
                                    Partition partition = new Partition(InternalRow$.MODULE$.fromSeq((Seq)literals.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Object apply(Literal x$3) {
                                            return x$3.value();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())), path.toString());
                                    return partition;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                partitionSpec2 = new PartitionSpec(StructType$.MODULE$.apply(fields), (Seq<Partition>)partitions);
            }
            return partitionSpec2;
        }
        throw new MatchError((Object)partitionValues);
    }

    public Option<PartitioningUtils.PartitionValues> parsePartition(Path path, String defaultPartitionName, boolean typeInference) {
        ArrayBuffer columns2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path chopped = path;
        while (true) {
            block5: {
                Tuple2 tuple2;
                block8: {
                    None$ none$;
                    block7: {
                        Tuple2 tuple22;
                        block6: {
                            if (!finished) break block5;
                            if (!columns2.isEmpty()) break block6;
                            none$ = None$.MODULE$;
                            break block7;
                        }
                        tuple2 = ((GenericTraversableTemplate)columns2.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
                        if (tuple2 == null) break block8;
                        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
                        ArrayBuffer values = (ArrayBuffer)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)columnNames, (Object)values);
                        ArrayBuffer columnNames2 = (ArrayBuffer)tuple23._1();
                        ArrayBuffer values2 = (ArrayBuffer)tuple23._2();
                        none$ = new Some((Object)new PartitioningUtils.PartitionValues((Seq<String>)columnNames2, (Seq<Literal>)values2));
                    }
                    return none$;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = chopped.getName().toLowerCase();
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return None$.MODULE$;
            }
            Option<Tuple2<String, Literal>> maybeColumn = this.parsePartitionColumn(chopped.getName(), defaultPartitionName, typeInference);
            maybeColumn.foreach((Function1)new Serializable(columns2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer columns$1;

                public final ArrayBuffer<Tuple2<String, Literal>> apply(Tuple2<String, Literal> x$4) {
                    return this.columns$1.$plus$eq(x$4);
                }
                {
                    this.columns$1 = columns$1;
                }
            });
            chopped = chopped.getParent();
            finished = maybeColumn.isEmpty() || chopped.getParent() == null;
        }
    }

    private Option<Tuple2<String, Literal>> parsePartitionColumn(String columnSpec, String defaultPartitionName, boolean typeInference) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            String columnName = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column name in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0)new Serializable(columnSpec){
                public static final long serialVersionUID = 0L;
                private final String columnSpec$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Empty partition column value in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnSpec$1}));
                }
                {
                    this.columnSpec$1 = columnSpec$1;
                }
            });
            Literal literal = this.inferPartitionColumnValue(rawColumnValue, defaultPartitionName, typeInference);
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)literal));
        }
        return none$;
    }

    public Seq<PartitioningUtils.PartitionValues> resolvePartitions(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathsWithPartitionValues) {
        Seq seq;
        if (pathsWithPartitionValues.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq distinctPartColNames = (Seq)((SeqLike)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$6) {
                    return ((PartitioningUtils.PartitionValues)x$6._2()).columnNames();
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct();
            Predef$.MODULE$.assert(distinctPartColNames.size() == 1, (Function0)new Serializable(pathsWithPartitionValues){
                public static final long serialVersionUID = 0L;
                private final Seq pathsWithPartitionValues$1;

                public final String apply() {
                    return PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq<Tuple2<Path, PartitioningUtils.PartitionValues>>)this.pathsWithPartitionValues$1);
                }
                {
                    this.pathsWithPartitionValues$1 = pathsWithPartitionValues$1;
                }
            });
            Seq values = (Seq)pathsWithPartitionValues.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final PartitioningUtils.PartitionValues apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$7) {
                    return (PartitioningUtils.PartitionValues)x$7._2();
                }
            }, Seq$.MODULE$.canBuildFrom());
            int columnCount = ((PartitioningUtils.PartitionValues)values.head()).columnNames().size();
            IndexedSeq resolvedValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1)new Serializable(values){
                public static final long serialVersionUID = 0L;
                private final Seq values$1;

                public final Seq<Literal> apply(int i) {
                    return PartitioningUtils$.MODULE$.org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts((Seq<Literal>)((Seq)this.values$1.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final Literal apply(PartitioningUtils.PartitionValues x$8) {
                            return (Literal)x$8.literals().apply(this.i$1);
                        }
                        {
                            this.i$1 = i$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())));
                }
                {
                    this.values$1 = values$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            seq = (Seq)((TraversableLike)values.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(resolvedValues){
                public static final long serialVersionUID = 0L;
                private final IndexedSeq resolvedValues$1;

                public final PartitioningUtils.PartitionValues apply(Tuple2<PartitioningUtils.PartitionValues, Object> x0$3) {
                    Tuple2<PartitioningUtils.PartitionValues, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        PartitioningUtils.PartitionValues d = (PartitioningUtils.PartitionValues)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Seq x$19 = (Seq)this.resolvedValues$1.map((Function1)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final Literal apply(Seq<Literal> x$9) {
                                return (Literal)x$9.apply(this.index$1);
                            }
                            {
                                this.index$1 = index$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        Seq<String> x$20 = d.copy$default$1();
                        PartitioningUtils.PartitionValues partitionValues = d.copy(x$20, (Seq<Literal>)x$19);
                        return partitionValues;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resolvedValues$1 = resolvedValues$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public String listConflictingPartitionColumns(Seq<Tuple2<Path, PartitioningUtils.PartitionValues>> pathWithPartitionValues) {
        Seq distinctPartColNames = (Seq)((SeqLike)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x$10) {
                return ((PartitioningUtils.PartitionValues)x$10._2()).columnNames();
            }
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map partColNamesToPaths = this.groupByKey$1((Seq)pathWithPartitionValues.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Seq<String>, Path> apply(Tuple2<Path, PartitioningUtils.PartitionValues> x0$6) {
                Tuple2<Path, PartitioningUtils.PartitionValues> tuple2 = x0$6;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    PartitioningUtils.PartitionValues partValues = (PartitioningUtils.PartitionValues)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partValues.columnNames()), (Object)path);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq distinctPartColLists = (Seq)((TraversableLike)((IterableLike)distinctPartColNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<String> x$12) {
                return x$12.mkString(", ");
            }
        }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$7) {
                Tuple2<String, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    String names = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column name list #", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), names}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq suspiciousPaths = (Seq)((TraversableLike)distinctPartColNames.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<String> x$13) {
                return x$13.length();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1)partColNamesToPaths, Seq$.MODULE$.canBuildFrom());
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conflicting partition column names detected:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)distinctPartColLists.mkString("\n\t", "\n\t", "\n\n")).append((Object)"For partitioned table directories, data files should only live in leaf directories.\n").append((Object)"And directories at the same level should have the same partition column name.\n").append((Object)"Please check the following directories for unexpected files or ").append((Object)"inconsistent partition column names:\n").append((Object)((TraversableOnce)suspiciousPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$14) {
                return new StringBuilder().append((Object)"\t").append((Object)x$14).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).toString();
    }

    public Literal inferPartitionColumnValue(String raw, String defaultPartitionName, boolean typeInference) {
        Literal literal;
        if (typeInference) {
            literal = (Literal)Try$.MODULE$.apply((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                private final String raw$1;

                public final Literal apply() {
                    return Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(this.raw$1)), (DataType)IntegerType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.2 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)Long.parseLong(this.$outer.raw$1)), (DataType)LongType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.3 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)Double.parseDouble(this.$outer.raw$1)), (DataType)DoubleType$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).orElse((Function0)new Serializable(raw){
                public static final long serialVersionUID = 0L;
                public final String raw$1;

                public final Try<Literal> apply() {
                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.inferPartitionColumnValue.4 $outer;

                        public final Literal apply() {
                            return Literal$.MODULE$.apply((Object)new BigDecimal(this.$outer.raw$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.raw$1 = raw$1;
                }
            }).getOrElse((Function0)new Serializable(raw, defaultPartitionName){
                public static final long serialVersionUID = 0L;
                private final String raw$1;
                private final String defaultPartitionName$2;

                public final Literal apply() {
                    String string = this.raw$1;
                    String string2 = this.defaultPartitionName$2;
                    return !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)PartitioningUtils$.MODULE$.unescapePathName(this.raw$1), (DataType)StringType$.MODULE$);
                }
                {
                    this.raw$1 = raw$1;
                    this.defaultPartitionName$2 = defaultPartitionName$2;
                }
            });
        } else {
            String string = raw;
            String string2 = defaultPartitionName;
            literal = !(string != null ? !string.equals(string2) : string2 != null) ? Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$) : Literal$.MODULE$.create((Object)this.unescapePathName(raw), (DataType)StringType$.MODULE$);
        }
        return literal;
    }

    public Seq<DataType> org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder() {
        return this.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder;
    }

    public Seq<Literal> org$apache$spark$sql$execution$datasources$PartitioningUtils$$resolveTypeConflicts(Seq<Literal> literals) {
        DataType topType;
        DataType dataType = topType = (DataType)((TraversableOnce)literals.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Literal x$15) {
                return x$15.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(DataType x$16) {
                return PartitioningUtils$.MODULE$.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder().indexOf((Object)x$16);
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        NullType$ nullType$ = NullType$.MODULE$;
        StringType$ desiredType = !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null) ? StringType$.MODULE$ : topType;
        return (Seq)literals.map((Function1)new Serializable((DataType)desiredType){
            public static final long serialVersionUID = 0L;
            private final DataType desiredType$1;

            public final Literal apply(Literal x0$8) {
                Literal literal = x0$8;
                if (literal != null) {
                    Cast qual$1 = new Cast((Expression)literal, this.desiredType$1);
                    InternalRow x$21 = qual$1.eval$default$1();
                    Literal literal2 = Literal$.MODULE$.create(qual$1.eval(x$21), this.desiredType$1);
                    return literal2;
                }
                throw new MatchError((Object)literal);
            }
            {
                this.desiredType$1 = desiredType$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BitSet charToEscape() {
        return this.charToEscape;
    }

    public boolean needsEscaping(char c) {
        return c >= '\u0000' && c < this.charToEscape().size() && this.charToEscape().get(c);
    }

    public String escapePathName(String path) {
        StringBuilder builder = new StringBuilder();
        new StringOps(Predef$.MODULE$.augmentString(path)).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;

            public final StringBuilder apply(char c) {
                StringBuilder stringBuilder;
                if (PartitioningUtils$.MODULE$.needsEscaping(c)) {
                    this.builder$1.append('%');
                    char arg$macro$1 = c;
                    stringBuilder = this.builder$1.append(new StringOps("%02x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)})));
                } else {
                    stringBuilder = this.builder$1.append(c);
                }
                return stringBuilder;
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    /*
     * Exception decompiling
     */
    public String unescapePathName(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [0 : 94->118)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Map groupByKey$1(Seq seq) {
        return seq.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final K apply(Tuple2<K, V> x0$4) {
                Tuple2<K, V> tuple2 = x0$4;
                if (tuple2 != null) {
                    Object key;
                    Object object = key = tuple2._1();
                    return (K)object;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<V> apply(Seq<Tuple2<K, V>> x$11) {
                return (Iterable)x$11.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Tuple2<K, V> x0$5) {
                        Tuple2<K, V> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Object value;
                            Object object = value = tuple2._2();
                            return (V)object;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private PartitioningUtils$() {
        void var1_1;
        MODULE$ = this;
        this.DEFAULT_PARTITION_NAME = "__HIVE_DEFAULT_PARTITION__";
        this.org$apache$spark$sql$execution$datasources$PartitioningUtils$$upCastingOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{NullType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$}));
        BitSet bitSet = new BitSet(128);
        char[] clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'};
        Predef$.MODULE$.charArrayOps(clist).foreach((Function1)new Serializable(bitSet){
            public static final long serialVersionUID = 0L;
            private final BitSet bitSet$1;

            public final void apply(char x$17) {
                this.bitSet$1.set(x$17);
            }
            {
                this.bitSet$1 = bitSet$1;
            }
        });
        if (Shell.WINDOWS) {
            Predef$.MODULE$.charArrayOps(new char[]{' ', '<', '>', '|'}).foreach((Function1)new Serializable(bitSet){
                public static final long serialVersionUID = 0L;
                private final BitSet bitSet$1;

                public final void apply(char x$18) {
                    this.bitSet$1.set(x$18);
                }
                {
                    this.bitSet$1 = bitSet$1;
                }
            });
        }
        this.charToEscape = var1_1;
    }
}

