/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRenamePartitionCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005b\u0001\tE\t\u0015!\u0003J\u0011!\u0011\u0007A!f\u0001\n\u0003A\u0005\u0002C2\u0001\u0005#\u0005\u000b\u0011B%\t\u000b\u0011\u0004A\u0011A3\t\u000b)\u0004A\u0011I6\t\u000fy\u0004\u0011\u0011!C\u0001\u007f\"I\u0011q\u0001\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003?\u0001\u0011\u0013!C\u0001\u0003CA\u0011\"!\n\u0001#\u0003%\t!!\t\t\u0013\u0005\u001d\u0002!!A\u0005B\u0005%\u0002\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003_\u0002\u0011\u0011!C!\u0003c:\u0011\"!\u001e\u001c\u0003\u0003E\t!a\u001e\u0007\u0011iY\u0012\u0011!E\u0001\u0003sBa\u0001\u001a\u000b\u0005\u0002\u0005\u001d\u0005\"CAE)\u0005\u0005IQIAF\u0011%\ti\tFA\u0001\n\u0003\u000by\tC\u0005\u0002\u0018R\t\t\u0011\"!\u0002\u001a\"I\u00111\u0016\u000b\u0002\u0002\u0013%\u0011Q\u0016\u0002!\u00032$XM\u001d+bE2,'+\u001a8b[\u0016\u0004\u0016M\u001d;ji&|gnQ8n[\u0006tGM\u0003\u0002\u001d;\u000591m\\7nC:$'B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001SM:T\b\u0005\u0002+c5\t1F\u0003\u0002-[\u00059An\\4jG\u0006d'B\u0001\u00180\u0003\u0015\u0001H.\u00198t\u0015\t\u0001t$\u0001\u0005dCR\fG._:u\u0013\t\u00114FA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001\u001b6\u001b\u0005Y\u0012B\u0001\u001c\u001c\u0005=\u0011VO\u001c8bE2,7i\\7nC:$\u0007C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$a\u0002)s_\u0012,8\r\u001e\t\u0003qyJ!aP\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013Q\f'\r\\3OC6,W#\u0001\"\u0011\u0005\r#U\"A\u0018\n\u0005\u0015{#a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0015Q\f'\r\\3OC6,\u0007%\u0001\u0007pY\u0012\u0004\u0016M\u001d;ji&|g.F\u0001J!\tQeL\u0004\u0002L7:\u0011A*\u0017\b\u0003\u001bbs!AT,\u000f\u0005=3fB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019v%\u0001\u0004=e>|GOP\u0005\u0002M%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005Az\u0012B\u0001.0\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001X/\u0002\u0019\r\u000bG/\u00197pORK\b/Z:\u000b\u0005i{\u0013BA0a\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\u0005qk\u0016!D8mIB\u000b'\u000f^5uS>t\u0007%\u0001\u0007oK^\u0004\u0016M\u001d;ji&|g.A\u0007oK^\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019<\u0007.\u001b\t\u0003i\u0001AQ\u0001Q\u0004A\u0002\tCQaR\u0004A\u0002%CQAY\u0004A\u0002%\u000b1A];o)\ta\u0017\u0010E\u0002neVt!A\u001c9\u000f\u0005E{\u0017\"\u0001\u001e\n\u0005EL\u0014a\u00029bG.\fw-Z\u0005\u0003gR\u00141aU3r\u0015\t\t\u0018\b\u0005\u0002wo6\tq$\u0003\u0002y?\t\u0019!k\\<\t\u000biD\u0001\u0019A>\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005Yd\u0018BA? \u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0019\f\t!a\u0001\u0002\u0006!9\u0001)\u0003I\u0001\u0002\u0004\u0011\u0005bB$\n!\u0003\u0005\r!\u0013\u0005\bE&\u0001\n\u00111\u0001J\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0003+\u0007\t\u000bia\u000b\u0002\u0002\u0010A!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!C;oG\",7m[3e\u0015\r\tI\"O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000f\u0003'\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\t+\u0007%\u000bi!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t1\fgn\u001a\u0006\u0003\u0003k\tAA[1wC&!\u0011\u0011HA\u0018\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\b\t\u0004q\u0005\u0005\u0013bAA\"s\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011JA(!\rA\u00141J\u0005\u0004\u0003\u001bJ$aA!os\"I\u0011\u0011K\b\u0002\u0002\u0003\u0007\u0011qH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0003CBA-\u0003?\nI%\u0004\u0002\u0002\\)\u0019\u0011QL\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0005m#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001a\u0002nA\u0019\u0001(!\u001b\n\u0007\u0005-\u0014HA\u0004C_>dW-\u00198\t\u0013\u0005E\u0013#!AA\u0002\u0005%\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002h\u0005M\u0004\"CA)%\u0005\u0005\t\u0019AA%\u0003\u0001\nE\u000e^3s)\u0006\u0014G.\u001a*f]\u0006lW\rU1si&$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0005Q\"2\u0003\u0002\u000b\u0002|u\u0002\u0002\"! \u0002\u0004\nK\u0015JZ\u0007\u0003\u0003\u007fR1!!!:\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\"\u0002\u0000\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005]\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0012!B1qa2LHc\u00024\u0002\u0012\u0006M\u0015Q\u0013\u0005\u0006\u0001^\u0001\rA\u0011\u0005\u0006\u000f^\u0001\r!\u0013\u0005\u0006E^\u0001\r!S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY*a*\u0011\u000ba\ni*!)\n\u0007\u0005}\u0015H\u0001\u0004PaRLwN\u001c\t\u0007q\u0005\r&)S%\n\u0007\u0005\u0015\u0016H\u0001\u0004UkBdWm\r\u0005\t\u0003SC\u0012\u0011!a\u0001M\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u0003B!!\f\u00022&!\u00111WA\u0018\u0005\u0019y%M[3di\u0002")
public class AlterTableRenamePartitionCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Map<String, String> oldPartition;
    private final Map<String, String> newPartition;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Map<String, String>, Map<String, String>>> unapply(AlterTableRenamePartitionCommand alterTableRenamePartitionCommand) {
        return AlterTableRenamePartitionCommand$.MODULE$.unapply(alterTableRenamePartitionCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Map<String, String>, Map<String, String>>, AlterTableRenamePartitionCommand> tupled() {
        return AlterTableRenamePartitionCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Map<String, String>, Function1<Map<String, String>, AlterTableRenamePartitionCommand>>> curried() {
        return AlterTableRenamePartitionCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = this;
        synchronized (alterTableRenamePartitionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Map<String, String> oldPartition() {
        return this.oldPartition;
    }

    public Map<String, String> newPartition() {
        return this.newPartition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE RENAME PARTITION");
        Map<String, String> normalizedOldPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.oldPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        Map<String, String> normalizedNewPartition = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.newPartition(), (Seq<String>)table.partitionColumnNames(), table.identifier().quotedString(), (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
        catalog.renamePartitions(this.tableName(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedOldPartition})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{normalizedNewPartition})));
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenamePartitionCommand copy(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        return new AlterTableRenamePartitionCommand(tableName, oldPartition, newPartition);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Map<String, String> copy$default$2() {
        return this.oldPartition();
    }

    public Map<String, String> copy$default$3() {
        return this.newPartition();
    }

    public String productPrefix() {
        return "AlterTableRenamePartitionCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Map<String, String> map;
        int n = x$1;
        switch (n) {
            case 0: {
                map = this.tableName();
                break;
            }
            case 1: {
                map = this.oldPartition();
                break;
            }
            case 2: {
                map = this.newPartition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return map;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenamePartitionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenamePartitionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenamePartitionCommand alterTableRenamePartitionCommand = (AlterTableRenamePartitionCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRenamePartitionCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map = this.oldPartition();
        Map<String, String> map2 = alterTableRenamePartitionCommand.oldPartition();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<String, String> map3 = this.newPartition();
        Map<String, String> map4 = alterTableRenamePartitionCommand.newPartition();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (!alterTableRenamePartitionCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRenamePartitionCommand(TableIdentifier tableName, Map<String, String> oldPartition, Map<String, String> newPartition) {
        this.tableName = tableName;
        this.oldPartition = oldPartition;
        this.newPartition = newPartition;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

