/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PrunedInMemoryFileIndex;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u000b\u0017\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011)\u0019!C\u0001i!AQ\b\u0001B\u0001B\u0003%Q\u0007\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0011@\u0011!\u0019\u0005A!A!\u0002\u0013\u0001\u0005\"\u0002#\u0001\t\u0003)\u0005b\u0002&\u0001\u0005\u0004%\tb\u0013\u0005\u0007)\u0002\u0001\u000b\u0011\u0002'\t\u000fU\u0003!\u0019!C\u0005-\"1!\f\u0001Q\u0001\n]Cqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004i\u0001\u0001\u0006I!\u0018\u0005\u0006S\u0002!\tE\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!a\u000e\u0001\t\u0003\tI\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u00111\u000f\u0001\u0005B\u0005U$\u0001E\"bi\u0006dwn\u001a$jY\u0016Le\u000eZ3y\u0015\t9\u0002$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\r\u001b\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005%1\u0015\u000e\\3J]\u0012,\u00070\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00021c5\t!$\u0003\u000235\ta1\u000b]1sWN+7o]5p]\u0006)A/\u00192mKV\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u000591-\u0019;bY><'B\u0001\u001e\u001b\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001f8\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003\u0019!\u0018M\u00197fA\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t+\u0005\u0001\u0005CA\u0013B\u0013\t\u0011eE\u0001\u0003M_:<\u0017\u0001D:ju\u0016LeNQ=uKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003G\u000f\"K\u0005CA\u0016\u0001\u0011\u0015qc\u00011\u00010\u0011\u0015\u0019d\u00011\u00016\u0011\u0015qd\u00011\u0001A\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005G>tgM\u0003\u0002R=\u00051\u0001.\u00193p_BL!a\u0015(\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\u0002\u001f\u0019LG.Z*uCR,8oQ1dQ\u0016,\u0012a\u0016\t\u0003WaK!!\u0017\f\u0003\u001f\u0019KG.Z*uCR,8oQ1dQ\u0016\f\u0001CZ5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0019\t\f7/\u001a'pG\u0006$\u0018n\u001c8\u0016\u0003u\u00032!\n0a\u0013\tyfE\u0001\u0004PaRLwN\u001c\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f1A\\3u\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u0007U\u0013\u0016*A\u0007cCN,Gj\\2bi&|g\u000eI\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nCV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002o5\u0005)A/\u001f9fg&\u0011\u0001/\u001c\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!\u0003:p_R\u0004\u0016\r\u001e5t+\u0005\u0019\bc\u0001;}\u007f:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003q\n\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005m4\u0013a\u00029bG.\fw-Z\u0005\u0003{z\u00141aU3r\u0015\tYh\u0005\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001U\u0001\u0003MNLA!!\u0003\u0002\u0004\t!\u0001+\u0019;i\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0004\u0002\u0010\u0005]\u0011\u0011\u0006\t\u0005ir\f\t\u0002E\u0002,\u0003'I1!!\u0006\u0017\u0005I\u0001\u0016M\u001d;ji&|g\u000eR5sK\u000e$xN]=\t\u000f\u0005eq\u00021\u0001\u0002\u001c\u0005\u0001\u0002/\u0019:uSRLwN\u001c$jYR,'o\u001d\t\u0005ir\fi\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#O\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002(\u0005\u0005\"AC#yaJ,7o]5p]\"9\u00111F\bA\u0002\u0005m\u0011a\u00033bi\u00064\u0015\u000e\u001c;feN\fqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u00022A\u0019Q%a\r\n\u0007\u0005UbE\u0001\u0003V]&$\u0018\u0001\u00054jYR,'\u000fU1si&$\u0018n\u001c8t)\u0011\tY$!\u0011\u0011\u0007-\ni$C\u0002\u0002@Y\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0011\u001d\t\u0019%\u0005a\u0001\u00037\tqAZ5mi\u0016\u00148/\u0001\u0006j]B,HOR5mKN,\"!!\u0013\u0011\u000b\u0015\nY%a\u0014\n\u0007\u00055cEA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002R\u0005ec\u0002BA*\u0003+\u0002\"A\u001e\u0014\n\u0007\u0005]c%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\niF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/2\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0005%\u0004cA\u0013\u0002f%\u0019\u0011q\r\u0014\u0003\u000f\t{w\u000e\\3b]\"9\u00111N\nA\u0002\u00055\u0014!A8\u0011\u0007\u0015\ny'C\u0002\u0002r\u0019\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAA<!\r)\u0013\u0011P\u0005\u0004\u0003w2#aA%oi\u0002")
public class CatalogFileIndex
implements FileIndex {
    private final SparkSession sparkSession;
    private final CatalogTable table;
    private final long sizeInBytes;
    private final Configuration hadoopConf;
    private final FileStatusCache fileStatusCache;
    private final Option<URI> baseLocation;

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$(this);
    }

    public CatalogTable table() {
        return this.table;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStatusCache fileStatusCache() {
        return this.fileStatusCache;
    }

    private Option<URI> baseLocation() {
        return this.baseLocation;
    }

    @Override
    public StructType partitionSchema() {
        return this.table().partitionSchema();
    }

    @Override
    public Seq<Path> rootPaths() {
        return Option$.MODULE$.option2Iterable(this.baseLocation().map((Function1 & Serializable & scala.Serializable)x$1 -> new Path(x$1))).toSeq();
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.filterPartitions(partitionFilters).listFiles((Seq<Expression>)Nil$.MODULE$, dataFilters);
    }

    @Override
    public void refresh() {
        this.fileStatusCache().invalidateAll();
    }

    public InMemoryFileIndex filterPartitions(Seq<Expression> filters) {
        InMemoryFileIndex inMemoryFileIndex;
        if (this.table().partitionColumnNames().nonEmpty()) {
            long startTime = System.nanoTime();
            Seq selectedPartitions = this.sparkSession.sessionState().catalog().listPartitionsByFilter(this.table().identifier(), filters);
            Seq partitions = (Seq)selectedPartitions.map((Function1 & Serializable & scala.Serializable)p -> {
                Path path = new Path(p.location());
                FileSystem fs = path.getFileSystem(this.hadoopConf());
                return new PartitionPath(p.toRow(this.partitionSchema(), $this.sparkSession.sessionState().conf().sessionLocalTimeZone()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
            }, Seq$.MODULE$.canBuildFrom());
            PartitionSpec partitionSpec = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
            long timeNs = System.nanoTime() - startTime;
            inMemoryFileIndex = new PrunedInMemoryFileIndex(this.sparkSession, new Path((URI)this.baseLocation().get()), this.fileStatusCache(), partitionSpec, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)timeNs)));
        } else {
            inMemoryFileIndex = new InMemoryFileIndex(this.sparkSession, this.rootPaths(), (Map<String, String>)this.table().storage().properties(), (Option<StructType>)None$.MODULE$, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        }
        return inMemoryFileIndex;
    }

    @Override
    public String[] inputFiles() {
        return this.filterPartitions((Seq<Expression>)Nil$.MODULE$).inputFiles();
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof CatalogFileIndex) {
            CatalogFileIndex catalogFileIndex = (CatalogFileIndex)object;
            TableIdentifier tableIdentifier = this.table().identifier();
            TableIdentifier tableIdentifier2 = catalogFileIndex.table().identifier();
            bl = !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.table().identifier().hashCode();
    }

    public CatalogFileIndex(SparkSession sparkSession, CatalogTable table, long sizeInBytes) {
        this.sparkSession = sparkSession;
        this.table = table;
        this.sizeInBytes = sizeInBytes;
        FileIndex.$init$(this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        Predef$.MODULE$.assert(table.identifier().database().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "The table identifier must be qualified in CatalogFileIndex");
        this.baseLocation = table.storage().locationUri();
    }
}

