/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.BlockManagerBasedBlockHandler;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.RpcUtils$;
import org.spark-project.guava.base.Throwables;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.SynchronizedBuffer;
import scala.collection.script.Message;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5c!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013'5\ta!\u0003\u0002\u0015\r\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0004\u0001A\u0012\u0001$\b\t\u0004\u001deY\u0012B\u0001\u000e\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u000f\u001e\u0019\u0001!\u0011BH\u000b\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#\u0013'\u0005\u0002!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t9aj\u001c;iS:<\u0007CA\u0011(\u0013\tA#EA\u0002B]fD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0004K:4\bC\u0001\n-\u0013\ticA\u0001\u0005Ta\u0006\u00148.\u00128w\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014A\u00035bI>|\u0007oQ8oMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0005G>tgM\u0003\u00026\u0011\u00051\u0001.\u00193p_BL!a\u000e\u001a\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!I\u0004A!A!\u0002\u0013Q\u0014aE2iK\u000e\\\u0007o\\5oi\u0012K'o\u00149uS>t\u0007cA\u0011<{%\u0011AH\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y\neBA\u0011@\u0013\t\u0001%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!#\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q)q\tS'O\u001fB\u0011a\u0002\u0001\u0005\u0006\u0007\u0011\u0003\r!\u0013\u0019\u0003\u00152\u00032AD\rL!\taB\nB\u0005\u001f\u0011\u0006\u0005\t\u0011!B\u0001?!)!\u0006\u0012a\u0001W!)q\u0006\u0012a\u0001a!)\u0011\b\u0012a\u0001u!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001\u00035pgR\u0004vN\u001d;\u0016\u0003uBa\u0001\u0016\u0001!\u0002\u0013i\u0014!\u00035pgR\u0004vN\u001d;!\u0011\u001d1\u0006A1A\u0005\n]\u000bAC]3dK&4X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u0014X#\u0001-\u0011\u00059I\u0016B\u0001.\u0003\u0005Q\u0011VmY3jm\u0016$'\t\\8dW\"\u000bg\u000e\u001a7fe\"1A\f\u0001Q\u0001\na\u000bQC]3dK&4X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u0014\b\u0005C\u0004_\u0001\t\u0007I\u0011B0\u0002\u001fQ\u0014\u0018mY6fe\u0016sG\r]8j]R,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001a\t1A\u001d9d\u0013\t)'M\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\r\u001d\u0004\u0001\u0015!\u0003a\u0003A!(/Y2lKJ,e\u000e\u001a9pS:$\b\u0005C\u0004j\u0001\t\u0007I\u0011B0\u0002\u0011\u0015tG\r]8j]RDaa\u001b\u0001!\u0002\u0013\u0001\u0017!C3oIB|\u0017N\u001c;!\u0011\u001di\u0007A1A\u0005\n9\f!B\\3x\u00052|7m[%e+\u0005y\u0007C\u00019z\u001b\u0005\t(B\u0001:t\u0003\u0019\tGo\\7jG*\u0011A/^\u0001\u000bG>t7-\u001e:sK:$(B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!0\u001d\u0002\u000b\u0003R|W.[2M_:<\u0007B\u0002?\u0001A\u0003%q.A\u0006oK^\u0014En\\2l\u0013\u0012\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\u001ae\u0016<\u0017n\u001d;fe\u0016$'\t\\8dW\u001e+g.\u001a:bi>\u00148/\u0006\u0002\u0002\u0002I1\u00111AA\u0006\u0003C1q!!\u0002\u0002\b\u0001\t\tA\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0001\u0003i\u0011XmZ5ti\u0016\u0014X\r\u001a\"m_\u000e\\w)\u001a8fe\u0006$xN]:!!\u0019\ti!a\u0006\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005U!%\u0001\u0006d_2dWm\u0019;j_:LA!!\u0007\u0002\u0010\tY\u0011I\u001d:bs\n+hMZ3s!\rq\u0011QD\u0005\u0004\u0003?\u0011!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\t\u0007\u0003\u001b\t\u0019#a\u0007\n\t\u0005\u0015\u0012q\u0002\u0002\u0013'ft7\r\u001b:p]&TX\r\u001a\"vM\u001a,'\u000fC\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,\u0005iB-\u001a4bk2$(\t\\8dW\u001e+g.\u001a:bi>\u0014H*[:uK:,'/\u0006\u0002\u0002.I1\u0011qFA\u001b\u0003w1q!!\u0002\u00022\u0001\ti\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0017\u0003y!WMZ1vYR\u0014En\\2l\u000f\u0016tWM]1u_Jd\u0015n\u001d;f]\u0016\u0014\b\u0005E\u0002\"\u0003oI1!!\u000f#\u0005\u0019\te.\u001f*fMB\u0019a\"!\u0010\n\u0007\u0005}\"A\u0001\fCY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3s\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)%A\u000beK\u001a\fW\u000f\u001c;CY>\u001c7nR3oKJ\fGo\u001c:\u0016\u0005\u0005m\u0001\u0002CA%\u0001\u0001\u0006I!a\u0007\u0002-\u0011,g-Y;mi\ncwnY6HK:,'/\u0019;pe\u0002B\u0001\"!\u0014\u0001\t\u0003\"\u0011qJ\u0001\u0014O\u0016$8)\u001e:sK:$(+\u0019;f\u0019&l\u0017\u000e^\u000b\u0003\u0003#\u00022!IA*\u0013\r\t)F\t\u0002\u0005\u0019>tw\rC\u0004\u0002Z\u0001!\t!a\u0017\u0002\u0015A,8\u000f[*j]\u001edW\r\u0006\u0003\u0002^\u0005\r\u0004cA\u0011\u0002`%\u0019\u0011\u0011\r\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003K\n9\u00061\u0001'\u0003\u0011!\u0017\r^1\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u0005y\u0001/^:i\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0006\u0005\u0002^\u00055\u00141PAA\u0011!\ty'a\u001aA\u0002\u0005E\u0014aC1se\u0006L()\u001e4gKJ\u0004D!a\u001d\u0002xA1\u0011QBA\f\u0003k\u00022\u0001HA<\t-\tI(!\u001c\u0002\u0002\u0003\u0005)\u0011A\u0010\u0003\u0007}#3\u0007\u0003\u0005\u0002~\u0005\u001d\u0004\u0019AA@\u00039iW\r^1eCR\fw\n\u001d;j_:\u00042!I\u001e'\u0011!\t\u0019)a\u001aA\u0002\u0005\u0015\u0015!\u00042m_\u000e\\\u0017\nZ(qi&|g\u000e\u0005\u0003\"w\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055e!A\u0004ti>\u0014\u0018mZ3\n\t\u0005E\u00151\u0012\u0002\u000e'R\u0014X-Y7CY>\u001c7.\u00133\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006a\u0001/^:i\u0013R,'/\u0019;peRA\u0011QLAM\u0003{\u000by\f\u0003\u0005\u0002\u001c\u0006M\u0005\u0019AAO\u0003!IG/\u001a:bi>\u0014\b\u0007BAP\u0003s\u0003b!!)\u00022\u0006]f\u0002BAR\u0003[sA!!*\u0002,6\u0011\u0011q\u0015\u0006\u0004\u0003S3\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\r\tyKI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019,!.\u0003\u0011%#XM]1u_JT1!a,#!\ra\u0012\u0011\u0018\u0003\f\u0003w\u000bI*!A\u0001\u0002\u000b\u0005qDA\u0002`IQB\u0001\"! \u0002\u0014\u0002\u0007\u0011q\u0010\u0005\t\u0003\u0007\u000b\u0019\n1\u0001\u0002\u0006\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0017!\u00039vg\"\u0014\u0015\u0010^3t)!\ti&a2\u0002X\u0006e\u0007\u0002CAe\u0003\u0003\u0004\r!a3\u0002\u000b\tLH/Z:\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5x\u0003\rq\u0017n\\\u0005\u0005\u0003+\fyM\u0001\u0006CsR,')\u001e4gKJD\u0001\"! \u0002B\u0002\u0007\u0011q\u0010\u0005\t\u0003\u0007\u000b\t\r1\u0001\u0002\u0006\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017A\u00059vg\"\fe\u000e\u001a*fa>\u0014HO\u00117pG.$\u0002\"!\u0018\u0002b\u0006-\u0018Q\u001e\u0005\t\u0003G\fY\u000e1\u0001\u0002f\u0006i!/Z2fSZ,GM\u00117pG.\u00042ADAt\u0013\r\tIO\u0001\u0002\u000e%\u0016\u001cW-\u001b<fI\ncwnY6\t\u0011\u0005u\u00141\u001ca\u0001\u0003\u007fB\u0001\"a!\u0002\\\u0002\u0007\u0011Q\u0011\u0005\b\u0003c\u0004A\u0011AAz\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\r\u0005u\u0013Q_A}\u0011\u001d\t90a<A\u0002u\nq!\\3tg\u0006<W\r\u0003\u0005\u0002|\u0006=\b\u0019AA\u007f\u0003\u0015)'O]8s!\u0011\t\t+a@\n\t\t\u0005\u0011Q\u0017\u0002\n)\"\u0014xn^1cY\u0016DqA!\u0002\u0001\t#\u00129!A\u0004p]N#\u0018M\u001d;\u0015\u0005\u0005u\u0003b\u0002B\u0006\u0001\u0011E#QB\u0001\u0007_:\u001cFo\u001c9\u0015\r\u0005u#q\u0002B\t\u0011\u001d\t9P!\u0003A\u0002uB\u0001\"a?\u0003\n\u0001\u0007!1\u0003\t\u0005Cm\ni\u0010C\u0004\u0003\u0018\u0001!\tF!\u0007\u0002\u001f=t'+Z2fSZ,'o\u0015;beR$\"Aa\u0007\u0011\u0007\u0005\u0012i\"C\u0002\u0003 \t\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0003$\u0001!\tF!\n\u0002\u001d=t'+Z2fSZ,'o\u0015;paR1\u0011Q\fB\u0014\u0005SAq!a>\u0003\"\u0001\u0007Q\b\u0003\u0005\u0002|\n\u0005\u0002\u0019\u0001B\n\u0011\u001d\u0011i\u0003\u0001C!\u0005_\tAc\u0019:fCR,'\t\\8dW\u001e+g.\u001a:bi>\u0014H\u0003BA\u000e\u0005cA\u0001Ba\r\u0003,\u0001\u0007\u00111H\u0001\u0017E2|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\"9!q\u0007\u0001\u0005\n\te\u0012a\u00038fqR\u0014En\\2l\u0013\u0012,\"!a\"\t\u000f\tu\u0002\u0001\"\u0003\u0003@\u0005\u00012\r\\3b]V\u0004x\n\u001c3CY>\u001c7n\u001d\u000b\u0005\u0003;\u0012\t\u0005\u0003\u0005\u0003D\tm\u0002\u0019\u0001B#\u0003E\u0019G.Z1okB$\u0006N]3tQRKW.\u001a\t\u0005\u0005\u000f\u0012I%D\u0001\u0005\u0013\r\u0011Y\u0005\u0002\u0002\u0005)&lW\r")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    private final Receiver<?> receiver;
    public final SparkEnv org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env;
    private final String hostPort;
    private final ReceivedBlockHandler receivedBlockHandler;
    private final RpcEndpointRef trackerEndpoint;
    private final RpcEndpointRef endpoint;
    private final AtomicLong newBlockId;
    private final ArrayBuffer<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    private final BlockGeneratorListener defaultBlockGeneratorListener;
    private final BlockGenerator defaultBlockGenerator;

    private String hostPort() {
        return this.hostPort;
    }

    private ReceivedBlockHandler receivedBlockHandler() {
        return this.receivedBlockHandler;
    }

    private RpcEndpointRef trackerEndpoint() {
        return this.trackerEndpoint;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    public ArrayBuffer<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    }

    private BlockGeneratorListener defaultBlockGeneratorListener() {
        return this.defaultBlockGeneratorListener;
    }

    private BlockGenerator defaultBlockGenerator() {
        return this.defaultBlockGenerator;
    }

    @Override
    public long getCurrentRateLimit() {
        return this.defaultBlockGenerator().getCurrentLimit();
    }

    @Override
    public void pushSingle(Object data) {
        this.defaultBlockGenerator().addData(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ArrayBufferBlock(arrayBuffer), metadataOption, blockIdOption);
    }

    @Override
    public void pushIterator(Iterator<?> iterator, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new IteratorBlock(iterator), metadataOption, blockIdOption);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ByteBufferBlock(bytes), metadataOption, blockIdOption);
    }

    public void pushAndReportBlock(ReceivedBlock receivedBlock, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        StreamBlockId blockId = (StreamBlockId)blockIdOption.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final StreamBlockId apply() {
                return this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long time = System.currentTimeMillis();
        ReceivedBlockStoreResult blockStoreResult = this.receivedBlockHandler().storeBlock(blockId, receivedBlock);
        this.logDebug((Function0<String>)new Serializable(this, blockId, time){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;
            private final long time$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushed block ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.time$1))}));
            }
            {
                this.blockId$1 = blockId$1;
                this.time$1 = time$1;
            }
        });
        Option<Object> numRecords2 = blockStoreResult.numRecords();
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), numRecords2, metadataOption, blockStoreResult);
        this.trackerEndpoint().askWithRetry((Object)new AddBlock(blockInfo), ClassTag$.MODULE$.Boolean());
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final StreamBlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reported block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().send((Object)new ReportError(this.streamId(), message, errorString));
        this.logWarning((Function0<String>)new Serializable(this, message, error){
            public static final long serialVersionUID = 0L;
            private final String message$1;
            private final Throwable error$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Reported error ").append((Object)this.message$1).append((Object)" - ").append((Object)this.error$1).toString();
            }
            {
                this.message$1 = message$1;
                this.error$1 = error$1;
            }
        });
    }

    @Override
    public void onStart() {
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$1) {
                x$1.start();
            }
        });
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BlockGenerator x$2) {
                x$2.stop();
            }
        });
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv().stop(this.endpoint());
    }

    @Override
    public boolean onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.receiver.getClass().getSimpleName(), this.hostPort(), this.endpoint());
        return BoxesRunTime.unboxToBoolean((Object)this.trackerEndpoint().askWithRetry((Object)msg, ClassTag$.MODULE$.Boolean()));
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Deregistering receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String errorString = (String)error.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Throwable x$1) {
                return Throwables.getStackTraceAsString((Throwable)x$1);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.trackerEndpoint().askWithRetry((Object)new DeregisterReceiver(this.streamId(), message, errorString), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Stopped receiver ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.streamId())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockGenerator createBlockGenerator(BlockGeneratorListener blockGeneratorListener) {
        void var2_2;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().$minus$minus$eq((TraversableOnce)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BlockGenerator x$3) {
                return x$3.isStopped();
            }
        }));
        BlockGenerator newBlockGenerator = new BlockGenerator(blockGeneratorListener, this.streamId(), this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.conf(), BlockGenerator$.MODULE$.$lessinit$greater$default$4());
        ((SynchronizedBuffer)this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).$plus$eq((Object)newBlockGenerator);
        return var2_2;
    }

    public StreamBlockId org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public void org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(Time cleanupThreshTime) {
        this.logDebug((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning up blocks older then ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        this.receivedBlockHandler().cleanupOldBlocks(cleanupThreshTime.milliseconds());
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env, Configuration hadoopConf, Option<String> checkpointDirOption) {
        Logging logging;
        this.receiver = receiver;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env = env;
        super(receiver, env.conf());
        this.hostPort = SparkEnv$.MODULE$.get().blockManager().blockManagerId().hostPort();
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(env.conf())) {
            if (checkpointDirOption.isEmpty()) {
                throw new SparkException("Cannot enable receiver write-ahead log without checkpoint directory set. Please use streamingContext.checkpoint() to set the checkpoint directory. See documentation for more details.");
            }
            logging = new WriteAheadLogBasedBlockHandler(env.blockManager(), receiver.streamId(), receiver.storageLevel(), env.conf(), hadoopConf, (String)checkpointDirOption.get(), WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$7());
        } else {
            logging = new BlockManagerBasedBlockHandler(env.blockManager(), receiver.storageLevel());
        }
        this.receivedBlockHandler = logging;
        this.trackerEndpoint = RpcUtils$.MODULE$.makeDriverRef("ReceiverTracker", env.conf(), env.rpcEnv());
        this.endpoint = env.rpcEnv().setupEndpoint(new StringBuilder().append((Object)"Receiver-").append((Object)BoxesRunTime.boxToInteger((int)this.streamId())).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString(), (RpcEndpoint)new ThreadSafeRpcEndpoint(this){
            private final RpcEnv rpcEnv;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final RpcEndpointRef self() {
                return RpcEndpoint.class.self((RpcEndpoint)this);
            }

            public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
                return RpcEndpoint.class.receiveAndReply((RpcEndpoint)this, (RpcCallContext)context);
            }

            public void onError(Throwable cause) {
                RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
            }

            public void onStart() {
                RpcEndpoint.class.onStart((RpcEndpoint)this);
            }

            public void onStop() {
                RpcEndpoint.class.onStop((RpcEndpoint)this);
            }

            public void onConnected(RpcAddress remoteAddress) {
                RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onDisconnected(RpcAddress remoteAddress) {
                RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
                RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
            }

            public final void stop() {
                RpcEndpoint.class.stop((RpcEndpoint)this);
            }

            public RpcEnv rpcEnv() {
                return this.rpcEnv;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (StopReceiver$.MODULE$.equals(A1)) {
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Received stop signal";
                                }
                            });
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().stop("Stopped by driver", (Option<Throwable>)None$.MODULE$);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof CleanupOldBlocks) {
                            CleanupOldBlocks cleanupOldBlocks2 = (CleanupOldBlocks)A1;
                            Time threshTime = cleanupOldBlocks2.threshTime();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logDebug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Received delete old batch signal";
                                }
                            });
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(threshTime);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof UpdateRateLimit) {
                            UpdateRateLimit updateRateLimit = (UpdateRateLimit)A1;
                            long eps = updateRateLimit.elementsPerSecond();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)new Serializable(this, eps){
                                public static final long serialVersionUID = 0L;
                                private final long eps$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received a new rate limit: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.eps$1)}));
                                }
                                {
                                    this.eps$1 = eps$1;
                                }
                            });
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().foreach((Function1)new Serializable(this, eps){
                                public static final long serialVersionUID = 0L;
                                private final long eps$1;

                                public final void apply(BlockGenerator bg) {
                                    bg.updateRate(this.eps$1);
                                }
                                {
                                    this.eps$1 = eps$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        boolean bl = StopReceiver$.MODULE$.equals(object) ? true : (object instanceof CleanupOldBlocks ? true : object instanceof UpdateRateLimit);
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public /* synthetic */ ReceiverSupervisorImpl org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                RpcEndpoint.class.$init$((RpcEndpoint)this);
                this.rpcEnv = $outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv();
            }
        });
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators = new SynchronizedBuffer<BlockGenerator>(this){

            public /* synthetic */ int scala$collection$mutable$SynchronizedBuffer$$super$length() {
                return ResizableArray.class.length((ResizableArray)this);
            }

            public /* synthetic */ Iterator scala$collection$mutable$SynchronizedBuffer$$super$iterator() {
                return IndexedSeqLike.class.iterator((IndexedSeqLike)this);
            }

            public /* synthetic */ Object scala$collection$mutable$SynchronizedBuffer$$super$apply(int n) {
                return ResizableArray.class.apply((ResizableArray)this, (int)n);
            }

            public /* synthetic */ SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq(elem);
            }

            public /* synthetic */ Buffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus(GenTraversableOnce xs) {
                return BufferLike.class.$plus$plus((Buffer)this, (GenTraversableOnce)xs);
            }

            public /* synthetic */ SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq(xs);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$appendAll(TraversableOnce xs) {
                BufferLike.class.appendAll((Buffer)this, (TraversableOnce)xs);
            }

            public /* synthetic */ SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$eq$colon(Object elem) {
                return (SynchronizedBuffer)super.$plus$eq$colon(elem);
            }

            public /* synthetic */ SynchronizedBuffer scala$collection$mutable$SynchronizedBuffer$$super$$plus$plus$eq$colon(TraversableOnce xs) {
                return (SynchronizedBuffer)super.$plus$plus$eq$colon(xs);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$prependAll(TraversableOnce xs) {
                BufferLike.class.prependAll((Buffer)this, (TraversableOnce)xs);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$insertAll(int n, Traversable elems) {
                super.insertAll(n, elems);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$update(int n, Object newelem) {
                ResizableArray.class.update((ResizableArray)this, (int)n, (Object)newelem);
            }

            public /* synthetic */ Object scala$collection$mutable$SynchronizedBuffer$$super$remove(int n) {
                return super.remove(n);
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$clear() {
                super.clear();
            }

            public /* synthetic */ void scala$collection$mutable$SynchronizedBuffer$$super$$less$less(Message cmd) {
                BufferLike.class.$less$less((Buffer)this, (Message)cmd);
            }

            public /* synthetic */ Buffer scala$collection$mutable$SynchronizedBuffer$$super$clone() {
                return BufferLike.class.clone((Buffer)this);
            }

            public /* synthetic */ int scala$collection$mutable$SynchronizedBuffer$$super$hashCode() {
                return IndexedSeqLike.class.hashCode((IndexedSeqLike)this);
            }

            public int length() {
                return SynchronizedBuffer.class.length((SynchronizedBuffer)this);
            }

            public Iterator<BlockGenerator> iterator() {
                return SynchronizedBuffer.class.iterator((SynchronizedBuffer)this);
            }

            public Object apply(int n) {
                return SynchronizedBuffer.class.apply((SynchronizedBuffer)this, (int)n);
            }

            public SynchronizedBuffer $plus$eq(Object elem) {
                return SynchronizedBuffer.class.$plus$eq((SynchronizedBuffer)this, (Object)elem);
            }

            public Buffer<BlockGenerator> $plus$plus(GenTraversableOnce<BlockGenerator> xs) {
                return SynchronizedBuffer.class.$plus$plus((SynchronizedBuffer)this, xs);
            }

            public SynchronizedBuffer<BlockGenerator> $plus$plus$eq(TraversableOnce<BlockGenerator> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq((SynchronizedBuffer)this, xs);
            }

            public void append(Seq<BlockGenerator> elems) {
                SynchronizedBuffer.class.append((SynchronizedBuffer)this, elems);
            }

            public void appendAll(TraversableOnce<BlockGenerator> xs) {
                SynchronizedBuffer.class.appendAll((SynchronizedBuffer)this, xs);
            }

            public SynchronizedBuffer $plus$eq$colon(Object elem) {
                return SynchronizedBuffer.class.$plus$eq$colon((SynchronizedBuffer)this, (Object)elem);
            }

            public SynchronizedBuffer<BlockGenerator> $plus$plus$eq$colon(TraversableOnce<BlockGenerator> xs) {
                return SynchronizedBuffer.class.$plus$plus$eq$colon((SynchronizedBuffer)this, xs);
            }

            public void prepend(Seq<BlockGenerator> elems) {
                SynchronizedBuffer.class.prepend((SynchronizedBuffer)this, elems);
            }

            public void prependAll(TraversableOnce<BlockGenerator> xs) {
                SynchronizedBuffer.class.prependAll((SynchronizedBuffer)this, xs);
            }

            public void insert(int n, Seq<BlockGenerator> elems) {
                SynchronizedBuffer.class.insert((SynchronizedBuffer)this, (int)n, elems);
            }

            public void insertAll(int n, Traversable<BlockGenerator> xs) {
                SynchronizedBuffer.class.insertAll((SynchronizedBuffer)this, (int)n, xs);
            }

            public void update(int n, Object newelem) {
                SynchronizedBuffer.class.update((SynchronizedBuffer)this, (int)n, (Object)newelem);
            }

            public Object remove(int n) {
                return SynchronizedBuffer.class.remove((SynchronizedBuffer)this, (int)n);
            }

            public void clear() {
                SynchronizedBuffer.class.clear((SynchronizedBuffer)this);
            }

            public void $less$less(Message<BlockGenerator> cmd) {
                SynchronizedBuffer.class.$less$less((SynchronizedBuffer)this, cmd);
            }

            public Buffer<BlockGenerator> clone() {
                return SynchronizedBuffer.class.clone((SynchronizedBuffer)this);
            }

            public int hashCode() {
                return SynchronizedBuffer.class.hashCode((SynchronizedBuffer)this);
            }
            {
                SynchronizedBuffer.class.$init$((SynchronizedBuffer)this);
            }
        };
        this.defaultBlockGeneratorListener = new BlockGeneratorListener(this){
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public void onAddData(Object data, Object metadata) {
            }

            public void onGenerateBlock(StreamBlockId blockId) {
            }

            public void onError(String message, Throwable throwable) {
                this.$outer.reportError(message, throwable);
            }

            public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
                this.$outer.pushArrayBuffer(arrayBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)new Some((Object)blockId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.defaultBlockGenerator = this.createBlockGenerator(this.defaultBlockGeneratorListener());
    }
}

