/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tapestry5.internal.plastic.AnnotationBuilder;
import org.apache.tapestry5.internal.plastic.Cache;
import org.apache.tapestry5.internal.plastic.ClassLoaderDelegate;
import org.apache.tapestry5.internal.plastic.EmptyAnnotationAccess;
import org.apache.tapestry5.internal.plastic.FieldInstrumentation;
import org.apache.tapestry5.internal.plastic.FieldInstrumentations;
import org.apache.tapestry5.internal.plastic.InheritanceData;
import org.apache.tapestry5.internal.plastic.InternalPlasticClassTransformation;
import org.apache.tapestry5.internal.plastic.PlasticClassImpl;
import org.apache.tapestry5.internal.plastic.PlasticClassLoader;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.StaticContext;
import org.apache.tapestry5.internal.plastic.TypeCategory;
import org.apache.tapestry5.internal.plastic.asm.ClassReader;
import org.apache.tapestry5.internal.plastic.asm.ClassWriter;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.internal.plastic.asm.tree.AbstractInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.AnnotationNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.FieldInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.InsnList;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.plastic.AnnotationAccess;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.ClassType;
import org.apache.tapestry5.plastic.PlasticClassEvent;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassListenerHub;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticManagerDelegate;
import org.apache.tapestry5.plastic.TransformationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlasticClassPool
implements ClassLoaderDelegate,
Opcodes,
PlasticClassListenerHub {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlasticClassPool.class);
    final PlasticClassLoader loader;
    private final PlasticManagerDelegate delegate;
    private final Set<String> controlledPackages;
    private final Map<String, Boolean> checkedExceptionCache = new HashMap<String, Boolean>();
    private final Stack<String> activeInstrumentClassNames = new Stack();
    private final Map<String, ClassInstantiator> instantiators = PlasticInternalUtils.newConcurrentMap();
    private final InheritanceData emptyInheritanceData = new InheritanceData(null);
    private final StaticContext emptyStaticContext = new StaticContext();
    private final List<PlasticClassListener> listeners = new CopyOnWriteArrayList<PlasticClassListener>();
    private final Cache<String, TypeCategory> typeName2Category = new Cache<String, TypeCategory>(){

        @Override
        protected TypeCategory convert(String typeName) {
            ClassNode cn = PlasticClassPool.this.constructClassNodeFromBytecode(typeName);
            return Modifier.isInterface(cn.access) ? TypeCategory.INTERFACE : TypeCategory.CLASS;
        }
    };
    private final Map<String, BaseClassDef> baseClassDefs = PlasticInternalUtils.newMap();
    private final Map<String, FieldInstrumentations> instrumentations = PlasticInternalUtils.newMap();
    private final Map<String, String> transformedClassNameToImplementationClassName = PlasticInternalUtils.newMap();
    private final FieldInstrumentations placeholder = new FieldInstrumentations(null);
    private final Set<TransformationOption> options;

    public PlasticClassPool(ClassLoader parentLoader, PlasticManagerDelegate delegate, Set<String> controlledPackages, Set<TransformationOption> options) {
        this.loader = new PlasticClassLoader(parentLoader, this);
        this.delegate = delegate;
        this.controlledPackages = controlledPackages;
        this.options = options;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class realizeTransformedClass(ClassNode classNode, InheritanceData inheritanceData, StaticContext staticContext) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            Class result = this.realize(PlasticInternalUtils.toClassName(classNode.name), ClassType.PRIMARY, classNode);
            this.baseClassDefs.put(result.getName(), new BaseClassDef(inheritanceData, staticContext));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class realize(String primaryClassName, ClassType classType, ClassNode classNode) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            if (!this.listeners.isEmpty()) {
                this.fire(this.toEvent(primaryClassName, classType, classNode));
            }
            byte[] bytecode = this.toBytecode(classNode);
            String className = PlasticInternalUtils.toClassName(classNode.name);
            return this.loader.defineClassWithBytecode(className, bytecode);
        }
    }

    private PlasticClassEvent toEvent(final String primaryClassName, final ClassType classType, final ClassNode classNode) {
        return new PlasticClassEvent(){

            @Override
            public ClassType getType() {
                return classType;
            }

            @Override
            public String getPrimaryClassName() {
                return primaryClassName;
            }

            @Override
            public String getDissasembledBytecode() {
                return PlasticInternalUtils.dissasembleBytecode(classNode);
            }

            @Override
            public String getClassName() {
                return PlasticInternalUtils.toClassName(classNode.name);
            }
        };
    }

    private void fire(PlasticClassEvent event) {
        for (PlasticClassListener listener : this.listeners) {
            listener.classWillLoad(event);
        }
    }

    private byte[] toBytecode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept(writer);
        return writer.toByteArray();
    }

    public AnnotationAccess createAnnotationAccess(String className) {
        try {
            final Class<?> searchClass = this.loader.loadClass(className);
            return new AnnotationAccess(){

                @Override
                public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
                    return this.getAnnotation(annotationType) != null;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    return searchClass.getAnnotation(annotationType);
                }
            };
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public AnnotationAccess createAnnotationAccess(List<AnnotationNode> annotationNodes) {
        if (annotationNodes == null) {
            return EmptyAnnotationAccess.SINGLETON;
        }
        final Map cache = PlasticInternalUtils.newMap();
        final Map<String, AnnotationNode> nameToNode = PlasticInternalUtils.newMap();
        for (AnnotationNode node : annotationNodes) {
            nameToNode.put(PlasticInternalUtils.objectDescriptorToClassName(node.desc), node);
        }
        return new AnnotationAccess(){

            @Override
            public <T extends Annotation> boolean hasAnnotation(Class<T> annotationType) {
                return nameToNode.containsKey(annotationType.getName());
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                String className = annotationType.getName();
                Object result = cache.get(className);
                if (result == null && (result = this.buildAnnotation(className)) != null) {
                    cache.put(className, result);
                }
                return (T)((Annotation)annotationType.cast(result));
            }

            private Object buildAnnotation(String className) {
                AnnotationNode node = (AnnotationNode)nameToNode.get(className);
                if (node == null) {
                    return null;
                }
                return PlasticClassPool.this.createAnnotation(className, node);
            }
        };
    }

    Class loadClass(String className) {
        try {
            return this.loader.loadClass(className);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to load class %s: %s", className, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    protected Object createAnnotation(String className, AnnotationNode node) {
        AnnotationBuilder builder = new AnnotationBuilder(this.loadClass(className), this);
        node.accept(builder);
        return builder.createAnnotation();
    }

    @Override
    public boolean shouldInterceptClassLoading(String className) {
        int dotx;
        int searchFromIndex = className.length() - 1;
        while ((dotx = className.lastIndexOf(46, searchFromIndex)) >= 0) {
            String packageName = className.substring(0, dotx);
            if (this.controlledPackages.contains(packageName)) {
                return true;
            }
            searchFromIndex = dotx - 1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Class<?> loadAndTransformClass(String className) throws ClassNotFoundException {
        if (className.contains("$")) {
            return this.loadInnerClass(className);
        }
        if (this.activeInstrumentClassNames.contains(className)) {
            StringBuilder builder = new StringBuilder("");
            String sep = "";
            for (String name : this.activeInstrumentClassNames) {
                builder.append(sep);
                builder.append(name);
                sep = ", ";
            }
            throw new IllegalStateException(String.format("Unable to transform class %s as it is already in the process of being transformed; there is a cycle among the following classes: %s.", className, builder));
        }
        this.activeInstrumentClassNames.push(className);
        try {
            InternalPlasticClassTransformation transformation = this.getPlasticClassTransformation(className);
            this.delegate.transform(transformation.getPlasticClass());
            ClassInstantiator createInstantiator = transformation.createInstantiator();
            ClassInstantiator configuredInstantiator = this.delegate.configureInstantiator(className, createInstantiator);
            this.instantiators.put(className, configuredInstantiator);
            Class<?> clazz = transformation.getTransformedClass();
            return clazz;
        }
        finally {
            this.activeInstrumentClassNames.pop();
        }
    }

    private Class loadInnerClass(String className) {
        ClassNode classNode = this.constructClassNodeFromBytecode(className);
        this.interceptFieldAccess(classNode);
        return this.realize(className, ClassType.INNER, classNode);
    }

    private void interceptFieldAccess(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            this.interceptFieldAccess(classNode.name, method);
        }
    }

    private void interceptFieldAccess(String classInternalName, MethodNode method) {
        InsnList insns = method.instructions;
        Iterator it = insns.iterator();
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            int opcode = node.getOpcode();
            if (opcode != 180 && opcode != 181) continue;
            FieldInsnNode fnode = (FieldInsnNode)node;
            String ownerInternalName = fnode.owner;
            if (ownerInternalName.equals(classInternalName)) continue;
            FieldInstrumentation instrumentation = this.getFieldInstrumentation(ownerInternalName, fnode.name, opcode == 180);
            if (instrumentation == null) continue;
            insns.insertBefore((AbstractInsnNode)fnode, new MethodInsnNode(182, ownerInternalName, instrumentation.methodName, instrumentation.methodDescription, false));
            it.remove();
        }
    }

    public InternalPlasticClassTransformation getPlasticClassTransformation(String className) throws ClassNotFoundException {
        assert (PlasticInternalUtils.isNonBlank(className));
        ClassNode classNode = this.constructClassNodeFromBytecode(className);
        String baseClassName = PlasticInternalUtils.toClassName(classNode.superName);
        this.instrumentations.put(classNode.name, new FieldInstrumentations(classNode.superName));
        return this.createTransformation(baseClassName, classNode, null, false);
    }

    private InternalPlasticClassTransformation createTransformation(String baseClassName, ClassNode classNode, ClassNode implementationClassNode, boolean proxy) throws ClassNotFoundException {
        if (this.shouldInterceptClassLoading(baseClassName)) {
            this.loader.loadClass(baseClassName);
            BaseClassDef def = this.baseClassDefs.get(baseClassName);
            assert (def != null);
            return new PlasticClassImpl(classNode, implementationClassNode, this, def.inheritanceData, def.staticContext, proxy);
        }
        return new PlasticClassImpl(classNode, implementationClassNode, this, this.emptyInheritanceData, this.emptyStaticContext, proxy);
    }

    public ClassNode constructClassNodeFromBytecode(String className) {
        byte[] bytecode = this.readBytecode(className);
        if (bytecode == null) {
            return null;
        }
        return PlasticInternalUtils.convertBytecodeToClassNode(bytecode);
    }

    private byte[] readBytecode(String className) {
        ClassLoader parentClassLoader = this.loader.getParent();
        return PlasticInternalUtils.readBytecodeForClass(parentClassLoader, className, true);
    }

    public PlasticClassTransformation createTransformation(String baseClassName, String newClassName) {
        return this.createTransformation(baseClassName, newClassName, null);
    }

    public PlasticClassTransformation createTransformation(String baseClassName, String newClassName, String implementationClassName) {
        try {
            ClassNode newClassNode = new ClassNode();
            String internalNewClassNameinternalName = PlasticInternalUtils.toInternalName(newClassName);
            String internalBaseClassName = PlasticInternalUtils.toInternalName(baseClassName);
            newClassNode.visit(50, 1, internalNewClassNameinternalName, null, internalBaseClassName, null);
            ClassNode implementationClassNode = null;
            if (implementationClassName != null) {
                if (this.transformedClassNameToImplementationClassName.containsKey(implementationClassName)) {
                    implementationClassName = this.transformedClassNameToImplementationClassName.get(implementationClassName);
                }
                if (!implementationClassName.startsWith("com.sun.proxy")) {
                    try {
                        implementationClassNode = this.readClassNode(implementationClassName);
                    }
                    catch (IOException e) {
                        LOGGER.warn(String.format("Unable to load class %s as the implementation of service %s", implementationClassName, baseClassName));
                    }
                }
                this.transformedClassNameToImplementationClassName.put(newClassName, implementationClassName);
            }
            return this.createTransformation(baseClassName, newClassNode, implementationClassNode, true);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(String.format("Unable to create class %s as sub-class of %s: %s", newClassName, baseClassName, PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    private ClassNode readClassNode(String className) throws IOException {
        return PlasticClassPool.readClassNode(className, this.getClassLoader());
    }

    static ClassNode readClassNode(String className, ClassLoader classLoader) throws IOException {
        ClassNode classNode = new ClassNode();
        String location = PlasticInternalUtils.toInternalName(className) + ".class";
        InputStream inputStream = classLoader.getResourceAsStream(location);
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        ClassReader classReader = new ClassReader(inputStream);
        inputStream.close();
        bis.close();
        classReader.accept(classNode, 0);
        return classNode;
    }

    public ClassInstantiator getClassInstantiator(String className) {
        ClassInstantiator result = this.instantiators.get(className);
        if (result == null) {
            try {
                this.loader.loadClass(className);
                result = this.instantiators.get(className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (result != null) {
            return result;
        }
        StringBuilder b = new StringBuilder();
        b.append("Class '").append(className).append("' is not a transformed class. Transformed classes should be in one of the following packages: ");
        String sep = "";
        ArrayList<String> names = new ArrayList<String>(this.controlledPackages);
        Collections.sort(names);
        for (String name : names) {
            b.append(sep);
            b.append(name);
            sep = ", ";
        }
        String message = b.append('.').toString();
        throw new IllegalArgumentException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeCategory getTypeCategory(String typeName) {
        PlasticClassLoader plasticClassLoader = this.loader;
        synchronized (plasticClassLoader) {
            return this.typeName2Category.get(typeName);
        }
    }

    @Override
    public void addPlasticClassListener(PlasticClassListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    @Override
    public void removePlasticClassListener(PlasticClassListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    boolean isEnabled(TransformationOption option) {
        return this.options.contains((Object)option);
    }

    void setFieldReadInstrumentation(String classInternalName, String fieldName, FieldInstrumentation fi) {
        this.instrumentations.get((Object)classInternalName).read.put(fieldName, fi);
    }

    private FieldInstrumentations getFieldInstrumentations(String classInternalName) {
        FieldInstrumentations result = this.instrumentations.get(classInternalName);
        if (result != null) {
            return result;
        }
        String className = PlasticInternalUtils.toClassName(classInternalName);
        if (!className.contains("$") && this.shouldInterceptClassLoading(className)) {
            try {
                this.loadAndTransformClass(className);
                return this.instrumentations.get(classInternalName);
            }
            catch (Exception ex) {
                throw new RuntimeException(PlasticInternalUtils.toMessage(ex), ex);
            }
        }
        result = this.placeholder;
        this.instrumentations.put(classInternalName, result);
        return result;
    }

    FieldInstrumentation getFieldInstrumentation(String ownerClassInternalName, String fieldName, boolean forRead) {
        String currentName = ownerClassInternalName;
        while (currentName != null) {
            FieldInstrumentations instrumentations = this.getFieldInstrumentations(currentName);
            FieldInstrumentation instrumentation = instrumentations.get(fieldName, forRead);
            if (instrumentation != null) {
                return instrumentation;
            }
            currentName = instrumentations.superClassInternalName;
        }
        return null;
    }

    void setFieldWriteInstrumentation(String classInternalName, String fieldName, FieldInstrumentation fi) {
        this.instrumentations.get((Object)classInternalName).write.put(fieldName, fi);
    }

    boolean isCheckedException(String exceptionName) {
        Boolean cached = this.checkedExceptionCache.get(exceptionName);
        if (cached != null) {
            return cached;
        }
        try {
            Class<?> asClass = this.getClassLoader().loadClass(exceptionName);
            boolean checked = !Error.class.isAssignableFrom(asClass) && !RuntimeException.class.isAssignableFrom(asClass);
            this.checkedExceptionCache.put(exceptionName, checked);
            return checked;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class BaseClassDef {
        final InheritanceData inheritanceData;
        final StaticContext staticContext;

        public BaseClassDef(InheritanceData inheritanceData, StaticContext staticContext) {
            this.inheritanceData = inheritanceData;
            this.staticContext = staticContext;
        }
    }
}

