/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.tephra.AbstractTransactionAwareTable;
import org.apache.tephra.Transaction;
import org.apache.tephra.TransactionAware;
import org.apache.tephra.TxConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAwareHTable
extends AbstractTransactionAwareTable
implements Table,
TransactionAware {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionAwareHTable.class);
    private final Table hTable;

    public TransactionAwareHTable(Table hTable) {
        this(hTable, false);
    }

    public TransactionAwareHTable(Table hTable, TxConstants.ConflictDetection conflictLevel) {
        this(hTable, conflictLevel, false);
    }

    public TransactionAwareHTable(Table hTable, boolean allowNonTransactional) {
        this(hTable, TxConstants.ConflictDetection.COLUMN, allowNonTransactional);
    }

    public TransactionAwareHTable(Table hTable, TxConstants.ConflictDetection conflictLevel, boolean allowNonTransactional) {
        super(conflictLevel, allowNonTransactional, hTable.getConfiguration().getBoolean("data.tx.pre.014.changeset.key", true));
        this.hTable = hTable;
    }

    protected byte[] getTableKey() {
        return this.hTable.getName().getName();
    }

    protected boolean doCommit() throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRollback() throws Exception {
        try {
            int size = 0;
            for (Set cs : this.changeSets.values()) {
                size += cs.size();
            }
            ArrayList<Delete> rollbackDeletes = new ArrayList<Delete>(size);
            for (Map.Entry entry : this.changeSets.entrySet()) {
                long transactionTimestamp = (Long)entry.getKey();
                for (AbstractTransactionAwareTable.ActionChange change : (Set)entry.getValue()) {
                    byte[] row = change.getRow();
                    byte[] family = change.getFamily();
                    byte[] qualifier = change.getQualifier();
                    Delete rollbackDelete = new Delete(row);
                    this.makeRollbackOperation(rollbackDelete);
                    switch (this.conflictLevel) {
                        case ROW: 
                        case NONE: {
                            rollbackDelete.addFamilyVersion(change.getFamily(), transactionTimestamp);
                            break;
                        }
                        case COLUMN: {
                            if (family != null && qualifier == null) {
                                rollbackDelete.addFamilyVersion(family, transactionTimestamp);
                                break;
                            }
                            if (family == null || qualifier == null) break;
                            rollbackDelete.addColumn(family, qualifier, transactionTimestamp);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown conflict detection level: " + this.conflictLevel);
                        }
                    }
                    rollbackDeletes.add(rollbackDelete);
                }
            }
            this.hTable.delete(rollbackDeletes);
            boolean bl = true;
            return bl;
        }
        finally {
            this.tx = null;
            this.changeSets.clear();
        }
    }

    public TableName getName() {
        return this.hTable.getName();
    }

    public Configuration getConfiguration() {
        return this.hTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.hTable.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.exists(this.transactionalizeAction(get));
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batch(this.transactionalizeActions(actions), results);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.batchCallback(this.transactionalizeActions(actions), results, callback);
    }

    public Result get(Get get) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.get(this.transactionalizeAction(get));
    }

    public Result[] get(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>();
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.get(transactionalizedGets);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.hTable.getScanner(this.transactionalizeAction(scan));
    }

    public void put(Put put) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        Put txPut = this.transactionalizeAction(put);
        this.hTable.put(txPut);
    }

    public void put(List<Put> puts) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Put> transactionalizedPuts = new ArrayList<Put>(puts.size());
        for (Put put : puts) {
            Put txPut = this.transactionalizeAction(put);
            transactionalizedPuts.add(txPut);
        }
        this.hTable.put(transactionalizedPuts);
    }

    public void delete(Delete delete) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        this.hTable.delete(this.transactionalizeAction(delete));
    }

    public void delete(List<Delete> deletes) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Delete> transactionalizedDeletes = new ArrayList<Delete>(deletes.size());
        for (Delete delete : deletes) {
            Delete txDelete = this.transactionalizeAction(delete);
            transactionalizedDeletes.add(txDelete);
        }
        this.hTable.delete(transactionalizedDeletes);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(row, family, qualifier, value, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(row, family, qualifier, value, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndDelete(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(bytes, bytes1, bytes2, compareOp, bytes3, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndPut(byte[] bytes, byte[] bytes1, byte[] bytes2, CompareFilter.CompareOp compareOp, byte[] bytes3, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(bytes, bytes1, bytes2, compareOp, bytes3, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, RowMutations rowMutations) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndMutate(row, family, qualifier, compareOp, value, rowMutations);
        }
        throw new UnsupportedOperationException("checkAndMutate operation is not supported transactionally");
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndPut(row, family, qualifier, value, put);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndDelete(row, family, qualifier, op, value, delete);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndMutate(row, family, qualifier, op, value, mutation);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public boolean[] existsAll(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>(gets.size());
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.existsAll(transactionalizedGets);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        RowMutations transactionalMutations = new RowMutations(rm.getRow());
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                transactionalMutations.add(this.transactionalizeAction((Put)mutation));
                continue;
            }
            if (!(mutation instanceof Delete)) continue;
            transactionalMutations.add(this.transactionalizeAction((Delete)mutation));
        }
        this.hTable.mutateRow(transactionalMutations);
    }

    public Result append(Append append) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.append(append);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public Result increment(Increment increment) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.increment(increment);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        if (this.allowNonTransactional) {
            return this.hTable.incrementColumnValue(row, family, qualifier, amount, durability);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    public void close() throws IOException {
        this.hTable.close();
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.hTable.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.hTable.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.hTable.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype) throws ServiceException, Throwable {
        return this.hTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype);
    }

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor methodDescriptor, Message request, byte[] startKey, byte[] endKey, R responsePrototype, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.hTable.batchCoprocessorService(methodDescriptor, request, startKey, endKey, responsePrototype, callback);
    }

    public void addToOperation(OperationWithAttributes op, Transaction tx) throws IOException {
        op.setAttribute("tephra.tx", this.txCodec.encode(tx));
    }

    protected void makeRollbackOperation(Delete delete) {
        delete.setAttribute("tephra.tx.rollback", new byte[0]);
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.hTable.getDescriptor();
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        if (this.tx == null) {
            throw new IOException("Transaction not started");
        }
        ArrayList<Get> transactionalizedGets = new ArrayList<Get>(gets.size());
        for (Get get : gets) {
            transactionalizedGets.add(this.transactionalizeAction(get));
        }
        return this.hTable.exists(transactionalizedGets);
    }

    public long getRpcTimeout(TimeUnit unit) {
        return this.hTable.getRpcTimeout(unit);
    }

    public int getRpcTimeout() {
        return this.hTable.getRpcTimeout();
    }

    public void setRpcTimeout(int rpcTimeout) {
        this.hTable.setRpcTimeout(rpcTimeout);
    }

    public long getReadRpcTimeout(TimeUnit unit) {
        return this.hTable.getReadRpcTimeout(unit);
    }

    public int getReadRpcTimeout() {
        return this.hTable.getReadRpcTimeout();
    }

    public void setReadRpcTimeout(int readRpcTimeout) {
        this.hTable.setReadRpcTimeout(readRpcTimeout);
    }

    public long getWriteRpcTimeout(TimeUnit unit) {
        return this.hTable.getWriteRpcTimeout(unit);
    }

    public int getWriteRpcTimeout() {
        return this.hTable.getWriteRpcTimeout();
    }

    public void setWriteRpcTimeout(int writeRpcTimeout) {
        this.hTable.setWriteRpcTimeout(writeRpcTimeout);
    }

    public long getOperationTimeout(TimeUnit unit) {
        return this.hTable.getOperationTimeout(unit);
    }

    public int getOperationTimeout() {
        return this.hTable.getOperationTimeout();
    }

    public void setOperationTimeout(int operationTimeout) {
        this.hTable.setOperationTimeout(operationTimeout);
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        if (this.allowNonTransactional) {
            return this.hTable.checkAndMutate(row, family);
        }
        throw new UnsupportedOperationException("Operation is not supported transactionally");
    }

    private Get transactionalizeAction(Get get) throws IOException {
        this.addToOperation((OperationWithAttributes)get, this.tx);
        return get;
    }

    private Scan transactionalizeAction(Scan scan) throws IOException {
        this.addToOperation((OperationWithAttributes)scan, this.tx);
        return scan;
    }

    private Put transactionalizeAction(Put put) throws IOException {
        Put txPut = new Put(put.getRow(), this.tx.getWritePointer());
        Set familyMap = put.getFamilyCellMap().entrySet();
        if (!familyMap.isEmpty()) {
            for (Map.Entry family : familyMap) {
                List familyValues = (List)family.getValue();
                if (familyValues.isEmpty()) continue;
                for (Cell value : familyValues) {
                    txPut.addColumn(CellUtil.cloneFamily((Cell)value), CellUtil.cloneQualifier((Cell)value), this.tx.getWritePointer(), CellUtil.cloneValue((Cell)value));
                    this.addToChangeSet(txPut.getRow(), CellUtil.cloneFamily((Cell)value), CellUtil.cloneQualifier((Cell)value));
                }
            }
        }
        for (Map.Entry entry : put.getAttributesMap().entrySet()) {
            txPut.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        txPut.setDurability(put.getDurability());
        this.addToOperation((OperationWithAttributes)txPut, this.tx);
        return txPut;
    }

    private Delete transactionalizeAction(Delete delete) throws IOException {
        long transactionTimestamp = this.tx.getWritePointer();
        byte[] deleteRow = delete.getRow();
        Delete txDelete = new Delete(deleteRow, transactionTimestamp);
        NavigableMap familyToDelete = delete.getFamilyCellMap();
        if (familyToDelete.isEmpty()) {
            if (this.conflictLevel == TxConstants.ConflictDetection.ROW || this.conflictLevel == TxConstants.ConflictDetection.NONE) {
                for (HColumnDescriptor columnDescriptor : this.hTable.getTableDescriptor().getColumnFamilies()) {
                    this.addToChangeSet(deleteRow, columnDescriptor.getName(), null);
                }
            } else {
                Result result = this.get(new Get(delete.getRow()));
                NavigableMap navigableMap = result.getNoVersionMap();
                for (Map.Entry familyEntry : navigableMap.entrySet()) {
                    NavigableMap familyColumns = result.getFamilyMap((byte[])familyEntry.getKey());
                    for (Map.Entry entry : familyColumns.entrySet()) {
                        txDelete.addColumns((byte[])familyEntry.getKey(), (byte[])entry.getKey(), transactionTimestamp);
                        this.addToChangeSet(deleteRow, (byte[])familyEntry.getKey(), (byte[])entry.getKey());
                    }
                }
            }
        } else {
            for (Map.Entry entry : familyToDelete.entrySet()) {
                byte[] family = (byte[])entry.getKey();
                List entries = (List)entry.getValue();
                boolean isFamilyDelete = false;
                if (entries.size() == 1) {
                    Cell cell = (Cell)entries.get(0);
                    isFamilyDelete = CellUtil.isDeleteFamily((Cell)cell);
                }
                if (isFamilyDelete) {
                    if (this.conflictLevel == TxConstants.ConflictDetection.ROW || this.conflictLevel == TxConstants.ConflictDetection.NONE) {
                        txDelete.addFamily(family);
                        this.addToChangeSet(deleteRow, family, null);
                        continue;
                    }
                    Result result = this.get(new Get(delete.getRow()).addFamily(family));
                    NavigableMap navigableMap = result.getFamilyMap(family);
                    for (Map.Entry column : navigableMap.entrySet()) {
                        txDelete.addColumns(family, (byte[])column.getKey(), transactionTimestamp);
                        this.addToChangeSet(deleteRow, family, (byte[])column.getKey());
                    }
                    continue;
                }
                for (Cell cell : entries) {
                    txDelete.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), transactionTimestamp);
                    this.addToChangeSet(deleteRow, CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell));
                }
            }
        }
        for (Map.Entry entry : delete.getAttributesMap().entrySet()) {
            txDelete.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        txDelete.setDurability(delete.getDurability());
        this.addToOperation((OperationWithAttributes)txDelete, this.tx);
        return txDelete;
    }

    private List<? extends Row> transactionalizeActions(List<? extends Row> actions) throws IOException {
        ArrayList<Object> transactionalizedActions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                transactionalizedActions.add(this.transactionalizeAction((Get)row));
                continue;
            }
            if (row instanceof Put) {
                transactionalizedActions.add(this.transactionalizeAction((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                transactionalizedActions.add(this.transactionalizeAction((Delete)row));
                continue;
            }
            transactionalizedActions.add(row);
        }
        return transactionalizedActions;
    }
}

