/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.wicket.IClusterable;
import org.apache.wicket.request.mapper.parameter.IIndexedParameters;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageParameters
implements IClusterable,
IIndexedParameters,
INamedParameters {
    private static final long serialVersionUID = 1L;
    private List<String> indexedParameters;
    private List<Entry> namedParameters;

    public PageParameters() {
    }

    public PageParameters(PageParameters copy) {
        if (copy != null) {
            if (copy.indexedParameters != null) {
                this.indexedParameters = new ArrayList<String>(copy.indexedParameters);
            }
            if (copy.namedParameters != null) {
                this.namedParameters = new ArrayList<Entry>(copy.namedParameters);
            }
        }
    }

    @Deprecated
    public PageParameters(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    @Deprecated
    public PageParameters(String keyValuePairs, String delimiter) {
        StringList pairs = StringList.tokenize((String)keyValuePairs, (String)delimiter);
        for (String pair : pairs) {
            String value;
            String key;
            int pos = pair.indexOf(61);
            if (pos == 0) {
                throw new IllegalArgumentException("URL parameter is missing the lvalue: " + pair);
            }
            if (pos != -1) {
                key = pair.substring(0, pos).trim();
                value = pair.substring(pos + 1).trim();
                this.add(key, value);
                continue;
            }
            key = pair.trim();
            value = "";
            this.add(key, "");
        }
    }

    public int getIndexedCount() {
        return this.indexedParameters != null ? this.indexedParameters.size() : 0;
    }

    @Override
    public PageParameters set(int index, Object object) {
        if (this.indexedParameters == null) {
            this.indexedParameters = new ArrayList<String>(index);
        }
        for (int i = this.indexedParameters.size(); i <= index; ++i) {
            this.indexedParameters.add(null);
        }
        this.indexedParameters.set(index, object != null ? object.toString() : null);
        return this;
    }

    @Override
    public StringValue get(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            return StringValue.valueOf((String)this.indexedParameters.get(index));
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public PageParameters remove(int index) {
        if (this.indexedParameters != null && index >= 0 && index < this.indexedParameters.size()) {
            this.indexedParameters.remove(index);
        }
        return this;
    }

    @Override
    public Set<String> getNamedKeys() {
        if (this.namedParameters == null || this.namedParameters.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> set = new TreeSet<String>();
        for (Entry entry : this.namedParameters) {
            set.add(entry.key);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public StringValue get(String name) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                return StringValue.valueOf((String)entry.value);
            }
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public List<StringValue> getValues(String name) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            for (Entry entry : this.namedParameters) {
                if (!entry.key.equals(name)) continue;
                result.add(StringValue.valueOf((String)entry.value));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    @Override
    public List<NamedPair> getAllNamed() {
        ArrayList<NamedPair> res = new ArrayList<NamedPair>();
        if (this.namedParameters != null) {
            for (Entry e : this.namedParameters) {
                res.add(new NamedPair(e.key, e.value));
            }
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public int getPosition(String name) {
        int index = -1;
        if (this.namedParameters != null) {
            for (int i = 0; i < this.namedParameters.size(); ++i) {
                Entry entry = this.namedParameters.get(i);
                if (!entry.key.equals(name)) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public PageParameters remove(String name) {
        return this.remove(name, new String[0]);
    }

    @Override
    public PageParameters remove(String name, String ... values) {
        Args.notNull((Object)name, (String)"name");
        if (this.namedParameters != null) {
            Iterator<Entry> i = this.namedParameters.iterator();
            block0: while (i.hasNext()) {
                Entry e = i.next();
                if (!e.key.equals(name)) continue;
                if (values != null && values.length > 0) {
                    for (String value : values) {
                        if (!e.value.equals(value)) continue;
                        i.remove();
                        continue block0;
                    }
                    continue;
                }
                i.remove();
            }
        }
        return this;
    }

    @Override
    public PageParameters add(String name, Object value) {
        this.add(name, value, -1);
        return this;
    }

    @Override
    public PageParameters add(String name, Object value, int index) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)value, (String)"value");
        if (this.namedParameters == null) {
            this.namedParameters = new ArrayList<Entry>(1);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (value instanceof String[]) {
            values.addAll(Arrays.asList((String[])value));
        } else {
            values.add(value.toString());
        }
        for (String val : values) {
            Entry entry = new Entry();
            entry.key = name;
            entry.value = val;
            if (index < 0 || index > this.namedParameters.size()) {
                this.namedParameters.add(entry);
                continue;
            }
            this.namedParameters.add(index, entry);
        }
        return this;
    }

    @Override
    public PageParameters set(String name, Object value, int index) {
        this.remove(name);
        if (value != null) {
            this.add(name, value, index);
        }
        return this;
    }

    @Override
    public PageParameters set(String name, Object value) {
        int position = this.getPosition(name);
        this.set(name, value, position);
        return this;
    }

    @Override
    public PageParameters clearIndexed() {
        this.indexedParameters = null;
        return this;
    }

    @Override
    public PageParameters clearNamed() {
        this.namedParameters = null;
        return this;
    }

    public PageParameters overwriteWith(PageParameters other) {
        if (this != other) {
            this.indexedParameters = other.indexedParameters;
            this.namedParameters = other.namedParameters;
        }
        return this;
    }

    public PageParameters mergeWith(PageParameters other) {
        if (this != other) {
            for (int index = 0; index < other.getIndexedCount(); ++index) {
                this.set(index, (Object)other.get(index));
            }
            for (NamedPair curNamed : other.getAllNamed()) {
                this.set(curNamed.getKey(), (Object)curNamed.getValue());
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexedParameters == null ? 0 : ((Object)this.indexedParameters).hashCode());
        result = 31 * result + (this.namedParameters == null ? 0 : ((Object)this.namedParameters).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageParameters other = (PageParameters)obj;
        if (this.indexedParameters == null ? other.indexedParameters != null : !((Object)this.indexedParameters).equals(other.indexedParameters)) {
            return false;
        }
        return !(this.namedParameters == null ? other.namedParameters != null : !((Object)this.namedParameters).equals(other.namedParameters));
    }

    public static boolean equals(PageParameters p1, PageParameters p2) {
        if (Objects.equal((Object)p1, (Object)p2)) {
            return true;
        }
        if (p1 == null && p2.getIndexedCount() == 0 && p2.getNamedKeys().isEmpty()) {
            return true;
        }
        return p2 == null && p1.getIndexedCount() == 0 && p1.getNamedKeys().isEmpty();
    }

    public boolean isEmpty() {
        return this.getIndexedCount() == 0 && this.getNamedKeys().isEmpty();
    }

    public String toString() {
        int i;
        StringBuilder str = new StringBuilder();
        if (this.indexedParameters != null) {
            for (i = 0; i < this.indexedParameters.size(); ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(i);
                str.append('=');
                str.append('[').append(this.indexedParameters.get(i)).append(']');
            }
        }
        if (str.length() > 0) {
            str.append(", ");
        }
        if (this.namedParameters != null) {
            for (i = 0; i < this.namedParameters.size(); ++i) {
                Entry entry = this.namedParameters.get(i);
                if (i > 0) {
                    str.append(", ");
                }
                str.append(entry.key);
                str.append('=');
                str.append('[').append(entry.value).append(']');
            }
        }
        return str.toString();
    }

    public static class NamedPair {
        private final String key;
        private final String value;

        public NamedPair(String key, String value) {
            this.key = (String)Args.notNull((Object)key, (String)"key");
            this.value = (String)Args.notNull((Object)value, (String)"value");
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class Entry
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private String key;
        private String value;

        private Entry() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

