/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.kerberos;

import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class KrbTicketDecoder {
    private byte[] serviceTicket;
    private Subject subject;

    public KrbTicketDecoder(byte[] serviceTicket, Subject subject) {
        this.serviceTicket = serviceTicket;
        this.subject = subject;
    }

    public SecretKey getSessionKey() throws Exception {
        EncryptionKey encKey = this.parseServiceTicket(this.serviceTicket);
        SecretKeySpec keySpec = new SecretKeySpec(encKey.getBytes(), "DES");
        return keySpec;
    }

    private EncryptionKey parseServiceTicket(byte[] ticket) throws Exception {
        DerInputStream ticketStream = new DerInputStream(ticket);
        DerValue[] values = ticketStream.getSet(ticket.length, true);
        for (int i = 0; i < values.length; ++i) {
            DerValue value = values[i];
            if (!value.isConstructed((byte)14)) continue;
            value.resetTag((byte)49);
            return this.parseApReq(value.toDerInputStream(), value.length());
        }
        throw new Exception("Could not find AP-REQ in service ticket.");
    }

    private EncryptionKey parseApReq(DerInputStream reqStream, int len) throws Exception {
        DerValue ticket = null;
        DerValue[] values = reqStream.getSet(len, true);
        for (int i = 0; i < values.length; ++i) {
            DerValue value = values[i];
            if (!value.isContextSpecific((byte)3)) continue;
            ticket = value.getData().getDerValue();
        }
        if (ticket == null) {
            throw new Exception("No Ticket found in AP-REQ PDU");
        }
        return this.decryptTicket(new Ticket(ticket), this.subject);
    }

    private EncryptionKey decryptTicket(Ticket ticket, Subject svrSub) throws Exception {
        EncryptionKey key = this.getPrivateKey(svrSub, ticket.encPart.getEType());
        byte[] ticketBytes = ticket.encPart.decrypt(key, 2);
        if (ticketBytes.length <= 0) {
            throw new Exception("Key is empty.");
        }
        byte[] temp = ticket.encPart.reset(ticketBytes);
        EncTicketPart encPart = new EncTicketPart(temp);
        return encPart.key;
    }

    private EncryptionKey getPrivateKey(Subject sub, int keyType) throws Exception {
        KerberosKey key = this.getKrbKey(sub, keyType);
        return new EncryptionKey(key.getEncoded(), key.getKeyType(), new Integer(keyType));
    }

    private KerberosKey getKrbKey(Subject sub, int keyType) {
        Set<Object> creds = sub.getPrivateCredentials(Object.class);
        for (Object cred : creds) {
            KerberosKey key;
            if (!(cred instanceof KerberosKey) || (key = (KerberosKey)cred).getKeyType() != keyType) continue;
            return (KerberosKey)cred;
        }
        return null;
    }
}

