/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.ReferenceListProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.saml.SAML2KeyInfo;
import org.apache.ws.security.saml.SAML2Util;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EncryptedKeyProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)EncryptedKeyProcessor.class.getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private byte[] encryptedEphemeralKey;
    private byte[] decryptedBytes = null;
    private String encryptedKeyId = null;
    private X509Certificate cert = null;
    private String encryptedKeyTransportMethod = null;
    private WSDocInfo docInfo = null;

    @Override
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found encrypted key element");
        }
        if (decCrypto == null) {
            throw new WSSecurityException(0, "noDecCryptoFile");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.docInfo = wsDocInfo;
        ArrayList dataRefUris = this.handleEncryptedKey(elem, cb, decCrypto);
        this.encryptedKeyId = elem.getAttributeNS(null, "Id");
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, this.decryptedBytes, this.encryptedEphemeralKey, this.encryptedKeyId, (List)dataRefUris, this.cert);
        result.put(WSSecurityEngineResult.TAG_ENCRYPTED_KEY_TRANSPORT_METHOD, this.encryptedKeyTransportMethod);
        returnResults.add(0, result);
    }

    public ArrayList handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.handleEncryptedKey(xencEncryptedKey, cb, crypto, null);
    }

    public ArrayList handleEncryptedKey(Element xencEncryptedKey, PrivateKey privatekey) throws WSSecurityException {
        return this.handleEncryptedKey(xencEncryptedKey, null, null, privatekey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList handleEncryptedKey(Element xencEncryptedKey, CallbackHandler cb, Crypto crypto, PrivateKey privateKey) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Document doc = xencEncryptedKey.getOwnerDocument();
        Node tmpE = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            this.encryptedKeyTransportMethod = tmpE.getAttribute("Algorithm");
        }
        if (this.encryptedKeyTransportMethod == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        Cipher cipher = WSSecurityUtil.getCipherInstance(this.encryptedKeyTransportMethod);
        Element xencCipherValue = null;
        tmpE = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (tmpE != null) {
            xencCipherValue = (Element)WSSecurityUtil.getDirectChild(tmpE, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        }
        if (xencCipherValue == null) {
            throw new WSSecurityException(3, "noCipher");
        }
        if (privateKey == null) {
            String alias;
            Element keyInfo = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            if (keyInfo != null) {
                Element secRefToken = (Element)WSSecurityUtil.getDirectChild(keyInfo, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                if (secRefToken == null) {
                    throw new WSSecurityException(3, "noSecTokRef");
                }
                SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
                alias = null;
                if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
                    alias = secRef.getX509IssuerSerialAlias(crypto);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("X509IssuerSerial alias: " + alias));
                    }
                } else if (secRef.containsKeyIdentifier()) {
                    Object samlKi;
                    Element token;
                    X509Certificate[] certs = null;
                    if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType())) {
                        token = secRef.getKeyIdentifierTokenElement(doc, this.docInfo, cb);
                        if (crypto == null) {
                            throw new WSSecurityException(0, "noSigCryptoFile");
                        }
                        samlKi = SAMLUtil.getSAMLKeyInfo(token, crypto, cb);
                        certs = ((SAMLKeyInfo)samlKi).getCerts();
                    } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                        token = secRef.getKeyIdentifierTokenElement(doc, this.docInfo, cb);
                        if (crypto == null) {
                            throw new WSSecurityException(0, "noSigCryptoFile");
                        }
                        samlKi = SAML2Util.getSAML2KeyInfo(token, crypto, cb);
                        certs = ((SAML2KeyInfo)samlKi).getCerts();
                    } else {
                        certs = secRef.getKeyIdentifier(crypto);
                    }
                    if (certs == null || certs.length < 1 || certs[0] == null) {
                        throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption (KeyId)"});
                    }
                    alias = crypto.getAliasForX509Cert(certs[0]);
                    this.cert = certs[0];
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cert: " + certs[0]));
                        log.debug((Object)("KeyIdentifier Alias: " + alias));
                    }
                } else {
                    if (!secRef.containsReference()) throw new WSSecurityException(3, "unsupportedKeyId");
                    Element bstElement = secRef.getTokenElement(doc, null, cb);
                    QName el = new QName(bstElement.getNamespaceURI(), bstElement.getLocalName());
                    if (!el.equals(WSSecurityEngine.binaryToken)) throw new WSSecurityException(1, "unsupportedBinaryTokenType", null);
                    X509Security token = new X509Security(bstElement);
                    String value = bstElement.getAttribute("ValueType");
                    if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(value) || token == null) {
                        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{"for decryption (BST)"});
                    }
                    this.cert = token.getX509Certificate(crypto);
                    if (this.cert == null) {
                        throw new WSSecurityException(0, "noCertsFound", new Object[]{"decryption"});
                    }
                    alias = crypto.getAliasForX509Cert(this.cert);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("BST Alias: " + alias));
                    }
                }
            } else {
                if (crypto.getDefaultX509Alias() == null) throw new WSSecurityException(3, "noKeyinfo");
                alias = crypto.getDefaultX509Alias();
            }
            WSPasswordCallback pwCb = new WSPasswordCallback(alias, 1);
            try {
                Callback[] callbacks = new Callback[]{pwCb};
                cb.handle(callbacks);
            }
            catch (IOException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias}, e);
            }
            catch (UnsupportedCallbackException e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias}, e);
            }
            String password = pwCb.getPassword();
            if (password == null) {
                throw new WSSecurityException(0, "noPassword", new Object[]{alias});
            }
            try {
                privateKey = crypto.getPrivateKey(alias, password);
            }
            catch (Exception e) {
                throw new WSSecurityException(6, null, null, e);
            }
        }
        try {
            cipher.init(2, privateKey);
        }
        catch (Exception e1) {
            throw new WSSecurityException(6, null, null, e1);
        }
        try {
            this.encryptedEphemeralKey = EncryptedKeyProcessor.getDecodedBase64EncodedData(xencCipherValue);
            this.decryptedBytes = cipher.doFinal(this.encryptedEphemeralKey);
        }
        catch (IllegalStateException e2) {
            throw new WSSecurityException(6, null, null, e2);
        }
        catch (Exception e2) {
            this.decryptedBytes = EncryptedKeyProcessor.getRandomKey(this.getDataRefURIs(xencCipherValue), xencEncryptedKey.getOwnerDocument(), this.docInfo);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Element refList = (Element)WSSecurityUtil.getDirectChild(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        ArrayList<WSDataRef> dataRefs = new ArrayList<WSDataRef>();
        if (refList != null) {
            for (tmpE = refList.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
                if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
                String dataRefURI = ((Element)tmpE).getAttribute("URI");
                if (dataRefURI.charAt(0) == '#') {
                    dataRefURI = dataRefURI.substring(1);
                }
                WSDataRef dataRef = this.decryptDataRef(doc, dataRefURI, this.decryptedBytes);
                dataRefs.add(dataRef);
            }
            return dataRefs;
        }
        if (!tlog.isDebugEnabled()) return null;
        t2 = System.currentTimeMillis();
        tlog.debug((Object)("XMLDecrypt: total= " + (t2 - t0) + ", get-sym-key= " + (t1 - t0) + ", decrypt= " + (t2 - t1)));
        return null;
    }

    public static byte[] getDecodedBase64EncodedData(Element element) throws WSSecurityException {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        String encodedData = sb.toString();
        return Base64.decode(encodedData);
    }

    private WSDataRef decryptDataRef(Document doc, String dataRefURI, byte[] decryptedData) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("found data reference: " + dataRefURI));
        }
        Element encryptedDataElement = ReferenceListProcessor.findEncryptedDataElement(doc, dataRefURI);
        String symEncAlgo = X509Util.getEncAlgo(encryptedDataElement);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedData);
        return ReferenceListProcessor.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo);
    }

    @Override
    public String getId() {
        return this.encryptedKeyId;
    }

    public byte[] getDecryptedBytes() {
        return this.decryptedBytes;
    }

    public byte[] getEncryptedEphemeralKey() {
        return this.encryptedEphemeralKey;
    }

    private List<String> getDataRefURIs(Element xencEncryptedKey) {
        Element refList = WSSecurityUtil.getDirectChildElement(xencEncryptedKey, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        LinkedList<String> dataRefURIs = new LinkedList<String>();
        if (refList != null) {
            for (Node node = refList.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType() || !"http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || !"DataReference".equals(node.getLocalName())) continue;
                String dataRefURI = ((Element)node).getAttributeNS(null, "URI");
                if (dataRefURI.charAt(0) == '#') {
                    dataRefURI = dataRefURI.substring(1);
                }
                dataRefURIs.add(dataRefURI);
            }
        }
        return dataRefURIs;
    }

    private static byte[] getRandomKey(List<String> dataRefURIs, Document doc, WSDocInfo wsDocInfo) throws WSSecurityException {
        try {
            String alg = "AES";
            int size = 16;
            if (!dataRefURIs.isEmpty()) {
                String uri = dataRefURIs.iterator().next();
                Element ee = ReferenceListProcessor.findEncryptedDataElement(doc, uri);
                String algorithmURI = X509Util.getEncAlgo(ee);
                alg = JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI);
                size = WSSecurityUtil.getKeyLength(algorithmURI);
            }
            KeyGenerator kgen = KeyGenerator.getInstance(alg);
            kgen.init(size * 8);
            SecretKey k = kgen.generateKey();
            return k.getEncoded();
        }
        catch (Throwable ex) {
            try {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey k = kgen.generateKey();
                return k.getEncoded();
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(6, null, null, e);
            }
        }
    }
}

