/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.saml.SAML2KeyInfo;
import org.apache.ws.security.util.Base64;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialContextSet;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SAML2Util {
    public static boolean bootstrapped = false;

    public static void doBootstrap() throws WSSecurityException {
        if (!bootstrapped) {
            try {
                DefaultBootstrap.bootstrap();
            }
            catch (ConfigurationException e) {
                throw new WSSecurityException("errorBootstrapping", e);
            }
            bootstrapped = true;
        }
    }

    public static SAML2KeyInfo getSAML2KeyInfo(Element elem, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        Assertion assertion;
        try {
            SAML2Util.doBootstrap();
            String keyInfoElementString = elem.toString();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(keyInfoElementString.trim().getBytes()));
            Element element = document.getDocumentElement();
            NodeList list = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            if (list != null && list.getLength() > 0) {
                throw new WSSecurityException("invalidSAMLSecurity");
            }
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            assertion = (Assertion)unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (SAXException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        return SAML2Util.getSAML2KeyInfo(assertion, crypto, cb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SAML2KeyInfo getSAML2KeyInfo(Assertion assertion, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        byte[] key;
        WSPasswordCallback pwcb = new WSPasswordCallback(assertion.getID(), 7);
        if (cb != null) {
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(0, "noKey", new Object[]{assertion.getID()}, e1);
            }
        }
        if ((key = pwcb.getKey()) != null) {
            return new SAML2KeyInfo(assertion, key);
        }
        try {
            XMLObject KIElem;
            Subject samlSubject = assertion.getSubject();
            if (samlSubject == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject)"});
            }
            SubjectConfirmation subjectConf = (SubjectConfirmation)samlSubject.getSubjectConfirmations().get(0);
            if (subjectConf == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation)"});
            }
            KeyInfoConfirmationDataType scData = (KeyInfoConfirmationDataType)subjectConf.getSubjectConfirmationData();
            if (scData == null) {
                throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation Data)"});
            }
            XMLObject xMLObject = KIElem = scData.getKeyInfos() != null ? (XMLObject)scData.getKeyInfos().get(0) : null;
            if (KIElem == null) throw new WSSecurityException(0, "invalidSAML2Token", new Object[]{"for Signature (no key info element)"});
            String jaxpProperty = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(KIElem);
            Element keyInfoElement = marshaller.marshall(KIElem);
            if (jaxpProperty == null) {
                System.getProperties().remove("javax.xml.parsers.DocumentBuilderFactory");
            } else {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", jaxpProperty);
            }
            AttributeStatement attrStmt = assertion.getAttributeStatements().size() != 0 ? (AttributeStatement)assertion.getAttributeStatements().get(0) : null;
            AuthnStatement authnStmt = assertion.getAuthnStatements().size() != 0 ? (AuthnStatement)assertion.getAuthnStatements().get(0) : null;
            boolean usePublicKey = false;
            if (attrStmt != null) {
                NodeList children = keyInfoElement.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    QName el = new QName(child.getNamespaceURI(), child.getLocalName());
                    if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                        EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
                        proc.handleEncryptedKey((Element)child, cb, crypto, null);
                        return new SAML2KeyInfo(assertion, proc.getDecryptedBytes());
                    }
                    if (el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) {
                        Text txt = (Text)child.getFirstChild();
                        return new SAML2KeyInfo(assertion, Base64.decode(txt.getData()));
                    }
                    if (!el.equals(new QName("http://www.w3.org/2000/09/xmldsig#", "X509Data"))) continue;
                    java.security.cert.X509Certificate[] certs = null;
                    try {
                        KeyInfo ki = new KeyInfo(keyInfoElement, null);
                        if (!ki.containsX509Data()) continue;
                        X509Data data = ki.itemX509Data(0);
                        XMLX509Certificate certElem = null;
                        if (data != null && data.containsCertificate()) {
                            certElem = data.itemCertificate(0);
                        }
                        if (certElem == null) continue;
                        java.security.cert.X509Certificate cert = certElem.getX509Certificate();
                        certs = new java.security.cert.X509Certificate[]{cert};
                        return new SAML2KeyInfo(assertion, certs);
                    }
                    catch (XMLSecurityException e3) {
                        throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
                    }
                }
            }
            if (authnStmt == null && !usePublicKey) throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate or key "});
            java.security.cert.X509Certificate[] certs = null;
            try {
                KeyInfo ki = new KeyInfo(keyInfoElement, null);
                if (!ki.containsX509Data()) throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate or key "});
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem == null) throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate or key "});
                java.security.cert.X509Certificate cert = certElem.getX509Certificate();
                certs = new java.security.cert.X509Certificate[]{cert};
                return new SAML2KeyInfo(assertion, certs);
            }
            catch (XMLSecurityException e3) {
                throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
            }
        }
        catch (MarshallingException e) {
            throw new WSSecurityException(0, "Failed marshalling the SAML Assertion", null, e);
        }
    }

    public static Timestamp getTimestampForSAMLAssertion(Assertion assertion) throws WSSecurityException {
        Subject subject = assertion.getSubject();
        SubjectConfirmationData scData = ((SubjectConfirmation)subject.getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        String notBefore = null;
        String notOnOrAfter = null;
        if (assertion.getConditions() != null) {
            Conditions conditions = assertion.getConditions();
            if (conditions.getNotBefore() != null) {
                notBefore = conditions.getNotBefore().toString();
            }
            if (conditions.getNotOnOrAfter() != null) {
                notOnOrAfter = conditions.getNotOnOrAfter().toString();
            }
        } else if (scData != null) {
            if (scData.getNotBefore() != null) {
                notBefore = scData.getNotBefore().toString();
            }
            if (scData.getNotOnOrAfter() != null) {
                notOnOrAfter = scData.getNotOnOrAfter().toString();
            }
        }
        if (notBefore == null || notOnOrAfter == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            Document document = dbFactory.newDocumentBuilder().newDocument();
            Element element = document.createElement("SAMLTimestamp");
            Element createdElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            createdElement.setTextContent(notBefore);
            element.appendChild(createdElement);
            Element expiresElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            expiresElement.setTextContent(notOnOrAfter);
            element.appendChild(expiresElement);
            return new Timestamp(element);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "SAMLTimeStampBuildError", null, e);
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(0, "SAMLTimeStampBuildError", null, e);
        }
    }

    public static Set getClaims(Assertion assertion) {
        TreeSet<String> claimSet = new TreeSet<String>();
        List attributeStatements = assertion.getAttributeStatements();
        for (int attrStmtIndex = 0; attrStmtIndex < attributeStatements.size(); ++attrStmtIndex) {
            AttributeStatement attributeStatement = (AttributeStatement)attributeStatements.get(attrStmtIndex);
            List attributes = attributeStatement.getAttributes();
            for (int attrIndex = 0; attrIndex < attributes.size(); ++attrIndex) {
                claimSet.add(((Attribute)attributes.get(attrIndex)).getName());
            }
        }
        return claimSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateSignature(Assertion assertion, Crypto crypto) throws WSSecurityException {
        List x509Data = assertion.getSignature().getKeyInfo().getX509Datas();
        if (x509Data == null || x509Data.size() <= 0) throw new WSSecurityException(0, "SAMLTokenInvalidX509Data");
        org.opensaml.xml.signature.X509Data x509Cred = (org.opensaml.xml.signature.X509Data)x509Data.get(0);
        List x509Certs = x509Cred.getX509Certificates();
        if (x509Certs == null || x509Certs.size() <= 0) throw new WSSecurityException(0, "SAMLTokenInvalidX509Data");
        X509Certificate cert = (X509Certificate)x509Certs.get(0);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(org.opensaml.xml.util.Base64.decode((String)cert.getValue())));
            if (crypto.getAliasForX509CertThumb(SAML2Util.calculateThumbPrint(x509Certificate)) == null) {
                throw new WSSecurityException(0, "SAMLTokenUntrustedSignatureKey");
            }
            class X509CredentialImpl
            implements X509Credential {
                private PublicKey publicKey = null;

                public X509CredentialImpl(java.security.cert.X509Certificate cert) {
                    this.publicKey = cert.getPublicKey();
                }

                public java.security.cert.X509Certificate getEntityCertificate() {
                    return null;
                }

                public Collection<java.security.cert.X509Certificate> getEntityCertificateChain() {
                    return null;
                }

                public Collection<X509CRL> getCRLs() {
                    return null;
                }

                public String getEntityId() {
                    return null;
                }

                public UsageType getUsageType() {
                    return null;
                }

                public Collection<String> getKeyNames() {
                    return null;
                }

                public PublicKey getPublicKey() {
                    return this.publicKey;
                }

                public PrivateKey getPrivateKey() {
                    return null;
                }

                public SecretKey getSecretKey() {
                    return null;
                }

                public CredentialContextSet getCredentalContextSet() {
                    return null;
                }

                public Class<? extends Credential> getCredentialType() {
                    return null;
                }
            }
            SignatureValidator signatureValidator = new SignatureValidator((Credential)new X509CredentialImpl(x509Certificate));
            signatureValidator.validate(assertion.getSignature());
            return;
        }
        catch (CertificateException e) {
            throw new WSSecurityException("SAMLTokenErrorGeneratingX509CertInstance", e);
        }
        catch (ValidationException e) {
            throw new WSSecurityException(10, "SAMLTokenInvalidSignature");
        }
    }

    private static byte[] calculateThumbPrint(java.security.cert.X509Certificate x509Certificate) {
        byte[] thumbPrintValue = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(x509Certificate.getEncoded());
            thumbPrintValue = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return thumbPrintValue;
    }
}

