/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectStatement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SAMLUtil {
    private static Log log = LogFactory.getLog((String)SAMLUtil.class.getName());

    public static SAMLKeyInfo getSAMLKeyInfo(Element elem, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        try {
            NodeList list = elem.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
            if (list != null && list.getLength() > 0) {
                throw new WSSecurityException("invalidSAMLSecurity");
            }
            SAMLAssertion assertion = new SAMLAssertion(elem);
            return SAMLUtil.getSAMLKeyInfo(assertion, crypto, cb);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"}, e);
        }
    }

    public static SAMLKeyInfo getSAMLKeyInfo(SAMLAssertion assertion, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        byte[] key;
        WSPasswordCallback pwcb = new WSPasswordCallback(assertion.getId(), 7);
        if (cb != null) {
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(0, "noKey", new Object[]{assertion.getId()}, e1);
            }
        }
        if ((key = pwcb.getKey()) != null) {
            return new SAMLKeyInfo(assertion, key);
        }
        Iterator statements = assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement stmt = (SAMLStatement)statements.next();
            if (stmt instanceof SAMLAttributeStatement) {
                SAMLAttributeStatement attrStmt = (SAMLAttributeStatement)stmt;
                SAMLSubject samlSubject = attrStmt.getSubject();
                Element kiElem = samlSubject.getKeyInfo();
                NodeList children = kiElem.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    QName el = new QName(child.getNamespaceURI(), child.getLocalName());
                    if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
                        EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
                        proc.handleEncryptedKey((Element)child, cb, crypto, null);
                        return new SAMLKeyInfo(assertion, proc.getDecryptedBytes());
                    }
                    if (!el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) continue;
                    Text txt = (Text)child.getFirstChild();
                    return new SAMLKeyInfo(assertion, Base64.decode(txt.getData()));
                }
                continue;
            }
            if (stmt instanceof SAMLAuthenticationStatement) {
                SAMLAuthenticationStatement authStmt = (SAMLAuthenticationStatement)stmt;
                SAMLSubject samlSubj = authStmt.getSubject();
                if (samlSubj == null) {
                    throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
                }
                Element e = samlSubj.getKeyInfo();
                X509Certificate[] certs = null;
                try {
                    KeyInfo ki = new KeyInfo(e, null);
                    if (!ki.containsX509Data()) continue;
                    X509Data data = ki.itemX509Data(0);
                    XMLX509Certificate certElem = null;
                    if (data != null && data.containsCertificate()) {
                        certElem = data.itemCertificate(0);
                    }
                    if (certElem == null) continue;
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                    return new SAMLKeyInfo(assertion, certs);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
                }
            }
            throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate or key "});
        }
        throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate or key "});
    }

    public static X509Certificate[] getCertificatesFromSAML(Element elem) throws WSSecurityException {
        SAMLAssertion assertion;
        try {
            assertion = new SAMLAssertion(elem);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (cannot parse)"}, e);
        }
        SAMLSubjectStatement samlSubjS = null;
        Iterator it = assertion.getStatements();
        while (it.hasNext()) {
            SAMLObject so = (SAMLObject)it.next();
            if (!(so instanceof SAMLSubjectStatement)) continue;
            samlSubjS = (SAMLSubjectStatement)so;
            break;
        }
        SAMLSubject samlSubj = null;
        if (samlSubjS != null) {
            samlSubj = samlSubjS.getSubject();
        }
        if (samlSubj == null) {
            throw new WSSecurityException(0, "invalidSAMLToken", new Object[]{"for Signature (no Subject)"});
        }
        Element e = samlSubj.getKeyInfo();
        X509Certificate[] certs = null;
        try {
            KeyInfo ki = new KeyInfo(e, null);
            if (ki.containsX509Data()) {
                X509Data data = ki.itemX509Data(0);
                XMLX509Certificate certElem = null;
                if (data != null && data.containsCertificate()) {
                    certElem = data.itemCertificate(0);
                }
                if (certElem != null) {
                    X509Certificate cert = certElem.getX509Certificate();
                    certs = new X509Certificate[]{cert};
                }
            }
        }
        catch (XMLSecurityException e3) {
            throw new WSSecurityException(0, "invalidSAMLSecurity", new Object[]{"cannot get certificate (key holder)"}, e3);
        }
        return certs;
    }

    public static String getAssertionId(Element envelope, String elemName, String nmSpace) throws WSSecurityException {
        String id;
        Element assertionElement = (Element)WSSecurityUtil.findElement(envelope, elemName, nmSpace);
        try {
            SAMLAssertion assertion = new SAMLAssertion(assertionElement);
            id = assertion.getId();
        }
        catch (Exception e1) {
            log.error((Object)e1);
            throw new WSSecurityException(10, "noXMLSig", null, e1);
        }
        return id;
    }

    public static Timestamp getTimestampForSAMLAssertion(Element assertion) throws WSSecurityException {
        String[] validityPeriod = SAMLUtil.getValidityPeriod(assertion);
        if (validityPeriod[0] == null || validityPeriod[1] == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            Document document = dbFactory.newDocumentBuilder().newDocument();
            Element element = document.createElement("SAMLTimestamp");
            Element createdElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
            createdElement.setTextContent(validityPeriod[0]);
            element.appendChild(createdElement);
            Element expiresElement = document.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
            expiresElement.setTextContent(validityPeriod[1]);
            element.appendChild(expiresElement);
            return new Timestamp(element);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "SAMLTimeStampBuildError", null, e);
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(0, "SAMLTimeStampBuildError", null, e);
        }
    }

    public static Set getClaims(SAMLAssertion assertion) {
        TreeSet<String> claims = new TreeSet<String>();
        Iterator statements = assertion.getStatements();
        while (statements.hasNext()) {
            SAMLStatement statement = (SAMLStatement)statements.next();
            if (!(statement instanceof SAMLAttributeStatement)) continue;
            Iterator attributes = ((SAMLAttributeStatement)statement).getAttributes();
            while (attributes.hasNext()) {
                SAMLAttribute attribute = (SAMLAttribute)attributes.next();
                claims.add(attribute.getName());
            }
        }
        return claims;
    }

    public static void validateSignature(SAMLAssertion assertion, Crypto sigCrypto) throws WSSecurityException {
        Iterator x509Certificates = null;
        try {
            x509Certificates = assertion.getX509Certificates();
        }
        catch (SAMLException e) {
            throw new WSSecurityException(0, "SAMLTokenInvalidX509Data");
        }
        try {
            X509Certificate x509Certificate;
            if (x509Certificates.hasNext()) {
                x509Certificate = (X509Certificate)x509Certificates.next();
                if (sigCrypto.getAliasForX509Cert(x509Certificate) == null) {
                    throw new WSSecurityException(0, "SAMLTokenUntrustedSignatureKey");
                }
            } else {
                throw new WSSecurityException(0, "SAMLTokenInvalidX509Data");
            }
            assertion.verify((Certificate)x509Certificate);
        }
        catch (SAMLException e) {
            throw new WSSecurityException(10, "SAMLTokenInvalidSignature");
        }
    }

    private static String[] getValidityPeriod(Element assertion) {
        String[] validityPeriod = new String[2];
        for (Node currentChild = assertion.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!"Conditions".equals(currentChild.getLocalName()) || !"urn:oasis:names:tc:SAML:1.0:assertion".equals(currentChild.getNamespaceURI())) continue;
            NamedNodeMap attributes = currentChild.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if ("NotBefore".equals(attr.getLocalName())) {
                    validityPeriod[0] = attr.getNodeValue();
                    continue;
                }
                if (!"NotOnOrAfter".equals(attr.getLocalName())) continue;
                validityPeriod[1] = attr.getNodeValue();
            }
            break;
        }
        return validityPeriod;
    }
}

