/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.index.IndexLocation;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.processing.IJob;
import org.aspectj.org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        Index[] indexes = this.getIndexes(progressMonitor);
        try {
            int max = indexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.search(indexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            if (JobManager.VERBOSE) {
                Util.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        int length;
        IndexLocation[] indexLocations;
        if (this.participant instanceof JavaSearchParticipant) {
            indexLocations = ((JavaSearchParticipant)this.participant).selectIndexURLs(this.pattern, this.scope);
            length = indexLocations.length;
        } else {
            IPath[] paths = this.participant.selectIndexes(this.pattern, this.scope);
            length = paths.length;
            indexLocations = new IndexLocation[paths.length];
            int i = 0;
            int len = paths.length;
            while (i < len) {
                indexLocations[i] = new FileIndexLocation(paths[i].toFile(), true);
                ++i;
            }
        }
        Index[] indexes = JavaModelManager.getIndexManager().getIndexes(indexLocations, progressMonitor);
        this.areIndexesReady = indexes.length == length;
        return indexes;
    }

    @Override
    public String getJobFamily() {
        return "";
    }

    public boolean search(Index index, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            long start = System.currentTimeMillis();
            MatchLocator.findIndexMatches(this.pattern, index, this.requestor, this.participant, this.scope, progressMonitor);
            this.executionTime += System.currentTimeMillis() - start;
            return true;
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
            }
            return false;
        }
        finally {
            monitor.exitRead();
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

