/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public class ModuleBinding
extends Binding
implements IUpdatableModule {
    public static final char[] UNNAMED = "".toCharArray();
    public static final char[] ALL_UNNAMED = "ALL-UNNAMED".toCharArray();
    public static final char[] ANY = "".toCharArray();
    public static final char[] ANY_NAMED = "".toCharArray();
    public char[] moduleName;
    protected ModuleBinding[] requires;
    protected ModuleBinding[] requiresTransitive;
    protected PackageBinding[] exportedPackages;
    private Map<PackageBinding, SimpleSetOfCharArray> exportRestrictions;
    protected PackageBinding[] openedPackages;
    private Map<PackageBinding, SimpleSetOfCharArray> openRestrictions;
    protected TypeBinding[] uses;
    protected TypeBinding[] services;
    public Map<TypeBinding, TypeBinding[]> implementations;
    public char[] mainClassName;
    private SimpleSetOfCharArray packageNames;
    public int modifiers;
    public LookupEnvironment environment;
    public int tagBits;
    public int defaultNullness = 0;
    ModuleBinding[] requiredModules = null;
    boolean isAuto = false;
    private boolean[] isComplete = new boolean[IUpdatableModule.UpdateKind.values().length];
    private Set<ModuleBinding> transitiveRequires;
    boolean isPackageLookupActive = false;
    public HashtableOfPackage declaredPackages;

    private ModuleBinding(LookupEnvironment env) {
        this.moduleName = UNNAMED;
        this.environment = env;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PACKAGES;
        this.openedPackages = Binding.NO_PACKAGES;
        this.declaredPackages = new HashtableOfPackage(0);
        Arrays.fill(this.isComplete, true);
    }

    ModuleBinding(char[] moduleName) {
        this.moduleName = moduleName;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.exportedPackages = Binding.NO_PACKAGES;
        this.openedPackages = Binding.NO_PACKAGES;
        this.uses = Binding.NO_TYPES;
        this.services = Binding.NO_TYPES;
        this.declaredPackages = new HashtableOfPackage(5);
    }

    protected ModuleBinding(char[] moduleName, LookupEnvironment existingEnvironment) {
        this.moduleName = moduleName;
        this.requires = Binding.NO_MODULES;
        this.requiresTransitive = Binding.NO_MODULES;
        this.environment = new LookupEnvironment(existingEnvironment.root, this);
        this.declaredPackages = new HashtableOfPackage(5);
    }

    public PackageBinding[] getExports() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.exportedPackages;
    }

    public String[] getExportRestrictions(PackageBinding pack) {
        SimpleSetOfCharArray set;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.exportRestrictions != null && (set = this.exportRestrictions.get(pack)) != null) {
            char[][] names = new char[set.elementSize][];
            set.asArray((Object[])names);
            return CharOperation.charArrayToStringArray(names);
        }
        return CharOperation.NO_STRINGS;
    }

    public PackageBinding[] getOpens() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        return this.openedPackages;
    }

    public String[] getOpenRestrictions(PackageBinding pack) {
        SimpleSetOfCharArray set;
        this.completeIfNeeded(IUpdatableModule.UpdateKind.PACKAGE);
        if (this.openRestrictions != null && (set = this.openRestrictions.get(pack)) != null) {
            char[][] names = new char[set.elementSize][];
            set.asArray((Object[])names);
            return CharOperation.charArrayToStringArray(names);
        }
        return CharOperation.NO_STRINGS;
    }

    public TypeBinding[] getImplementations(TypeBinding binding) {
        if (this.implementations != null) {
            return this.implementations.get(binding);
        }
        return null;
    }

    public ModuleBinding[] getRequires() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requires;
    }

    public ModuleBinding[] getRequiresTransitive() {
        this.completeIfNeeded(IUpdatableModule.UpdateKind.MODULE);
        return this.requiresTransitive;
    }

    public TypeBinding[] getUses() {
        return this.uses;
    }

    public TypeBinding[] getServices() {
        return this.services;
    }

    private void completeIfNeeded(IUpdatableModule.UpdateKind kind) {
        if (!this.isComplete[kind.ordinal()]) {
            this.isComplete[kind.ordinal()] = true;
            if (this.environment.nameEnvironment instanceof IModuleAwareNameEnvironment) {
                ((IModuleAwareNameEnvironment)this.environment.nameEnvironment).applyModuleUpdates(this, kind);
            }
        }
    }

    @Override
    public void addReads(char[] requiredModuleName) {
        ModuleBinding requiredModule = this.environment.getModule(requiredModuleName);
        if (requiredModule != null) {
            int len = this.requires.length;
            if (len == 0) {
                this.requires = new ModuleBinding[]{requiredModule};
            } else {
                this.requires = new ModuleBinding[len + 1];
                System.arraycopy(this.requires, 0, this.requires, 0, len);
                this.requires[len] = requiredModule;
            }
        }
        HashtableOfPackage knownPackages = this.environment.knownPackages;
        int i = 0;
        while (i < knownPackages.valueTable.length) {
            PackageBinding packageBinding = knownPackages.valueTable[i];
            if (packageBinding != null) {
                PackageBinding newBinding = requiredModule.getVisiblePackage(packageBinding.compoundName);
                if (packageBinding != (newBinding = SplitPackageBinding.combine(newBinding, packageBinding, this))) {
                    knownPackages.valueTable[i] = newBinding;
                    if (this.declaredPackages.containsKey(newBinding.readableName())) {
                        this.declaredPackages.put(newBinding.readableName(), newBinding);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void addExports(char[] packageName, char[][] targetModules) {
        PackageBinding declaredPackage = this.getVisiblePackage(CharOperation.splitOn('.', packageName));
        if (declaredPackage != null && declaredPackage.isValidBinding()) {
            this.addResolvedExport(declaredPackage, targetModules);
        }
    }

    @Override
    public void setMainClassName(char[] mainClassName) {
        this.mainClassName = mainClassName;
    }

    @Override
    public void setPackageNames(SimpleSetOfCharArray packageNames) {
        this.packageNames = packageNames;
    }

    public char[][] getPackageNamesForClassFile() {
        PackageBinding packageBinding;
        if (this.packageNames == null) {
            return null;
        }
        PackageBinding[] packageBindingArray = this.exportedPackages;
        int n = this.exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            packageBinding = packageBindingArray[n2];
            this.packageNames.add(packageBinding.readableName());
            ++n2;
        }
        packageBindingArray = this.openedPackages;
        n = this.openedPackages.length;
        n2 = 0;
        while (n2 < n) {
            packageBinding = packageBindingArray[n2];
            this.packageNames.add(packageBinding.readableName());
            ++n2;
        }
        if (this.implementations != null) {
            Iterator<TypeBinding[]> iterator = this.implementations.values().iterator();
            while (iterator.hasNext()) {
                TypeBinding[] types;
                TypeBinding[] typeBindingArray = types = iterator.next();
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    TypeBinding typeBinding = typeBindingArray[n4];
                    this.packageNames.add(((ReferenceBinding)typeBinding).fPackage.readableName());
                    ++n4;
                }
            }
        }
        return this.packageNames.values;
    }

    public void addResolvedExport(PackageBinding declaredPackage, char[][] targetModules) {
        int len = this.exportedPackages.length;
        if (declaredPackage == null || !declaredPackage.isValidBinding()) {
            return;
        }
        if (len == 0) {
            this.exportedPackages = new PackageBinding[]{declaredPackage};
        } else {
            this.exportedPackages = new PackageBinding[len + 1];
            System.arraycopy(this.exportedPackages, 0, this.exportedPackages, 0, len);
            this.exportedPackages[len] = declaredPackage;
        }
        declaredPackage.isExported = Boolean.TRUE;
        this.recordExportRestrictions(declaredPackage, targetModules);
    }

    public void addResolvedOpens(PackageBinding declaredPackage, char[][] targetModules) {
        int len = this.openedPackages.length;
        if (declaredPackage == null || !declaredPackage.isValidBinding()) {
            return;
        }
        if (len == 0) {
            this.openedPackages = new PackageBinding[]{declaredPackage};
        } else {
            this.openedPackages = new PackageBinding[len + 1];
            System.arraycopy(this.openedPackages, 0, this.openedPackages, 0, len);
            this.openedPackages[len] = declaredPackage;
        }
        this.recordOpensRestrictions(declaredPackage, targetModules);
    }

    protected void recordExportRestrictions(PackageBinding exportedPackage, char[][] targetModules) {
        if (targetModules != null && targetModules.length > 0) {
            SimpleSetOfCharArray targetModuleSet = new SimpleSetOfCharArray(targetModules.length);
            int i = 0;
            while (i < targetModules.length) {
                targetModuleSet.add(targetModules[i]);
                ++i;
            }
            if (this.exportRestrictions == null) {
                this.exportRestrictions = new HashMap<PackageBinding, SimpleSetOfCharArray>();
            }
            this.exportRestrictions.put(exportedPackage, targetModuleSet);
        }
    }

    protected void recordOpensRestrictions(PackageBinding openedPackage, char[][] targetModules) {
        if (targetModules != null && targetModules.length > 0) {
            SimpleSetOfCharArray targetModuleSet = new SimpleSetOfCharArray(targetModules.length);
            int i = 0;
            while (i < targetModules.length) {
                targetModuleSet.add(targetModules[i]);
                ++i;
            }
            if (this.openRestrictions == null) {
                this.openRestrictions = new HashMap<PackageBinding, SimpleSetOfCharArray>();
            }
            this.openRestrictions.put(openedPackage, targetModuleSet);
        }
    }

    Stream<ModuleBinding> getRequiredModules(boolean transitiveOnly) {
        return Stream.of(transitiveOnly ? this.getRequiresTransitive() : this.getRequires());
    }

    private void collectAllDependencies(Set<ModuleBinding> deps) {
        this.getRequiredModules(false).forEach(m -> {
            if (deps.add((ModuleBinding)m)) {
                m.collectAllDependencies(deps);
            }
        });
    }

    private void collectTransitiveDependencies(Set<ModuleBinding> deps) {
        this.getRequiredModules(true).forEach(m -> {
            if (deps.add((ModuleBinding)m)) {
                m.collectTransitiveDependencies(deps);
            }
        });
    }

    public Supplier<Collection<ModuleBinding>> dependencyGraphCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (set, mod) -> {
            set.add(mod);
            mod.collectAllDependencies((Set<ModuleBinding>)set);
        }, AbstractCollection::addAll);
    }

    public Supplier<Collection<ModuleBinding>> dependencyCollector() {
        return () -> this.getRequiredModules(false).collect(HashSet::new, (set, mod) -> {
            set.add(mod);
            mod.collectTransitiveDependencies((Set<ModuleBinding>)set);
        }, AbstractCollection::addAll);
    }

    public ModuleBinding[] getAllRequiredModules() {
        if (this.requiredModules != null) {
            return this.requiredModules;
        }
        Collection<ModuleBinding> allRequires = this.dependencyCollector().get();
        if (allRequires.contains(this)) {
            return Binding.NO_MODULES;
        }
        ModuleBinding javaBase = this.environment.javaBaseModule();
        if (!CharOperation.equals(this.moduleName, TypeConstants.JAVA_BASE) && javaBase != null && javaBase != this.environment.UnNamedModule) {
            allRequires.add(javaBase);
        }
        this.requiredModules = allRequires.size() > 0 ? allRequires.toArray(new ModuleBinding[allRequires.size()]) : Binding.NO_MODULES;
        return this.requiredModules;
    }

    @Override
    public char[] name() {
        return this.moduleName;
    }

    public char[] nameForLookup() {
        return this.moduleName;
    }

    public boolean isPackageExportedTo(PackageBinding pkg, ModuleBinding client) {
        PackageBinding resolved = null;
        if (pkg instanceof SplitPackageBinding) {
            resolved = ((SplitPackageBinding)pkg).getIncarnation(this);
        } else if (pkg.enclosingModule == this) {
            resolved = pkg;
        }
        if (resolved != null) {
            if (this.isAuto) {
                return pkg.enclosingModule == this;
            }
            PackageBinding[] initializedExports = this.getExports();
            int i = 0;
            while (i < initializedExports.length) {
                PackageBinding export = initializedExports[i];
                if (export.subsumes(resolved)) {
                    SimpleSetOfCharArray restrictions;
                    if (this.exportRestrictions != null && (restrictions = this.exportRestrictions.get(export)) != null) {
                        if (client.isUnnamed()) {
                            return restrictions.includes(ALL_UNNAMED);
                        }
                        return restrictions.includes(client.name());
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public PackageBinding getTopLevelPackage(char[] name) {
        PackageBinding binding = this.declaredPackages.get(name);
        if (binding != null) {
            return binding;
        }
        binding = this.environment.getPackage0(name);
        if (binding != null) {
            return binding;
        }
        binding = this.getVisiblePackage(null, name);
        if (binding != null) {
            this.environment.knownPackages.put(name, binding);
            binding = this.addPackage(binding, false);
        } else {
            this.environment.knownPackages.put(name, LookupEnvironment.TheNotFoundPackage);
        }
        return binding;
    }

    PackageBinding getDeclaredPackage(char[][] parentName, char[] name) {
        char[][] subPkgCompoundName = CharOperation.arrayConcat(parentName, name);
        char[] fullFlatName = CharOperation.concatWith(subPkgCompoundName, '.');
        PackageBinding pkg = this.declaredPackages.get(fullFlatName);
        if (pkg != null) {
            return pkg;
        }
        PackageBinding parent = parentName.length == 0 ? null : this.getVisiblePackage(parentName);
        PackageBinding binding = new PackageBinding(subPkgCompoundName, parent, this.environment, this);
        this.declaredPackages.put(fullFlatName, binding);
        if (parent == null) {
            this.environment.knownPackages.put(name, binding);
        }
        return binding;
    }

    PackageBinding getVisiblePackage(PackageBinding parent, char[] name) {
        char[][] parentName = parent == null ? CharOperation.NO_CHAR_CHAR : parent.compoundName;
        char[][] subPkgCompoundName = CharOperation.arrayConcat(parentName, name);
        char[] fullFlatName = CharOperation.concatWith(subPkgCompoundName, '.');
        PackageBinding pkg = this.declaredPackages.get(fullFlatName);
        if (pkg != null) {
            return pkg;
        }
        pkg = parent != null ? parent.getPackage0(name) : this.environment.getPackage0(name);
        if (pkg != null) {
            if (pkg == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return this.addPackage(pkg, false);
        }
        Binding binding = null;
        if (this.environment.useModuleSystem) {
            IModuleAwareNameEnvironment moduleEnv = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
            char[][] declaringModuleNames = moduleEnv.getModulesDeclaringPackage(parentName, name, this.nameForLookup());
            if (declaringModuleNames != null) {
                if (!this.isUnnamed() && CharOperation.containsEqual(declaringModuleNames, this.moduleName)) {
                    binding = new PackageBinding(subPkgCompoundName, parent, this.environment, this);
                } else {
                    char[][] cArray = declaringModuleNames;
                    int n = declaringModuleNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PackageBinding declaredPackage;
                        char[] declaringModuleName = cArray[n2];
                        ModuleBinding declaringModule = this.environment.root.getModule(declaringModuleName);
                        if (declaringModule != null && !declaringModule.isPackageLookupActive && (declaredPackage = declaringModule.getDeclaredPackage(parentName, name)) != null) {
                            if (declaredPackage.parent != null) {
                                declaredPackage.parent.addPackage(declaredPackage, declaringModule, true);
                            }
                            parent = null;
                            binding = SplitPackageBinding.combine(declaredPackage, (PackageBinding)binding, this);
                        }
                        ++n2;
                    }
                }
            }
        } else if (this.environment.nameEnvironment.isPackage(parentName, name)) {
            binding = new PackageBinding(subPkgCompoundName, parent, this.environment, this);
        }
        if (!this.isUnnamed()) {
            binding = this.combineWithPackagesFromRequired((PackageBinding)binding, subPkgCompoundName);
        }
        if (binding == null || !binding.isValidBinding()) {
            return null;
        }
        if (parentName.length == 0) {
            ((PackageBinding)binding).environment.knownPackages.put(name, (PackageBinding)binding);
        } else if (parent != null) {
            binding = parent.addPackage((PackageBinding)binding, this, false);
        }
        return this.addPackage((PackageBinding)binding, false);
    }

    public PackageBinding getVisiblePackage(char[][] qualifiedPackageName) {
        if (qualifiedPackageName == null || qualifiedPackageName.length == 0) {
            return this.environment.defaultPackage;
        }
        PackageBinding parent = this.getTopLevelPackage(qualifiedPackageName[0]);
        if (parent == null || parent == LookupEnvironment.TheNotFoundPackage) {
            return null;
        }
        int i = 1;
        while (i < qualifiedPackageName.length) {
            PackageBinding binding = this.getVisiblePackage(parent, qualifiedPackageName[i]);
            if (binding == null || binding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            parent = binding;
            ++i;
        }
        return parent;
    }

    public PackageBinding getPackage(char[][] parentPackageName, char[] packageName) {
        if (parentPackageName == null || parentPackageName.length == 0) {
            return this.getVisiblePackage(null, packageName);
        }
        PackageBinding binding = null;
        PackageBinding parent = this.getVisiblePackage(parentPackageName);
        if (parent != null && parent != LookupEnvironment.TheNotFoundPackage) {
            binding = this.getVisiblePackage(parent, packageName);
        }
        if (binding != null) {
            return this.addPackage(binding, false);
        }
        return null;
    }

    PackageBinding addPackage(PackageBinding packageBinding, boolean checkForSplit) {
        if (packageBinding.isDeclaredIn(this)) {
            char[] packageName = packageBinding.readableName();
            if (checkForSplit && this.environment.useModuleSystem) {
                if (this.isUnnamed()) {
                    IModuleAwareNameEnvironment moduleEnv = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
                    char[][] declaringModuleNames = moduleEnv.getModulesDeclaringPackage(null, packageName, ANY);
                    if (declaringModuleNames != null) {
                        int i = 0;
                        while (i < declaringModuleNames.length) {
                            ModuleBinding otherModule = this.environment.getModule(declaringModuleNames[i]);
                            if (otherModule != null && !otherModule.isPackageLookupActive) {
                                packageBinding = SplitPackageBinding.combine(otherModule.getVisiblePackage(packageBinding.compoundName), packageBinding, this);
                            }
                            ++i;
                        }
                    }
                } else {
                    packageBinding = this.combineWithPackagesFromRequired(packageBinding, packageBinding.compoundName);
                }
            }
            this.declaredPackages.put(packageName, packageBinding);
            if (packageBinding.parent == null) {
                this.environment.knownPackages.put(packageName, packageBinding);
            }
        }
        return packageBinding;
    }

    private PackageBinding combineWithPackagesFromRequired(PackageBinding currentBinding, char[][] compoundName) {
        boolean save = this.isPackageLookupActive;
        this.isPackageLookupActive = true;
        try {
            ModuleBinding[] moduleBindingArray = this.getAllRequiredModules();
            int n = moduleBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleBinding moduleBinding = moduleBindingArray[n2];
                if (!moduleBinding.isPackageLookupActive) {
                    currentBinding = SplitPackageBinding.combine(moduleBinding.getVisiblePackage(compoundName), currentBinding, this);
                }
                ++n2;
            }
            PackageBinding packageBinding = currentBinding;
            return packageBinding;
        }
        finally {
            this.isPackageLookupActive = save;
        }
    }

    public boolean canAccess(PackageBinding pkg) {
        if (pkg.isDeclaredIn(this)) {
            return true;
        }
        ModuleBinding[] moduleBindingArray = this.getAllRequiredModules();
        int n = moduleBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleBinding requiredModule = moduleBindingArray[n2];
            if (requiredModule.isPackageExportedTo(pkg, this)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        return CharOperation.prepend('\"', this.moduleName);
    }

    @Override
    public int kind() {
        return 64;
    }

    @Override
    public char[] readableName() {
        return this.moduleName;
    }

    public String toString() {
        char[] targetModule;
        int n;
        int n2;
        char[][] cArrayArray;
        char[][] allNames;
        int n3;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        if (this.isOpen()) {
            buffer.append("open ");
        }
        buffer.append("module " + new String(this.readableName()));
        if (this.requires.length > 0) {
            buffer.append("\n/*    requires    */\n");
            i = 0;
            while (i < this.requires.length) {
                buffer.append("\n\t");
                if (this.requiresTransitive != null) {
                    ModuleBinding[] moduleBindingArray = this.requiresTransitive;
                    n3 = this.requiresTransitive.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ModuleBinding reqTrans = moduleBindingArray[n4];
                        if (reqTrans == this.requires[i]) {
                            buffer.append("transitive ");
                            break;
                        }
                        ++n4;
                    }
                }
                buffer.append(this.requires[i].moduleName);
                ++i;
            }
        } else {
            buffer.append("\nNo Requires");
        }
        if (this.exportedPackages != null && this.exportedPackages.length > 0) {
            buffer.append("\n/*    exports    */\n");
            i = 0;
            while (i < this.exportedPackages.length) {
                PackageBinding export = this.exportedPackages[i];
                buffer.append("\n\t");
                if (export == null) {
                    buffer.append("<unresolved>");
                } else {
                    SimpleSetOfCharArray restrictions;
                    buffer.append(export.readableName());
                    SimpleSetOfCharArray simpleSetOfCharArray = restrictions = this.exportRestrictions != null ? this.exportRestrictions.get(export) : null;
                    if (restrictions != null) {
                        buffer.append(" to ");
                        String sep = "";
                        allNames = new char[restrictions.elementSize][];
                        restrictions.asArray((Object[])allNames);
                        cArrayArray = allNames;
                        n2 = allNames.length;
                        n = 0;
                        while (n < n2) {
                            targetModule = cArrayArray[n];
                            buffer.append(sep);
                            buffer.append(targetModule);
                            sep = ", ";
                            ++n;
                        }
                    }
                }
                ++i;
            }
        } else {
            buffer.append("\nNo Exports");
        }
        if (this.openedPackages != null && this.openedPackages.length > 0) {
            buffer.append("\n/*    exports    */\n");
            i = 0;
            while (i < this.openedPackages.length) {
                PackageBinding opens = this.openedPackages[i];
                buffer.append("\n\t");
                if (opens == null) {
                    buffer.append("<unresolved>");
                } else {
                    SimpleSetOfCharArray restrictions;
                    buffer.append(opens.readableName());
                    SimpleSetOfCharArray simpleSetOfCharArray = restrictions = this.openRestrictions != null ? this.openRestrictions.get(opens) : null;
                    if (restrictions != null) {
                        buffer.append(" to ");
                        String sep = "";
                        allNames = new char[restrictions.elementSize][];
                        restrictions.asArray((Object[])allNames);
                        cArrayArray = allNames;
                        n2 = allNames.length;
                        n = 0;
                        while (n < n2) {
                            targetModule = cArrayArray[n];
                            buffer.append(sep);
                            buffer.append(targetModule);
                            sep = ", ";
                            ++n;
                        }
                    }
                }
                ++i;
            }
        } else {
            buffer.append("\nNo Opens");
        }
        if (this.uses != null && this.uses.length > 0) {
            buffer.append("\n/*    uses    /*\n");
            i = 0;
            while (i < this.uses.length) {
                buffer.append("\n\t");
                buffer.append(this.uses[i].debugName());
                ++i;
            }
        } else {
            buffer.append("\nNo Uses");
        }
        if (this.services != null && this.services.length > 0) {
            buffer.append("\n/*    Services    */\n");
            i = 0;
            while (i < this.services.length) {
                buffer.append("\n\t");
                buffer.append("provides ");
                buffer.append(this.services[i].debugName());
                buffer.append(" with ");
                if (this.implementations != null && this.implementations.containsKey(this.services[i])) {
                    String sep = "";
                    TypeBinding[] typeBindingArray = this.implementations.get(this.services[i]);
                    int n5 = typeBindingArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        TypeBinding impl = typeBindingArray[n3];
                        buffer.append(sep).append(impl.debugName());
                        sep = ", ";
                        ++n3;
                    }
                } else {
                    buffer.append("<missing implementations>");
                }
                ++i;
            }
        } else {
            buffer.append("\nNo Services");
        }
        return buffer.toString();
    }

    public boolean isUnnamed() {
        return false;
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isTransitivelyRequired(ModuleBinding otherModule) {
        if (this.transitiveRequires == null) {
            HashSet<ModuleBinding> transitiveDeps = new HashSet<ModuleBinding>();
            this.collectTransitiveDependencies(transitiveDeps);
            this.transitiveRequires = transitiveDeps;
        }
        return this.transitiveRequires.contains(otherModule);
    }

    public int getDefaultNullness() {
        this.getAnnotationTagBits();
        return this.defaultNullness;
    }

    /* synthetic */ ModuleBinding(LookupEnvironment lookupEnvironment, ModuleBinding moduleBinding) {
        this(lookupEnvironment);
    }

    public static class UnNamedModule
    extends ModuleBinding {
        private static final char[] UNNAMED_READABLE_NAME = "<unnamed>".toCharArray();

        UnNamedModule(LookupEnvironment env) {
            super(env, null);
        }

        @Override
        public ModuleBinding[] getAllRequiredModules() {
            return Binding.NO_MODULES;
        }

        @Override
        public boolean canAccess(PackageBinding pkg) {
            ModuleBinding mod = pkg.enclosingModule;
            if (mod != null && mod != this) {
                return mod.isPackageExportedTo(pkg, this);
            }
            return true;
        }

        @Override
        public boolean isPackageExportedTo(PackageBinding pkg, ModuleBinding client) {
            return pkg.isDeclaredIn(this) && pkg.hasCompilationUnit(false);
        }

        @Override
        public boolean isUnnamed() {
            return true;
        }

        @Override
        public char[] nameForLookup() {
            return ANY;
        }

        @Override
        public char[] readableName() {
            return UNNAMED_READABLE_NAME;
        }

        @Override
        public String toString() {
            return "The Unnamed Module";
        }
    }
}

