/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModificationLog {
    private static Map<Integer, Tag> activeTags = new HashMap<Integer, Tag>();
    private final ArrayDeque<Tag> operationStack = new ArrayDeque();
    private long[] buffer0;
    private int[] buffer1;
    private byte[] operation;
    private int insertionPosition;
    private int currentEntries;
    private long timer;
    public static final byte PUSH_OPERATION = 0;
    public static final byte POP_OPERATION = 1;
    public static final byte WRITE_OPERATION = 2;
    public static final byte MALLOC_OPERATION = 3;
    public static final byte FREE_OPERATION = 4;

    public ModificationLog(int size) {
        this.allocateBuffers(size);
    }

    public void clear() {
        this.currentEntries = 0;
    }

    private void allocateBuffers(int sizeInMegs) {
        int entries = ModificationLog.getBufferEntriesFor(sizeInMegs);
        if (entries != 0) {
            this.buffer0 = new long[entries];
            this.buffer1 = new int[entries];
            this.operation = new byte[entries];
        } else {
            this.buffer0 = null;
            this.buffer1 = null;
            this.operation = null;
        }
    }

    private static int getBufferEntriesFor(int sizeInMegs) {
        int sizeOfABufferEntry = 13;
        return sizeInMegs * 1024 * 1024 / sizeOfABufferEntry;
    }

    public int getBufferEntries() {
        return this.buffer0 == null ? 0 : this.buffer0.length;
    }

    public void setBufferSize(int megs) {
        int newBufferLength;
        int oldBufferLength = this.getBufferEntries();
        if (oldBufferLength == (newBufferLength = ModificationLog.getBufferEntriesFor(megs))) {
            return;
        }
        long[] oldBuffer0 = this.buffer0;
        int[] oldBuffer1 = this.buffer1;
        byte[] oldOperation = this.operation;
        this.allocateBuffers(megs);
        if (this.buffer0 == null) {
            this.currentEntries = 0;
            this.insertionPosition = 0;
            this.operationStack.clear();
            return;
        }
        int newBufferSize = Math.min(this.buffer0.length, this.currentEntries);
        if (oldBufferLength > 0) {
            int readStart = (this.insertionPosition + oldBufferLength - newBufferSize) % oldBufferLength;
            if (readStart >= this.insertionPosition) {
                int entriesFromEnd = oldBufferLength - readStart;
                System.arraycopy(oldBuffer0, readStart, this.buffer0, 0, entriesFromEnd);
                System.arraycopy(oldBuffer1, readStart, this.buffer1, 0, entriesFromEnd);
                System.arraycopy(oldOperation, readStart, this.operation, 0, entriesFromEnd);
                System.arraycopy(oldBuffer0, 0, this.buffer0, entriesFromEnd, this.insertionPosition);
                System.arraycopy(oldBuffer1, 0, this.buffer1, entriesFromEnd, this.insertionPosition);
                System.arraycopy(oldOperation, 0, this.operation, entriesFromEnd, this.insertionPosition);
            } else {
                int entriesToCopy = this.insertionPosition - readStart;
                System.arraycopy(oldBuffer0, readStart, this.buffer0, 0, entriesToCopy);
                System.arraycopy(oldBuffer1, readStart, this.buffer1, 0, entriesToCopy);
                System.arraycopy(oldOperation, readStart, this.operation, 0, entriesToCopy);
            }
        }
        this.currentEntries = newBufferSize;
        this.insertionPosition = newBufferSize % this.buffer0.length;
    }

    public static void indent(StringBuilder builder, int indent) {
        int count = 0;
        while (count < indent) {
            builder.append("    ");
            ++count;
        }
    }

    public boolean enabled() {
        return this.buffer0 != null;
    }

    public void start(Tag tag) {
        if (!this.enabled()) {
            return;
        }
        this.operationStack.add(tag);
        this.addToQueue((byte)0, 0L, tag.opNum);
    }

    public void end(Tag tag) {
        if (!this.enabled()) {
            return;
        }
        if (!this.operationStack.getLast().equals(tag)) {
            throw new IllegalStateException();
        }
        this.operationStack.removeLast();
        this.addToQueue((byte)1, 0L, tag.opNum);
    }

    public void recordWrite(long address, int size) {
        if (!this.enabled()) {
            return;
        }
        ++this.timer;
        this.addToQueue((byte)2, address, size);
    }

    public void recordMalloc(long address, int size) {
        if (!this.enabled()) {
            return;
        }
        ++this.timer;
        this.addToQueue((byte)3, address, size);
    }

    public void recordFree(long address, int size) {
        if (!this.enabled()) {
            return;
        }
        ++this.timer;
        this.addToQueue((byte)4, address, size);
    }

    private void addToQueue(byte opConstant, long arg0, int arg1) {
        this.buffer0[this.insertionPosition] = arg0;
        this.buffer1[this.insertionPosition] = arg1;
        this.operation[this.insertionPosition] = opConstant;
        this.insertionPosition = (this.insertionPosition + 1) % this.buffer0.length;
        if (this.currentEntries < this.buffer0.length) {
            ++this.currentEntries;
        }
    }

    public long getWriteCount() {
        return this.timer;
    }

    public MemoryAccessLog getReportFor(long address, int size) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.addAll(this.operationStack);
        ArrayList<MemoryOperation> operations = new ArrayList<MemoryOperation>();
        if (this.buffer0 != null) {
            int pointerToStart = (this.insertionPosition + this.buffer0.length - this.currentEntries) % this.buffer0.length;
            int currentPosition = (this.insertionPosition + this.buffer0.length - 1) % this.buffer0.length;
            long currentWrite = this.timer;
            do {
                long nextAddress = this.buffer0[currentPosition];
                int nextArgument = this.buffer1[currentPosition];
                byte nextOp = this.operation[currentPosition];
                switch (nextOp) {
                    case 1: {
                        tags.add(this.getTagForId(nextArgument));
                        break;
                    }
                    case 0: {
                        tags.remove(tags.size() - 1);
                        break;
                    }
                    default: {
                        long diff;
                        boolean isMatch = false;
                        if (address < nextAddress) {
                            diff = nextAddress - address;
                            if (diff < (long)size) {
                                isMatch = true;
                            }
                        } else {
                            diff = address - nextAddress;
                            if (diff < (long)nextArgument) {
                                isMatch = true;
                            }
                        }
                        if (isMatch) {
                            ArrayList<Tag> stack = new ArrayList<Tag>();
                            stack.addAll(tags);
                            MemoryOperation nextOperation = new MemoryOperation(nextOp, currentWrite, nextAddress, nextArgument, stack);
                            operations.add(nextOperation);
                        }
                        --currentWrite;
                    }
                }
            } while ((currentPosition = (currentPosition + this.buffer0.length - 1) % this.buffer0.length) != pointerToStart);
        }
        return new MemoryAccessLog(operations);
    }

    public static Tag createTag(String tagName) {
        Tag result = new Tag(tagName, activeTags.size());
        activeTags.put(activeTags.size(), result);
        return result;
    }

    private Tag getTagForId(int nextArgument) {
        return activeTags.get(nextArgument);
    }

    public static class MemoryAccessLog {
        private final List<MemoryOperation> operations;

        public MemoryAccessLog(List<MemoryOperation> operations) {
            this.operations = operations;
        }

        public List<MemoryOperation> getOperations() {
            return this.operations;
        }

        public boolean hasInconsistentMemoryAllocation() {
            boolean known = false;
            boolean allocated = false;
            for (MemoryOperation next : this.operations) {
                boolean newAllocatedState;
                if (next.getOperationType() == 3) {
                    newAllocatedState = false;
                } else {
                    if (next.getOperationType() != 4) continue;
                    newAllocatedState = true;
                }
                if (!known) {
                    known = true;
                } else if (allocated == newAllocatedState) {
                    return true;
                }
                allocated = newAllocatedState;
            }
            return false;
        }

        public MemoryAccessLog reduce(int maxWrites) {
            boolean includeAllMallocs = this.hasInconsistentMemoryAllocation();
            int numWrites = 0;
            ArrayList<MemoryOperation> result = new ArrayList<MemoryOperation>();
            for (MemoryOperation next : this.operations) {
                boolean keepGoing = true;
                switch (next.getOperationType()) {
                    case 3: {
                        result.add(next);
                        keepGoing = includeAllMallocs;
                        break;
                    }
                    case 4: {
                        result.add(next);
                        break;
                    }
                    case 2: {
                        if (numWrites < maxWrites) {
                            result.add(next);
                        }
                        ++numWrites;
                    }
                }
                if (!keepGoing) break;
            }
            return new MemoryAccessLog(result);
        }
    }

    public static class MemoryOperation {
        private final List<Tag> stack;
        private final long time;
        private final long startAddress;
        private final int addressSize;
        private final byte operationType;

        public MemoryOperation(byte operationType, long time, long startAddress, int size, List<Tag> stack) {
            this.operationType = operationType;
            this.time = time;
            this.startAddress = startAddress;
            this.addressSize = size;
            this.stack = stack;
        }

        public List<Tag> getStack() {
            return this.stack;
        }

        public long getTime() {
            return this.time;
        }

        public long getStartAddress() {
            return this.startAddress;
        }

        public int getSize() {
            return this.addressSize;
        }

        public byte getOperationType() {
            return this.operationType;
        }

        public void printTo(StringBuilder builder, int indent) {
            ModificationLog.indent(builder, indent);
            switch (this.getOperationType()) {
                case 4: {
                    builder.append("freed");
                    break;
                }
                case 3: {
                    builder.append("malloc'd");
                    break;
                }
                case 2: {
                    builder.append("wrote");
                }
            }
            builder.append(" [address ");
            builder.append(this.startAddress);
            builder.append(", size ");
            builder.append(this.addressSize);
            builder.append("] at time ");
            builder.append(this.time);
            builder.append("\n");
            ArrayList<Tag> theStack = new ArrayList<Tag>();
            theStack.addAll(this.getStack());
            Collections.reverse(theStack);
            for (Tag next : theStack) {
                ModificationLog.indent(builder, indent + 1);
                builder.append(String.valueOf(next.name) + "\n");
            }
        }
    }

    public static class Tag {
        public final String name;
        public final int opNum;

        Tag(String name, int opNum) {
            this.name = name;
            this.opNum = opNum;
        }

        public String toString() {
            return String.valueOf(this.opNum) + ":" + this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.opNum;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tag other = (Tag)obj;
            return this.opNum == other.opNum;
        }
    }
}

