/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class Policy {
    public static final String PI_FILE_SYSTEM = "org.eclipse.core.filesystem";

    public static void debug(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public static void error(int code, String message) throws CoreException {
        Policy.error(code, message, null);
    }

    public static void error(int code, String message, Throwable exception) throws CoreException {
        int severity = code == 0 ? 0 : 1 << code % 100 / 33;
        throw new CoreException(new Status(severity, PI_FILE_SYSTEM, code, message, exception));
    }

    public static void log(int severity, String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        RuntimeLog.log(new Status(severity, PI_FILE_SYSTEM, 1, message, t));
    }

    public static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void safeClose(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }
}

