/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.pyx4j.log4j.MavenLogAppender;
import java.io.File;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.basepom.mojo.propertyhelper.DateField;
import org.basepom.mojo.propertyhelper.MacroField;
import org.basepom.mojo.propertyhelper.NumberField;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.PropertyField;
import org.basepom.mojo.propertyhelper.StringField;
import org.basepom.mojo.propertyhelper.UuidField;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.beans.DateDefinition;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.beans.MacroDefinition;
import org.basepom.mojo.propertyhelper.beans.NumberDefinition;
import org.basepom.mojo.propertyhelper.beans.PropertyGroup;
import org.basepom.mojo.propertyhelper.beans.StringDefinition;
import org.basepom.mojo.propertyhelper.beans.UuidDefinition;
import org.basepom.mojo.propertyhelper.util.Log;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractPropertyHelperMojo
extends AbstractMojo
implements Contextualizable {
    @Component
    private MavenProject project;
    @Component
    private Settings settings;
    @Parameter(required=true, readonly=true, defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="fail")
    private String onDuplicateProperty = "fail";
    @Parameter(defaultValue="fail")
    private String onMissingProperty = "fail";
    @Parameter
    private String[] activeGroups = new String[0];
    @Parameter
    private PropertyGroup[] propertyGroups = new PropertyGroup[0];
    @Parameter
    private NumberDefinition[] numbers = new NumberDefinition[0];
    @Parameter
    private StringDefinition[] strings = new StringDefinition[0];
    @Parameter
    private DateDefinition[] dates = new DateDefinition[0];
    @Parameter
    private MacroDefinition[] macros = new MacroDefinition[0];
    @Parameter
    private UuidDefinition[] uuids = new UuidDefinition[0];
    protected final Log LOG = Log.findLog();
    protected final ValueCache valueCache = new ValueCache();
    private final Map<String, String> values = Maps.newHashMap();
    private List<NumberField> numberFields = null;
    private PlexusContainer container = null;
    private boolean isSnapshot;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block5: {
            MavenLogAppender.startPluginLog((AbstractMojo)this);
            this.isSnapshot = this.project.getArtifact().isSnapshot();
            this.LOG.debug("Project is a %s.", this.isSnapshot ? "snapshot" : "release");
            this.LOG.trace("%s on duplicate, %s on missing", this.onDuplicateProperty, this.onMissingProperty);
            try {
                if (this.skip) {
                    this.LOG.debug("Skipping execution!");
                    break block5;
                }
                this.doExecute();
            }
            catch (Exception e) {
                try {
                    Throwables.propagateIfInstanceOf((Throwable)e, MojoExecutionException.class);
                    Throwables.propagateIfInstanceOf((Throwable)e, MojoFailureException.class);
                    throw new MojoExecutionException("While running mojo: ", e);
                }
                catch (Throwable throwable) {
                    this.LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
                    MavenLogAppender.endPluginLog((AbstractMojo)this);
                    throw throwable;
                }
            }
        }
        this.LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
        MavenLogAppender.endPluginLog((AbstractMojo)this);
    }

    public MavenProject getProject() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project is null");
        return this.project;
    }

    public Settings getSettings() {
        Preconditions.checkNotNull((Object)this.settings, (Object)"settings is null");
        return this.settings;
    }

    public File getBasedir() {
        Preconditions.checkNotNull((Object)this.basedir, (Object)"basedir is null");
        return this.basedir;
    }

    public PlexusContainer getContainer() {
        Preconditions.checkNotNull((Object)this.container, (Object)"container is null");
        return this.container;
    }

    @CheckForNull
    public List<NumberField> getNumbers() {
        return this.numberFields;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected abstract void doExecute() throws Exception;

    protected void loadPropertyElements() throws Exception {
        ImmutableList.Builder propertyElements = ImmutableList.builder();
        this.numberFields = NumberField.createNumbers(this.valueCache, this.numbers);
        propertyElements.addAll(this.numberFields);
        propertyElements.addAll(StringField.createStrings(this.valueCache, this.strings));
        propertyElements.addAll(DateField.createDates(this.valueCache, this.dates));
        propertyElements.addAll(MacroField.createMacros(this.valueCache, this.macros, this));
        propertyElements.addAll(UuidField.createUuids(this.valueCache, this.uuids));
        for (PropertyElement pe : propertyElements.build()) {
            Optional<String> value = pe.getPropertyValue();
            this.values.put(pe.getPropertyName(), (String)value.orNull());
            if (pe.isExport()) {
                String result = (String)value.or((Object)"");
                this.project.getProperties().setProperty(pe.getPropertyName(), result);
                this.LOG.debug("Exporting Property name: %s, value: %s", pe.getPropertyName(), result);
                continue;
            }
            this.LOG.debug("Property name: %s, value: %s", pe.getPropertyName(), value.or((Object)"<null>"));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> propertyNames = new HashSet<String>();
        if (this.propertyGroups != null) {
            for (PropertyGroup propertyGroup : this.propertyGroups) {
                List<PropertyElement> propertyFields = PropertyField.createProperties(this.project.getModel(), this.values, propertyGroup);
                builder.put((Object)propertyGroup.getId(), new AbstractMap.SimpleImmutableEntry<PropertyGroup, List<PropertyElement>>(propertyGroup, propertyFields));
            }
        }
        ImmutableMap propertyPairs = builder.build();
        if (this.activeGroups != null) {
            for (String activeGroup : this.activeGroups) {
                Map.Entry propertyElement = (Map.Entry)propertyPairs.get(activeGroup);
                Preconditions.checkState((propertyElement != null ? 1 : 0) != 0, (String)"activated group '%s' does not exist", (Object[])new Object[]{activeGroup});
                PropertyGroup propertyGroup = (PropertyGroup)propertyElement.getKey();
                if (propertyGroup.isActiveOnRelease() && !this.isSnapshot || propertyGroup.isActiveOnSnapshot() && this.isSnapshot) {
                    for (PropertyElement pe : (List)propertyElement.getValue()) {
                        Optional<String> value = pe.getPropertyValue();
                        String propertyName = pe.getPropertyName();
                        IgnoreWarnFail.checkState(propertyGroup.getOnDuplicateProperty(), !propertyNames.contains(propertyName), "property name '" + propertyName + "'");
                        propertyNames.add(propertyName);
                        this.project.getProperties().setProperty(propertyName, (String)value.or((Object)""));
                    }
                    continue;
                }
                this.LOG.debug("Skipping property group %s: Snapshot: %b, activeOnSnapshot: %b, activeOnRelease: %b", activeGroup, this.isSnapshot, propertyGroup.isActiveOnSnapshot(), propertyGroup.isActiveOnRelease());
            }
        }
    }
}

