/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class InterpolatorFactory {
    private static final List<String> SYNONYM_PREFIXES = ImmutableList.of((Object)"project", (Object)"pom");
    private static final String PREFIX = "#{";
    private static final String POSTFIX = "}";
    private final Optional<Model> model;

    public InterpolatorFactory(Optional<Model> model) {
        this.model = (Optional)Preconditions.checkNotNull(model, (Object)"model is null");
    }

    public String interpolate(String value, IgnoreWarnFail onMissingProperty, Map<String, String> properties) throws IOException, InterpolationException {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        StringSearchInterpolator interpolator = new StringSearchInterpolator(PREFIX, POSTFIX);
        interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
        if (this.model.isPresent()) {
            Model pomModel = (Model)this.model.get();
            interpolator.addValueSource((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)pomModel), SYNONYM_PREFIXES, true));
            interpolator.addValueSource((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(pomModel.getProperties()), SYNONYM_PREFIXES, true));
        }
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(properties));
        String result = interpolator.interpolate(value, (RecursionInterceptor)new PrefixAwareRecursionInterceptor(SYNONYM_PREFIXES, true));
        String stripped = result.replaceAll(Pattern.quote(PREFIX) + ".*?" + Pattern.quote(POSTFIX), "");
        IgnoreWarnFail.checkState(onMissingProperty, stripped.equals(result), "property");
        return stripped;
    }
}

