/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.basepom.mojo.propertyhelper.AbstractPropertyHelperMojo;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.MacroDefinition;
import org.basepom.mojo.propertyhelper.macros.MacroType;

public class MacroField
implements PropertyElement {
    private final MacroDefinition macroDefinition;
    private final ValueProvider valueProvider;
    private final AbstractPropertyHelperMojo mojo;

    public static List<MacroField> createMacros(ValueCache valueCache, MacroDefinition[] macroDefinitions, AbstractPropertyHelperMojo mojo) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        Preconditions.checkNotNull((Object)macroDefinitions, (Object)"macroDefinitions is null");
        Preconditions.checkNotNull((Object)((Object)mojo), (Object)"mojo is null");
        ImmutableList.Builder result = ImmutableList.builder();
        for (MacroDefinition macroDefinition : macroDefinitions) {
            macroDefinition.check();
            ValueProvider macroValue = valueCache.getValueProvider(macroDefinition);
            MacroField macroField = new MacroField(macroDefinition, macroValue, mojo);
            result.add((Object)macroField);
        }
        return result.build();
    }

    public MacroField(MacroDefinition macroDefinition, ValueProvider valueProvider, AbstractPropertyHelperMojo mojo) {
        this.macroDefinition = macroDefinition;
        this.valueProvider = valueProvider;
        this.mojo = mojo;
    }

    @Override
    public String getPropertyName() {
        return this.macroDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() throws Exception {
        MacroType macroType;
        Optional<String> type = this.macroDefinition.getMacroType();
        if (type.isPresent()) {
            macroType = (MacroType)MacroType.class.cast(this.mojo.getContainer().lookup(MacroType.ROLE, (String)type.get()));
        } else {
            Optional<String> macroClassName = this.macroDefinition.getMacroClass();
            Preconditions.checkState((boolean)macroClassName.isPresent(), (String)"No definition for macro '%s' found!", (Object[])new Object[]{this.macroDefinition.getId()});
            Class<?> macroClass = Class.forName((String)macroClassName.get());
            macroType = (MacroType)MacroType.class.cast(macroClass.newInstance());
        }
        Optional<String> result = macroType.getValue(this.macroDefinition, this.valueProvider, this.mojo);
        if (result.isPresent()) {
            return this.macroDefinition.formatResult((String)result.get());
        }
        return result;
    }

    @Override
    public boolean isExport() {
        return this.macroDefinition.isExport();
    }

    public String toString() {
        try {
            return (String)this.getPropertyValue().or((Object)"");
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

