/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.basepom.mojo.propertyhelper.InterpolatorFactory;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.beans.PropertyGroup;
import org.codehaus.plexus.interpolation.InterpolationException;

public class PropertyField
implements PropertyElement {
    private final String propertyName;
    private final String propertyValue;

    public static List<PropertyElement> createProperties(Model model, Map<String, String> values, PropertyGroup propertyGroup) throws IOException, InterpolationException {
        Preconditions.checkNotNull((Object)model, (Object)"model is null");
        Preconditions.checkNotNull(values, (Object)"values is null");
        Preconditions.checkNotNull((Object)propertyGroup, (Object)"propertyGroup is null");
        InterpolatorFactory interpolatorFactory = new InterpolatorFactory((Optional<Model>)Optional.of((Object)model));
        ImmutableList.Builder result = ImmutableList.builder();
        Map<String, String> properties = propertyGroup.getProperties();
        for (String name : properties.keySet()) {
            String value = propertyGroup.getPropertyValue(interpolatorFactory, name, values);
            result.add((Object)new PropertyField(name, value));
        }
        return result.build();
    }

    PropertyField(String propertyName, String propertyValue) {
        this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName is null");
        this.propertyValue = (String)Preconditions.checkNotNull((Object)propertyValue, (Object)"propertyValue is null");
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Optional<String> getPropertyValue() {
        return Optional.of((Object)this.propertyValue);
    }

    @Override
    public boolean isExport() {
        return true;
    }
}

