/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public final class TransformerRegistry {
    private static final Map<String, Function<String, String>> REGISTRY;

    private TransformerRegistry() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    public static List<Function<String, String>> getTransformers(String transformerNames) {
        if (transformerNames == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder transformers = ImmutableList.builder();
        for (String transformerName : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)transformerNames)) {
            transformers.add(TransformerRegistry.forName(transformerName));
        }
        return transformers.build();
    }

    public static String applyTransformers(String transformers, String value) {
        String res = value;
        for (Function<String, String> transformer : TransformerRegistry.getTransformers(transformers)) {
            if (res == null) continue;
            res = (String)transformer.apply((Object)res);
        }
        return res;
    }

    public static Function<String, String> forName(String transformerName) {
        Preconditions.checkNotNull((Object)transformerName, (Object)"transformerName is null");
        Function<String, String> transformer = REGISTRY.get(transformerName.toLowerCase(Locale.ENGLISH));
        Preconditions.checkState((transformer != null ? 1 : 0) != 0, (String)"Transformer '%s' is unknown.", (Object[])new Object[]{transformerName});
        return transformer;
    }

    static {
        ImmutableMap.Builder registry = ImmutableMap.builder();
        registry.put((Object)"lowercase", (Object)new LowercaseTransformer());
        registry.put((Object)"uppercase", (Object)new UppercaseTransformer());
        registry.put((Object)"remove_whitespace", (Object)new RemoveWhitespaceTransformer());
        registry.put((Object)"underscore_for_whitespace", (Object)new UnderscoreForWhitespaceTransformer());
        registry.put((Object)"dash_for_whitespace", (Object)new DashForWhitespaceTransformer());
        registry.put((Object)"use_underscore", (Object)new UseUnderscoreTransformer());
        registry.put((Object)"use_dash", (Object)new UseDashTransformer());
        registry.put((Object)"trim", (Object)new TrimTransformer());
        REGISTRY = registry.build();
    }

    public static class TrimTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.trimFrom((CharSequence)value);
        }
    }

    public static class UseDashTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.or(CharMatcher.anyOf((CharSequence)"-_")).collapseFrom((CharSequence)value, '-');
        }
    }

    public static class UseUnderscoreTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.or(CharMatcher.anyOf((CharSequence)"-_")).collapseFrom((CharSequence)value, '_');
        }
    }

    public static class DashForWhitespaceTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.collapseFrom((CharSequence)value, '-');
        }
    }

    public static class UnderscoreForWhitespaceTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.collapseFrom((CharSequence)value, '_');
        }
    }

    public static class RemoveWhitespaceTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return CharMatcher.WHITESPACE.removeFrom((CharSequence)value);
        }
    }

    public static class UppercaseTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return value.toUpperCase(Locale.ENGLISH);
        }
    }

    public static class LowercaseTransformer
    implements Function<String, String> {
        public String apply(@Nonnull String value) {
            return value.toLowerCase(Locale.ENGLISH);
        }
    }
}

