/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.AbstractDefinition;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFailCreate;
import org.basepom.mojo.propertyhelper.util.Log;

public class ValueCache {
    private static final Log LOG = Log.findLog();
    private Map<File, ValueCacheEntry> valueFiles = Maps.newHashMap();
    private final Map<String, String> ephemeralValues = new HashMap<String, String>();

    public ValueProvider getValueProvider(AbstractDefinition<?> definition) throws IOException {
        Optional<Map<String, String>> values = this.getValues(definition);
        if (!values.isPresent()) {
            String name = definition.getPropertyName();
            Optional<String> value = definition.getInitialValue();
            if (value.isPresent()) {
                this.ephemeralValues.put(name, (String)value.get());
            }
            return new ValueProvider.MapValueProvider(this.ephemeralValues, name);
        }
        return ValueCache.findCurrentValueProvider((Map)values.get(), definition);
    }

    @VisibleForTesting
    static ValueProvider findCurrentValueProvider(Map<String, String> values, AbstractDefinition<?> definition) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        String name = definition.getPropertyName();
        boolean hasValue = values.containsKey(name);
        boolean createProperty = IgnoreWarnFailCreate.checkState(definition.getOnMissingProperty(), hasValue, name);
        if (hasValue) {
            return new ValueProvider.MapValueProvider(values, name);
        }
        if (createProperty) {
            if (definition.getInitialValue().isPresent()) {
                values.put(name, (String)definition.getInitialValue().get());
            }
            return new ValueProvider.MapValueProvider(values, name);
        }
        return ValueProvider.NULL_PROVIDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Optional<Map<String, String>> getValues(AbstractDefinition<?> definition) throws IOException {
        Optional<File> definitionFile = definition.getPropertyFile();
        if (!definitionFile.isPresent()) {
            return Optional.absent();
        }
        File canonicalFile = ((File)definitionFile.get()).getCanonicalFile();
        boolean createFile = IgnoreWarnFailCreate.checkState(definition.getOnMissingFile(), canonicalFile.exists(), ((File)definitionFile.get()).getCanonicalPath());
        ValueCacheEntry cacheEntry = this.valueFiles.get(canonicalFile);
        if (cacheEntry != null) {
            if (createFile) {
                cacheEntry.doCreate();
            }
        } else {
            Properties props = new Properties();
            if (!canonicalFile.exists()) {
                cacheEntry = new ValueCacheEntry(props, false, createFile);
                this.valueFiles.put(canonicalFile, cacheEntry);
            } else if (canonicalFile.isFile() && canonicalFile.canRead()) {
                Closer closer = Closer.create();
                try {
                    InputStream stream = (InputStream)closer.register((Closeable)new FileInputStream(canonicalFile));
                    props.load(stream);
                    cacheEntry = new ValueCacheEntry(props, true, createFile);
                    this.valueFiles.put(canonicalFile, cacheEntry);
                }
                finally {
                    closer.close();
                }
            } else {
                throw new IllegalStateException(String.format("Can not load %s, not a file!", ((File)definitionFile.get()).getCanonicalPath()));
            }
        }
        return Optional.of(cacheEntry.getValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        for (Map.Entry<File, ValueCacheEntry> entries : this.valueFiles.entrySet()) {
            File folder;
            ValueCacheEntry entry = entries.getValue();
            if (!entry.isDirty()) continue;
            File file = entries.getKey();
            if (!entry.isExists() && !entry.isCreate()) continue;
            Preconditions.checkNotNull((Object)file, (Object)"no file defined, can not persist!");
            File oldFile = new File(file.getCanonicalPath() + ".bak");
            if (entry.isExists()) {
                Preconditions.checkState((boolean)file.exists(), (String)"'%s' should exist!", (Object[])new Object[]{file.getCanonicalPath()});
                if (oldFile.exists()) {
                    Preconditions.checkState((boolean)oldFile.delete(), (String)"Could not delete '%s'", (Object[])new Object[]{file.getCanonicalPath()});
                }
            }
            if (!(folder = file.getParentFile()).exists()) {
                Preconditions.checkState((boolean)folder.mkdirs(), (String)"Could not create folder '%s'", (Object[])new Object[]{folder.getCanonicalPath()});
            }
            Closer closer = Closer.create();
            File newFile = new File(file.getCanonicalPath() + ".new");
            try {
                OutputStream stream = (OutputStream)closer.register((Closeable)new FileOutputStream(newFile));
                entry.store(stream, "created by property-helper-maven-plugin");
            }
            finally {
                closer.close();
            }
            if (file.exists() && !file.renameTo(oldFile)) {
                LOG.warn("Could not rename '%s' to '%s'!", file, oldFile);
            }
            if (file.exists() || newFile.renameTo(file)) continue;
            LOG.warn("Could not rename '%s' to '%s'!", newFile, file);
        }
    }

    public static class ValueCacheEntry {
        private final Map<String, String> values = new HashMap<String, String>();
        private final boolean exists;
        private boolean create;
        private boolean dirty = false;

        ValueCacheEntry(@Nonnull Properties props, boolean exists, boolean create) {
            Preconditions.checkNotNull((Object)props, (Object)"props is null");
            this.values.putAll((Map<String, String>)Maps.fromProperties((Properties)props));
            this.exists = exists;
            this.create = create;
        }

        public void store(OutputStream out, String comment) throws IOException {
            Properties p = new Properties();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                p.setProperty(entry.getKey(), entry.getValue());
            }
            p.store(out, comment);
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void dirty() {
            this.dirty = true;
        }

        public Map<String, String> getValues() {
            return new ForwardingMap<String, String>(){

                protected Map<String, String> delegate() {
                    return ValueCacheEntry.this.values;
                }

                public String remove(Object object) {
                    ValueCacheEntry.this.dirty();
                    return (String)super.remove(object);
                }

                public void clear() {
                    ValueCacheEntry.this.dirty();
                    super.clear();
                }

                public String put(String key, String value) {
                    String oldValue = (String)super.put((Object)key, (Object)value);
                    if (!Objects.equal((Object)value, (Object)oldValue)) {
                        ValueCacheEntry.this.dirty();
                    }
                    return oldValue;
                }

                public void putAll(Map<? extends String, ? extends String> map) {
                    ValueCacheEntry.this.dirty();
                    super.putAll(map);
                }
            };
        }

        public boolean isExists() {
            return this.exists;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void doCreate() {
            this.create = true;
            this.dirty();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            ValueCacheEntry that = (ValueCacheEntry)other;
            return Objects.equal(this.values, that.values) && Objects.equal((Object)this.dirty, (Object)that.dirty) && Objects.equal((Object)this.exists, (Object)that.exists) && Objects.equal((Object)this.create, (Object)that.create);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.values, this.dirty, this.exists, this.create});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("values", this.values).add("exists", this.exists).add("create", this.create).add("dirty", this.dirty).toString();
        }
    }
}

