/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;

public interface ValueProvider {
    public static final ValueProvider NULL_PROVIDER = new NullProvider();

    public Optional<String> getValue();

    public void setValue(String var1);

    public static class PropertyProvider
    implements ValueProvider {
        private final Properties props;
        private final String propertyName;

        PropertyProvider(Properties props, String propertyName) {
            this.props = props;
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName is null");
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.props.setProperty(this.propertyName, value);
        }

        @Override
        public Optional<String> getValue() {
            return Optional.fromNullable((Object)this.props.getProperty(this.propertyName));
        }
    }

    public static class MapValueProvider
    implements ValueProvider {
        private final Map<String, String> values;
        private final String valueName;

        MapValueProvider(Map<String, String> values, String valueName) {
            this.valueName = (String)Preconditions.checkNotNull((Object)valueName, (Object)"valueName is null");
            this.values = values;
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.values.put(this.valueName, value);
        }

        @Override
        public Optional<String> getValue() {
            return Optional.fromNullable((Object)this.values.get(this.valueName));
        }
    }

    public static class StaticValueProvider
    implements ValueProvider {
        private String value;

        StaticValueProvider() {
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public Optional<String> getValue() {
            return Optional.fromNullable((Object)this.value);
        }
    }

    public static class NullProvider
    implements ValueProvider {
        private NullProvider() {
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public Optional<String> getValue() {
            return Optional.absent();
        }
    }
}

