/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import org.basepom.mojo.propertyhelper.TransformerRegistry;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFailCreate;

public abstract class AbstractDefinition<T extends AbstractDefinition<T>> {
    private String id = null;
    private boolean skip = false;
    private boolean export = false;
    private String propertyName = null;
    private File propertyFile = null;
    private String onMissingFile = "fail";
    private String onMissingProperty = "fail";
    private String initialValue = null;
    private String format = null;
    private String transformers = null;

    protected AbstractDefinition() {
    }

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    public T setId(String id) {
        this.id = ((String)Preconditions.checkNotNull((Object)id, (Object)"id is null")).trim();
        return (T)this;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @VisibleForTesting
    public T setSkip(boolean skip) {
        this.skip = skip;
        return (T)this;
    }

    public Optional<String> getTransformers() {
        return Optional.fromNullable((Object)this.transformers);
    }

    public Optional<String> getInitialValue() {
        return Optional.fromNullable((Object)this.initialValue);
    }

    @VisibleForTesting
    public T setInitialValue(String initialValue) {
        this.initialValue = ((String)Preconditions.checkNotNull((Object)initialValue, (Object)"initialValue is null")).trim();
        return (T)this;
    }

    public boolean isExport() {
        return this.export;
    }

    @VisibleForTesting
    public T setExport(boolean export) {
        this.export = export;
        return (T)this;
    }

    public String getPropertyName() {
        return (String)Objects.firstNonNull((Object)this.propertyName, (Object)this.id);
    }

    @VisibleForTesting
    public T setPropertyName(String propertyName) {
        this.propertyName = ((String)Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName is null")).trim();
        return (T)this;
    }

    public Optional<File> getPropertyFile() {
        return Optional.fromNullable((Object)this.propertyFile);
    }

    @VisibleForTesting
    public T setPropertyFile(File propertyFile) {
        this.propertyFile = (File)Preconditions.checkNotNull((Object)propertyFile, (Object)"propertyFile is null");
        return (T)this;
    }

    public IgnoreWarnFailCreate getOnMissingFile() {
        return IgnoreWarnFailCreate.forString(this.onMissingFile);
    }

    @VisibleForTesting
    public T setOnMissingFile(String onMissingFile) {
        IgnoreWarnFailCreate.forString(onMissingFile);
        this.onMissingFile = onMissingFile;
        return (T)this;
    }

    public IgnoreWarnFailCreate getOnMissingProperty() {
        return IgnoreWarnFailCreate.forString(this.onMissingProperty);
    }

    @VisibleForTesting
    public T setOnMissingProperty(String onMissingProperty) {
        IgnoreWarnFailCreate.forString(onMissingProperty);
        this.onMissingProperty = onMissingProperty;
        return (T)this;
    }

    public Optional<String> formatResult(String value) {
        Optional<String> format = this.getFormat();
        String res = format.isPresent() ? String.format((String)format.get(), value) : value;
        res = TransformerRegistry.applyTransformers(this.transformers, res);
        return Optional.fromNullable((Object)res);
    }

    public Optional<String> getFormat() {
        return Optional.fromNullable((Object)this.format);
    }

    @VisibleForTesting
    public T setFormat(String format) {
        this.format = (String)Preconditions.checkNotNull((Object)format, (Object)"format is null");
        return (T)this;
    }

    public void check() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"the id element must not be empty!");
    }
}

