/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.basepom.mojo.propertyhelper.util.Log;

public enum IgnoreWarnFailCreate {
    IGNORE,
    WARN,
    FAIL,
    CREATE;

    private static final Log LOG;

    public static IgnoreWarnFailCreate forString(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"the value can not be null");
        return Enum.valueOf(IgnoreWarnFailCreate.class, value.toUpperCase(Locale.ENGLISH));
    }

    public static boolean checkState(@Nonnull IgnoreWarnFailCreate iwfc, boolean exists, String thing) {
        if (exists) {
            return false;
        }
        switch (iwfc) {
            case IGNORE: {
                return false;
            }
            case WARN: {
                LOG.warn("'%s' does not exist!", thing);
                return false;
            }
            case FAIL: {
                throw new IllegalStateException(String.format("'%s' does not exist!", thing));
            }
            case CREATE: {
                LOG.debug("'%s' does not exist, suggesting creation.", thing);
                return true;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)iwfc));
    }

    static {
        LOG = Log.findLog();
    }
}

