/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.basepom.mojo.propertyhelper.beans.AbstractDefinition;

public class MacroDefinition
extends AbstractDefinition<MacroDefinition> {
    private String macroType = null;
    private String macroClass = null;
    private Properties properties = new Properties();

    public Optional<String> getMacroType() {
        return Optional.fromNullable((Object)this.macroType);
    }

    @VisibleForTesting
    public MacroDefinition setMacroType(String macroType) {
        this.macroType = (String)Preconditions.checkNotNull((Object)macroType, (Object)"macroType is null");
        return this;
    }

    public Optional<String> getMacroClass() {
        return Optional.fromNullable((Object)this.macroClass);
    }

    @VisibleForTesting
    public MacroDefinition setMacroClass(String macroClass) {
        this.macroClass = (String)Preconditions.checkNotNull((Object)macroClass, (Object)"macroClass is null");
        return this;
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf((Map)Maps.fromProperties((Properties)this.properties));
    }

    @VisibleForTesting
    public MacroDefinition setProperties(Properties properties) {
        this.properties = new Properties((Properties)Preconditions.checkNotNull((Object)properties, (Object)"properties is null"));
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        MacroDefinition that = (MacroDefinition)other;
        return Objects.equal((Object)this.macroType, (Object)that.macroType) && Objects.equal((Object)this.macroClass, (Object)that.macroClass) && Objects.equal((Object)this.properties, (Object)that.properties);
    }

    @Override
    public void check() {
        super.check();
        Preconditions.checkState((this.macroClass != null || this.macroType != null ? 1 : 0) != 0, (Object)"neither macro class nor macro type is defined!");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.macroType, this.macroClass, this.properties});
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("macroType", (Object)this.macroType).add("macroClass", (Object)this.macroClass).add("properties", (Object)this.properties).toString();
    }
}

