/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.basepom.mojo.propertyhelper.InterpolatorFactory;
import org.basepom.mojo.propertyhelper.TransformerRegistry;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.beans.PropertyDefinition;
import org.codehaus.plexus.interpolation.InterpolationException;

public class PropertyGroup {
    private String id;
    private boolean activeOnRelease = true;
    private boolean activeOnSnapshot = true;
    private String onDuplicateProperty = "fail";
    private String onMissingProperty = "fail";
    private PropertyDefinition[] properties = new PropertyDefinition[0];

    public String getId() {
        return this.id;
    }

    public PropertyGroup setId(String id) {
        this.id = id;
        return this;
    }

    public boolean isActiveOnRelease() {
        return this.activeOnRelease;
    }

    public PropertyGroup setActiveOnRelease(boolean activeOnRelease) {
        this.activeOnRelease = activeOnRelease;
        return this;
    }

    public boolean isActiveOnSnapshot() {
        return this.activeOnSnapshot;
    }

    public PropertyGroup setActiveOnSnapshot(boolean activeOnSnapshot) {
        this.activeOnSnapshot = activeOnSnapshot;
        return this;
    }

    public IgnoreWarnFail getOnDuplicateProperty() {
        return IgnoreWarnFail.forString(this.onDuplicateProperty);
    }

    public PropertyGroup setOnDuplicateProperty(String onDuplicateProperty) {
        IgnoreWarnFail.forString(onDuplicateProperty);
        this.onDuplicateProperty = onDuplicateProperty;
        return this;
    }

    public IgnoreWarnFail getOnMissingProperty() {
        return IgnoreWarnFail.forString(this.onMissingProperty);
    }

    public PropertyGroup setOnMissingProperty(String onMissingProperty) {
        IgnoreWarnFail.forString(onMissingProperty);
        this.onMissingProperty = onMissingProperty;
        return this;
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)Maps.uniqueIndex(Arrays.asList(this.properties), PropertyDefinition.getNameFunction()), PropertyDefinition.getValueFunction()));
    }

    public PropertyGroup setProperties(Map<String, String> properties) {
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        this.properties = new PropertyDefinition[properties.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.properties[i] = new PropertyDefinition(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Set<String> getPropertyNames() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(this.properties), PropertyDefinition.getNameFunction()));
    }

    public String getPropertyValue(InterpolatorFactory interpolatorFactory, String propertyName, Map<String, String> propElements) throws IOException, InterpolationException {
        ImmutableMap propertyMap = Maps.uniqueIndex(Arrays.asList(this.properties), PropertyDefinition.getNameFunction());
        if (!propertyMap.keySet().contains(propertyName)) {
            return "";
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)propertyMap.get(propertyName);
        String result = interpolatorFactory.interpolate(propertyDefinition.getValue(), this.getOnMissingProperty(), propElements);
        return TransformerRegistry.applyTransformers(propertyDefinition.getTransformers(), result);
    }
}

