/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.cli;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.cql.FileCQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;

public class CassandraUnitCommandLineStarter {
    private static final String LOCALHOST = "localhost";
    private static final CommandLineParser commandLineParser = new PosixParser();
    private static final Options options = new Options();
    private static final String CASSANDRA_YAML_TEMPLATE = "directory/samples/cassandra.yaml";
    private static final String CASSANDRA_YAML = "cassandra.yaml";
    private static CommandLine commandLine = null;

    public static void main(String[] args) {
        boolean exit = CassandraUnitCommandLineStarter.parseCommandLine(args);
        if (exit) {
            System.exit(1);
        } else {
            CassandraUnitCommandLineStarter.load();
        }
    }

    private static boolean parseCommandLine(String[] args) {
        CassandraUnitCommandLineStarter.initOptions();
        boolean exit = false;
        try {
            commandLine = commandLineParser.parse(options, args);
            if (commandLine.getOptions().length == 0) {
                exit = true;
                CassandraUnitCommandLineStarter.printUsage();
            } else if (CassandraUnitCommandLineStarter.containBadReplicationFactorArgumentValue()) {
                CassandraUnitCommandLineStarter.printUsage("Bad argument value for option r");
                exit = true;
            }
        }
        catch (ParseException e) {
            CassandraUnitCommandLineStarter.printUsage(e.getMessage());
            exit = true;
        }
        return exit;
    }

    protected static void load() {
        System.out.println("Starting Cassandra...");
        String port = commandLine.getOptionValue("p");
        String schemaOption = commandLine.getOptionValue("s");
        String installationFolder = commandLine.getOptionValue("d");
        String timeout = commandLine.getOptionValue("t");
        String tmpDir = installationFolder + "/temp";
        if (!CassandraUnitCommandLineStarter.hasValidValue(timeout)) {
            timeout = "20000";
        }
        Path cassandraYamlPath = Paths.get(CASSANDRA_YAML_TEMPLATE.replaceFirst("directory", installationFolder), new String[0]);
        try {
            String[] stringArray = null;
            try (Stream<String> input = Files.lines(cassandraYamlPath);
                 PrintWriter output = new PrintWriter(new File(installationFolder, CASSANDRA_YAML), "UTF-8");){
                input.map(line -> line.replace("9042", port)).map(line -> line.replace("temp/", tmpDir + "/")).forEachOrdered(output::println);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(new File(installationFolder, CASSANDRA_YAML), tmpDir, Long.parseLong(timeout));
            if (CassandraUnitCommandLineStarter.hasValidValue(schemaOption)) {
                String[] schemas;
                for (String schema : schemas = schemaOption.split(",")) {
                    CassandraUnitCommandLineStarter.dataSetLoad(LOCALHOST, port, schema);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void dataSetLoad(String host, String port, String file) {
        CqlSession session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, Integer.parseInt(port)))).withLocalDatacenter("datacenter1")).build();
        CQLDataLoader dataLoader = new CQLDataLoader(session);
        dataLoader.load(new FileCQLDataSet(file));
        System.out.println("Loading completed");
    }

    private static boolean containBadReplicationFactorArgumentValue() {
        String replicationFactor = commandLine.getOptionValue("r");
        if (CassandraUnitCommandLineStarter.hasValidValue(replicationFactor)) {
            try {
                Integer.parseInt(replicationFactor);
                return false;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasValidValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private static void printUsage(String message) {
        System.out.println(message);
        CassandraUnitCommandLineStarter.printUsage();
    }

    private static void initOptions() {
        OptionBuilder.withLongOpt((String)"schema");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"schema to load");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"target port");
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"start up timeout");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"installation directory");
        options.addOption(OptionBuilder.create((String)"d"));
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("CassandraUnitStarter is a tool to start a cassandra instance", options);
    }
}

