/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac.errorprone;

import com.google.errorprone.ErrorProneCompiler;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.JavacCompiler;

public class JavacCompilerWithErrorProne
extends AbstractCompiler {
    private Method invokerMethod;

    public JavacCompilerWithErrorProne() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return new String[0];
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompilerWithErrorProne.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args = JavacCompiler.buildCompilerArguments((CompilerConfiguration)config, (String[])sourceFiles);
        try {
            CompilerResult compilerResult = (CompilerResult)this.getInvoker().invoke(null, new Object[]{args});
            return compilerResult;
        }
        catch (Exception e) {
            throw new CompilerException(e.getMessage(), (Throwable)e);
        }
    }

    private Method getInvoker() throws CompilerException {
        if (this.invokerMethod == null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URL[] urls = ((URLClassLoader)contextClassLoader).getURLs();
            try {
                NonDelegatingClassLoader loader = new NonDelegatingClassLoader(urls, contextClassLoader);
                Class<?> clazz = Class.forName(CompilerInvoker.class.getName(), true, loader);
                this.invokerMethod = clazz.getMethod("compile", String[].class);
            }
            catch (Exception e) {
                throw new CompilerException(e.getMessage(), (Throwable)e);
            }
        }
        return this.invokerMethod;
    }

    public static class CompilerInvoker {
        public static CompilerResult compile(String[] args) {
            ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
            ErrorProneCompiler compiler = ErrorProneCompiler.builder().listenToDiagnostics((DiagnosticListener)new MessageListener(messages)).build();
            return new CompilerResult(compiler.run(args).isOK(), messages);
        }

        private static class MessageListener
        implements DiagnosticListener<JavaFileObject> {
            private final List<CompilerMessage> messages;

            MessageListener(List<CompilerMessage> messages) {
                this.messages = messages;
            }

            public static CompilerMessage.Kind convertKind(Diagnostic<? extends JavaFileObject> diagnostic) {
                switch (diagnostic.getKind()) {
                    case ERROR: {
                        return CompilerMessage.Kind.ERROR;
                    }
                    case WARNING: {
                        return CompilerMessage.Kind.WARNING;
                    }
                    case MANDATORY_WARNING: {
                        return CompilerMessage.Kind.MANDATORY_WARNING;
                    }
                    case NOTE: {
                        return CompilerMessage.Kind.NOTE;
                    }
                }
                return CompilerMessage.Kind.OTHER;
            }

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                CompilerMessage compilerMessage = new CompilerMessage(diagnostic.getSource() == null ? null : diagnostic.getSource().getName(), MessageListener.convertKind(diagnostic), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), -1, -1, diagnostic.getMessage(Locale.getDefault()));
                this.messages.add(compilerMessage);
            }
        }
    }

    private static class NonDelegatingClassLoader
    extends URLClassLoader {
        ClassLoader original;

        public NonDelegatingClassLoader(URL[] urls, ClassLoader original) throws MalformedURLException {
            super(urls, (ClassLoader)null);
            this.original = original;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> loadClass(String name, boolean complete) throws ClassNotFoundException {
            if (name.contentEquals(CompilerResult.class.getName()) || name.contentEquals(CompilerMessage.class.getName()) || name.contentEquals(CompilerMessage.Kind.class.getName())) {
                return this.original.loadClass(name);
            }
            try {
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c != null) {
                        return c;
                    }
                    return this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, complete);
            }
        }
    }
}

