/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.PluginReferential;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Sonar;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.Version;

public final class UpdateCenterDeserializer {
    public static final String DATE_SUFFIX = ".date";
    public static final String DESCRIPTION_SUFFIX = ".description";
    public static final String MAVEN_GROUPID_SUFFIX = ".mavenGroupId";
    public static final String MAVEN_ARTIFACTID_SUFFIX = ".mavenArtifactId";
    public static final String CHANGELOG_URL_SUFFIX = ".changelogUrl";
    public static final String DOWNLOAD_URL_SUFFIX = ".downloadUrl";
    public static final String SONAR_PREFIX = "sonar.";
    public static final String DEFAULTS_PREFIX = "defaults";
    public static final String PLUGINS = "plugins";
    private static final String PUBLIC_VERSIONS = "publicVersions";
    private static final String PRIVATE_VERSIONS = "privateVersions";
    private static final String ARCHIVED_VERSIONS = "archivedVersions";
    private static final String DEV_VERSION = "devVersion";
    private Mode mode;
    private boolean ignoreError;

    public UpdateCenterDeserializer(Mode mode, boolean ignoreError) {
        this.mode = mode;
        this.ignoreError = ignoreError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCenter fromManyFiles(File mainFile) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)mainFile);
        try {
            Properties props = new Properties();
            props.load(in);
            this.loadPluginProperties(mainFile, props);
            UpdateCenter pluginReferential = this.fromProperties(props);
            pluginReferential.setDate(new Date(mainFile.lastModified()));
            UpdateCenter updateCenter = pluginReferential;
            return updateCenter;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCenter fromSingleFile(File mainFile) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)mainFile);
        try {
            Properties props = new Properties();
            props.load(in);
            UpdateCenter pluginReferential = this.fromProperties(props);
            pluginReferential.setDate(new Date(mainFile.lastModified()));
            UpdateCenter updateCenter = pluginReferential;
            return updateCenter;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginProperties(File file, Properties props) throws IOException {
        String[] pluginKeys;
        for (String pluginKey : pluginKeys = this.getArray(props, PLUGINS)) {
            File pluginFile = new File(file.getParent(), pluginKey + ".properties");
            FileInputStream pluginFis = FileUtils.openInputStream((File)pluginFile);
            try {
                Properties pluginProps = new Properties();
                pluginProps.load(pluginFis);
                for (Map.Entry<Object, Object> prop : pluginProps.entrySet()) {
                    props.put(pluginKey + "." + prop.getKey(), prop.getValue());
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)pluginFis);
            }
        }
    }

    public UpdateCenter fromProperties(Properties p) {
        Sonar sonar = new Sonar();
        Date date = FormatUtils.toDate(p.getProperty("date"), true);
        ArrayList plugins = Lists.newArrayList();
        this.parseSonar(p, sonar);
        this.parsePlugins(p, sonar, plugins);
        this.validatePublicPluginSQVersionOverlap(plugins);
        PluginReferential pluginReferential = PluginReferential.create(plugins);
        for (Plugin plugin : pluginReferential.getPlugins()) {
            for (Release release : plugin.getAllReleases()) {
                String[] requiredReleases;
                String parentKey = this.get(p, plugin.getKey(), release.getVersion().getName() + ".parent", false);
                if (parentKey != null) {
                    pluginReferential.setParent(release, parentKey);
                }
                for (String requiresPluginKey : requiredReleases = StringUtils.split((String)StringUtils.defaultIfEmpty((String)this.get(p, plugin.getKey(), release.getVersion().getName() + ".requirePlugins", false), (String)""), (String)",")) {
                    Iterator split = Splitter.on((char)':').split((CharSequence)requiresPluginKey).iterator();
                    String requiredPluginReleaseKey = (String)split.next();
                    String requiredMinimumReleaseVersion = (String)split.next();
                    pluginReferential.addOutgoingDependency(release, requiredPluginReleaseKey, requiredMinimumReleaseVersion);
                }
            }
        }
        return UpdateCenter.create(pluginReferential, sonar).setDate(date);
    }

    private void reportError(String message) {
        if (!this.ignoreError) {
            throw new IllegalStateException(message);
        }
        System.err.println(message);
    }

    private void validatePublicPluginSQVersionOverlap(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.validatePublicPluginSQVersionOverlap(plugin);
        }
    }

    private void validatePublicPluginSQVersionOverlap(Plugin plugin) {
        HashMap<Version, Release> sonarVersion = new HashMap<Version, Release>();
        for (Release r : plugin.getPublicReleases()) {
            for (Version v : r.getRequiredSonarVersions()) {
                if (sonarVersion.containsKey(v)) {
                    this.reportError("SQ version " + v + " is declared compatible with two public versions of " + this.pluginName(plugin) + " plugin: " + r.getVersion() + " and " + ((Release)sonarVersion.get(v)).getVersion());
                }
                sonarVersion.put(v, r);
            }
        }
    }

    private String pluginName(Plugin plugin) {
        return StringUtils.isNotBlank((String)plugin.getName()) ? plugin.getName() : plugin.getKey();
    }

    private void parsePlugins(Properties p, Sonar sonar, List<Plugin> plugins) {
        String[] pluginKeys;
        for (String pluginKey : pluginKeys = this.getArray(p, PLUGINS)) {
            Plugin plugin = new Plugin(pluginKey);
            plugin.setName(this.get(p, pluginKey, "name", false));
            plugin.setDescription(this.get(p, pluginKey, "description", false));
            plugin.setCategory(this.get(p, pluginKey, "category", true));
            plugin.setHomepageUrl(this.get(p, pluginKey, "homepageUrl", false));
            plugin.setLicense(this.get(p, pluginKey, "license", false));
            plugin.setOrganization(this.get(p, pluginKey, "organization", false));
            plugin.setOrganizationUrl(this.get(p, pluginKey, "organizationUrl", false));
            plugin.setTermsConditionsUrl(this.get(p, pluginKey, "termsConditionsUrl", false));
            plugin.setIssueTrackerUrl(this.get(p, pluginKey, "issueTrackerUrl", false));
            plugin.setSourcesUrl(this.get(p, pluginKey, "scm", false));
            plugin.setDevelopers(Lists.newArrayList((Object[])this.getArray(p, pluginKey, "developers")));
            this.parsePluginReleases(p, sonar, pluginKey, plugin, PUBLIC_VERSIONS, true, false);
            if (this.mode == Mode.DEV) {
                this.parsePluginReleases(p, sonar, pluginKey, plugin, PRIVATE_VERSIONS, false, false);
                this.parsePluginDevVersions(p, sonar, pluginKey, plugin);
            }
            this.parsePluginReleases(p, sonar, pluginKey, plugin, ARCHIVED_VERSIONS, false, true);
            if (plugin.getAllReleases().isEmpty()) continue;
            plugins.add(plugin);
        }
    }

    private void parsePluginReleases(Properties p, Sonar sonar, String pluginKey, Plugin plugin, String key, boolean isPublicRelease, boolean isArchivedRelease) {
        String[] pluginPublicReleases;
        for (String pluginVersion : pluginPublicReleases = this.getArray(p, pluginKey, key)) {
            Release release = this.parsePlugin(p, sonar, pluginKey, plugin, isPublicRelease, isArchivedRelease, pluginVersion);
            if (!plugin.getAllReleases().contains(release)) {
                plugin.addRelease(release);
                continue;
            }
            this.reportError("Duplicate version for plugin " + pluginKey + ": " + pluginVersion);
        }
    }

    private Release parsePlugin(Properties p, Sonar sonar, String pluginKey, Plugin plugin, boolean isPublicRelease, boolean isArchivedRelease, String pluginVersion) {
        Release release = new Release((Artifact)plugin, pluginVersion);
        release.setPublic(isPublicRelease);
        release.setArchived(isArchivedRelease);
        release.setDownloadUrl(this.getOrDefault(p, pluginKey, pluginVersion, DOWNLOAD_URL_SUFFIX, isPublicRelease));
        release.setChangelogUrl(this.getOrDefault(p, pluginKey, pluginVersion, CHANGELOG_URL_SUFFIX, false));
        release.setDate(FormatUtils.toDate(this.getOrDefault(p, pluginKey, pluginVersion, DATE_SUFFIX, isPublicRelease), false));
        release.setDescription(this.getOrDefault(p, pluginKey, pluginVersion, DESCRIPTION_SUFFIX, isPublicRelease));
        release.setGroupId(this.getOrDefault(p, pluginKey, pluginVersion, MAVEN_GROUPID_SUFFIX, true));
        release.setArtifactId(this.getOrDefault(p, pluginKey, pluginVersion, MAVEN_ARTIFACTID_SUFFIX, true));
        String[] requiredSonarVersions = this.getRequiredSonarVersions(p, pluginKey, pluginVersion, sonar, isArchivedRelease);
        if (!isArchivedRelease && requiredSonarVersions.length == 0) {
            this.reportError("Plugin " + this.pluginName(plugin) + " version " + pluginVersion + " should declare compatible SQ versions");
        }
        for (String requiredSonarVersion : requiredSonarVersions) {
            release.addRequiredSonarVersions(Version.create(requiredSonarVersion));
        }
        return release;
    }

    private void parsePluginDevVersions(Properties p, Sonar sonar, String pluginKey, Plugin plugin) {
        String devVersion = this.get(p, pluginKey, DEV_VERSION, false);
        if (StringUtils.isNotBlank((String)devVersion)) {
            Release release = this.parsePlugin(p, sonar, pluginKey, plugin, false, false, devVersion);
            plugin.setDevRelease(release);
        }
    }

    private void parseSonar(Properties p, Sonar sonar) {
        this.parseSonarVersions(p, sonar);
        if (this.mode == Mode.DEV) {
            this.parseSonarDevVersions(p, sonar);
        }
        this.parseSonarLtsVersion(p, sonar);
    }

    private void parseSonarDevVersions(Properties p, Sonar sonar) {
        String devVersion = this.get(p, DEV_VERSION, true);
        Release release = this.parseSonarVersion(p, sonar, false, devVersion);
        sonar.setDevRelease(release);
    }

    private void parseSonarLtsVersion(Properties p, Sonar sonar) {
        String ltsVersion = this.get(p, "ltsVersion", true);
        sonar.setLtsRelease(ltsVersion);
        if (!sonar.getReleases().contains(sonar.getLtsRelease())) {
            this.reportError("ltsVersion seems wrong as it is not listed in SonarQube versions");
        }
    }

    private void parseSonarVersions(Properties p, Sonar sonar) {
        this.parseSonarVersions(p, sonar, PUBLIC_VERSIONS, true);
        if (this.mode == Mode.DEV) {
            this.parseSonarVersions(p, sonar, PRIVATE_VERSIONS, false);
        }
    }

    private void parseSonarVersions(Properties p, Sonar sonar, String key, boolean isPublicRelease) {
        for (String sonarVersion : this.getArray(p, key)) {
            Release release = this.parseSonarVersion(p, sonar, isPublicRelease, sonarVersion);
            if (!sonar.getAllReleases().contains(release)) {
                sonar.addRelease(release);
                continue;
            }
            this.reportError("Duplicate version for SonarQube: " + sonarVersion);
        }
    }

    private Release parseSonarVersion(Properties p, Sonar sonar, boolean isPublicRelease, String sonarVersion) {
        Release release = new Release((Artifact)sonar, sonarVersion);
        release.setPublic(isPublicRelease);
        release.setChangelogUrl(this.getOrDefault(p, sonarVersion, CHANGELOG_URL_SUFFIX, isPublicRelease));
        release.setDescription(this.getOrDefault(p, sonarVersion, DESCRIPTION_SUFFIX, isPublicRelease));
        release.setDownloadUrl(this.getOrDefault(p, sonarVersion, DOWNLOAD_URL_SUFFIX, isPublicRelease));
        release.setDate(FormatUtils.toDate(this.getOrDefault(p, sonarVersion, DATE_SUFFIX, isPublicRelease), false));
        return release;
    }

    private String[] getRequiredSonarVersions(Properties p, String pluginKey, String pluginVersion, Sonar sonar, boolean isArchived) {
        String sqVersions = this.get(p, pluginKey, pluginVersion + ".sqVersions", !isArchived);
        List<String> patterns = this.split(StringUtils.defaultIfEmpty((String)sqVersions, (String)""));
        LinkedList<String> result = new LinkedList<String>();
        for (String pattern : patterns) {
            if (pattern == null) continue;
            Matcher matcher = Pattern.compile("\\[(.*),(.*)\\]").matcher(pattern);
            if (matcher.matches()) {
                Version low = Version.create(this.resolve(matcher.group(1), sonar));
                Version high = Version.create(this.resolve(matcher.group(2), sonar));
                this.resolveRangeOfRequiredSQVersion(sonar, result, low, high);
                continue;
            }
            result.add(this.resolve(pattern, sonar));
        }
        return result.toArray(new String[result.size()]);
    }

    private void resolveRangeOfRequiredSQVersion(Sonar sonar, List<String> result, final Version low, final Version high) {
        Collection versions = Collections2.filter((Collection)Collections2.transform(sonar.getAllReleases(), (Function)new Function<Release, Version>(){

            public Version apply(Release release) {
                return release != null ? release.getVersion() : null;
            }
        }), (Predicate)new Predicate<Version>(){

            public boolean apply(Version version) {
                return version != null && version.compareTo(low) >= 0 && version.compareTo(high) <= 0;
            }
        });
        for (Version version : versions) {
            result.add(version.toString());
        }
    }

    private List<String> split(String requiredSonarVersions) {
        ArrayList<String> splitted = new ArrayList<String>();
        int skipCommas = 0;
        String s = "";
        for (char c : requiredSonarVersions.toCharArray()) {
            if (c == ',' && skipCommas == 0) {
                splitted.add(s);
                s = "";
                continue;
            }
            if (c == '[') {
                ++skipCommas;
            }
            if (c == ']') {
                --skipCommas;
            }
            s = s + c;
        }
        if (StringUtils.isNotBlank((String)s)) {
            splitted.add(s);
        }
        return splitted;
    }

    private String resolve(String version, Sonar sonar) {
        if ("LATEST".equals(version)) {
            return sonar.getAllReleases().last().getVersion().toString();
        }
        if (version.endsWith("*")) {
            return this.resolveWithWildcard(version, sonar);
        }
        return version;
    }

    private String resolveWithWildcard(String version, Sonar sonar) {
        String prefix = version.substring(0, version.length() - 1);
        String prefixWithoutDot = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        Release found = null;
        for (Release r : sonar.getAllReleases()) {
            if (!r.getVersion().toString().equals(prefixWithoutDot) && !r.getVersion().toString().startsWith(prefix)) continue;
            found = r;
        }
        if (found != null) {
            return found.getVersion().toString();
        }
        throw new IllegalStateException("Unable to resolve " + version);
    }

    private String getOrDefault(Properties props, String sqVersion, String suffix, boolean required) {
        String defaultKey;
        String key = sqVersion + suffix;
        String value = this.getOrDefault(props, key, defaultKey = DEFAULTS_PREFIX + suffix);
        if (StringUtils.isBlank((String)value) && required) {
            this.reportUndefined(key);
        }
        return value;
    }

    private void reportUndefined(String key) {
        this.reportError(key + " should be defined");
    }

    private String get(Properties props, String key, boolean required) {
        String value = this.get(props, key);
        if (StringUtils.isBlank((String)value) && required) {
            this.reportUndefined(key);
        }
        return value;
    }

    private String get(Properties props, String key) {
        return StringUtils.defaultIfEmpty((String)props.getProperty(key), null);
    }

    private String getOrDefault(Properties props, String key, String defaultKey) {
        if (props.containsKey(key)) {
            return props.getProperty(key);
        }
        return StringUtils.defaultIfEmpty((String)props.getProperty(defaultKey), null);
    }

    private String getOrDefault(Properties props, String pluginKey, String version, String suffix, boolean required) {
        String defaultKey;
        String key = pluginKey + "." + version + suffix;
        String value = this.getOrDefault(props, key, defaultKey = pluginKey + "." + DEFAULTS_PREFIX + suffix);
        if (StringUtils.isBlank((String)value) && required) {
            this.reportUndefined(key);
        }
        return value;
    }

    private String get(Properties p, String pluginKey, String field, boolean required) {
        String key = pluginKey + "." + field;
        String value = this.get(p, key);
        if (StringUtils.isBlank((String)value) && required) {
            this.reportUndefined(key);
        }
        return value;
    }

    private String[] getArray(Properties props, String key) {
        return StringUtils.split((String)StringUtils.defaultIfEmpty((String)props.getProperty(key), (String)""), (String)",");
    }

    private String[] getArray(Properties p, String pluginKey, String field) {
        return this.getArray(p, pluginKey + "." + field);
    }

    public static enum Mode {
        PROD,
        DEV;

    }
}

