/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.deps.Dependency;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;

public class ZstdPayloadCoding
implements PayloadCodingProvider {
    protected ZstdPayloadCoding() {
    }

    @Override
    public String getCoding() {
        return "zstd";
    }

    @Override
    public void fillRequirements(Consumer<Dependency> requirementsConsumer) {
        requirementsConsumer.accept(new Dependency("PayloadIsZstd", "5.4.18-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        if (!ZstdUtils.isZstdCompressionAvailable()) {
            throw new IOException("Zstandard compression is not available");
        }
        return new ZstdCompressorInputStream(in);
    }

    @Override
    public OutputStream createOutputStream(OutputStream out, Optional<String> optionalFlags) throws IOException {
        String flags;
        if (!ZstdUtils.isZstdCompressionAvailable()) {
            throw new IOException("Zstandard compression is not available");
        }
        int level = optionalFlags.isPresent() && (flags = optionalFlags.get()).length() > 0 ? Integer.parseInt(flags.substring(0, 1)) : 3;
        return new ZstdCompressorOutputStream(out, level);
    }
}

