/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.LocalNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    static final String className = MqttAsyncClient.class.getName();
    public Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", className);

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        String methodName = "MqttAsyncClient";
        this.log.setResourceName(clientId);
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("Null or zero length clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 23) {
            throw new IllegalArgumentException("ClientId longer than 23 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.log.fine(className, "MqttAsyncClient", "101", new Object[]{clientId, serverURI, persistence});
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        char MIN_HIGH_SURROGATE = '\ud800';
        char MAX_HIGH_SURROGATE = '\udbff';
        return ch >= MIN_HIGH_SURROGATE && ch <= MAX_HIGH_SURROGATE;
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        String methodName = "createNetworkModules";
        this.log.fine(className, "createNetworkModules", "116", new Object[]{address});
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        for (int i = 0; i < array.length; ++i) {
            networkModules[i] = this.createNetworkModule(array[i], options);
        }
        this.log.fine(className, "createNetworkModules", "108");
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        NetworkModule netModule;
        String methodName = "createNetworkModule";
        this.log.fine(className, "createNetworkModule", "115", new Object[]{address});
        SocketFactory factory = options.getSocketFactory();
        int serverURIType = MqttConnectOptions.validateURI(address);
        switch (serverURIType) {
            case 0: {
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 1883);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId);
                ((TCPNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 8883);
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 2: {
                netModule = new LocalNetworkModule(address.substring(8));
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private int getPort(String uri, int defaultPort) {
        int portIndex = uri.lastIndexOf(58);
        int port = portIndex == -1 ? defaultPort : Integer.valueOf(uri.substring(portIndex + 1));
        return port;
    }

    private String getHostName(String uri) {
        int schemeIndex = uri.lastIndexOf(47);
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(schemeIndex + 1, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        String methodName = "connect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.log.fine(className, "connect", "103", new Object[]{new Boolean(options.isCleanSession()), new Integer(options.getConnectionTimeout()), new Integer(options.getKeepAliveInterval()), options.getUserName(), null == options.getPassword() ? "[null]" : "[notnull]", null == options.getWillMessage() ? "[null]" : "[notnull]", userContext, callback});
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "disconnect";
        this.log.fine(className, "disconnect", "104", new Object[]{new Long(quiesceTimeout), userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
        }
        catch (MqttException ex) {
            this.log.fine(className, "disconnect", "105", null, ex);
            throw ex;
        }
        this.log.fine(className, "disconnect", "108");
        return token;
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    protected MqttTopic getTopic(String topic) {
        MqttAsyncClient.validateTopic(topic);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "subscribe";
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i] + ":" + qos[i];
        }
        this.log.fine(className, "subscribe", "106", new Object[]{subs, userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        this.log.fine(className, "subscribe", "109");
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "unsubscribe";
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i];
        }
        this.log.fine(className, "unsubscribe", "107", new Object[]{subs, userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        this.log.fine(className, "unsubscribe", "110");
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.comms.setCallback(callback);
    }

    public static String generateClientId() {
        return System.getProperty("user.name") + "." + System.currentTimeMillis();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        String methodName = "publish";
        this.log.fine(className, "publish", "111", new Object[]{topic, userContext, callback});
        MqttAsyncClient.validateTopic(topic);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        this.log.fine(className, "publish", "112");
        return token;
    }

    @Override
    public void close() throws MqttException {
        String methodName = "close";
        this.log.fine(className, "close", "113");
        this.comms.close();
        this.log.fine(className, "close", "114");
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    public static void validateTopic(String topic) {
        if (topic.indexOf(35) == -1 && topic.indexOf(43) == -1) {
            return;
        }
        throw new IllegalArgumentException();
    }
}

