/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.p2.repository.DefaultTychoRepositoryIndex;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedTychoRepositoryIndex
extends DefaultTychoRepositoryIndex {
    private final File storageFile;
    public static final String ARTIFACTS_INDEX_RELPATH = ".meta/p2-artifacts.properties";
    public static final String METADATA_INDEX_RELPATH = ".meta/p2-local-metadata.properties";

    private FileBasedTychoRepositoryIndex(File indexFile, Set<GAV> content) {
        super(content);
        this.storageFile = indexFile;
    }

    @Override
    public void save() throws IOException {
        this.storageFile.getParentFile().mkdirs();
        DefaultTychoRepositoryIndex.write(this, new FileOutputStream(this.storageFile));
    }

    public static TychoRepositoryIndex createRepositoryIndex(File basedir, String relpath) {
        File inputFile = new File(basedir, relpath);
        Set<GAV> content = new LinkedHashSet<GAV>();
        if (inputFile.exists()) {
            try {
                content = DefaultTychoRepositoryIndex.read(new FileInputStream(inputFile));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load index file " + inputFile, e);
            }
        }
        return new FileBasedTychoRepositoryIndex(inputFile, content);
    }

    public static void addProject(File basedir, String groupId, String artifactId, String version) throws IOException {
        TychoRepositoryIndex artifactsIndex = FileBasedTychoRepositoryIndex.createRepositoryIndex(basedir, ARTIFACTS_INDEX_RELPATH);
        artifactsIndex.addProject(new GAV(groupId, artifactId, version));
        artifactsIndex.save();
        TychoRepositoryIndex metadataIndex = FileBasedTychoRepositoryIndex.createRepositoryIndex(basedir, METADATA_INDEX_RELPATH);
        metadataIndex.addProject(new GAV(groupId, artifactId, version));
        metadataIndex.save();
    }
}

