/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class RestClientBuilder {
    private static final Log LOG = LogFactory.getLog(RestClientBuilder.class);
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_RETRY_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT_MILLIS = 500;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 100;
    public static final int DEFAULT_MAX_CONN_TOTAL = 1000;
    public static final int RETRY_TIMES = 3;
    public static final double EXPIRE_LEFT_PERCENT = 0.25;
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private static boolean esSecConfig = true;
    private static boolean systemSecConfig = System.getProperty("java.security.krb5.conf") != null;
    private boolean isSecureMode = true;
    private static final String AUTH_USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_V5_PRINCIPAL_NAME = "1.2.840.113554.1.2.2.1";
    private static String SCHEME_HTTPS = "https://";
    private static final String ELASTICSEARCH_SERVERREALM_PATH = System.getProperty("elasticsearch.server.realm.path", "/elasticsearch/serverrealm");
    private int maxRetryTimeout = 30000;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private RestClient.FailureListener failureListener;
    private HttpClientConfigCallback httpClientConfigCallback;
    private RequestConfigCallback requestConfigCallback;
    private int maxConnPerRoute = 1;
    private int maxConnTotal = 1;
    private String pathPrefix;
    private static Subject subj = null;
    private String serverRealm = null;
    private HttpHost[] hosts;
    private static final Lookup<AuthSchemeProvider> AUTH_SCHEME_REGISTRY = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
    private static final BasicCredentialsProvider CREDENTIALS_PROVIDER;
    private static final SSLContext SSL_CONTEXT;
    private static final HostnameVerifier HOSTNAME_VERIFIER;

    private static void refreshSecureMode() {
        esSecConfig = !"false".equals(System.getProperty("es.security.indication"));
        systemSecConfig = System.getProperty("java.security.krb5.conf") != null;
        LOG.info((Object)("esSecConfig is " + esSecConfig));
        LOG.info((Object)("systemSecConfig is " + systemSecConfig));
    }

    RestClientBuilder(HttpHost ... hosts) {
        Objects.requireNonNull(hosts, "hosts must not be null");
        if (hosts.length == 0) {
            throw new IllegalArgumentException("no hosts provided");
        }
        for (HttpHost host : hosts) {
            Objects.requireNonNull(host, "host cannot be null");
        }
        this.hosts = this.shuffle(hosts);
        if (this.hosts.length > 0) {
            SCHEME_HTTPS = this.hosts[0].getSchemeName() + "://";
        }
        RestClientBuilder.refreshSecureMode();
        this.isSecureMode = esSecConfig && systemSecConfig;
        LOG.info((Object)("isSecureMode is " + this.isSecureMode));
        if (this.isSecureMode) {
            System.setProperty(AUTH_USE_SUBJECT_CREDS_ONLY, System.getProperty(AUTH_USE_SUBJECT_CREDS_ONLY, "false"));
        }
    }

    public HttpHost[] getHosts() {
        return this.hosts;
    }

    public boolean isSecureMode() {
        return this.isSecureMode;
    }

    public String getServerRealm() {
        return this.serverRealm;
    }

    public static Subject getSubj() {
        return subj;
    }

    public RestClientBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public RestClientBuilder setMaxConnTotal(int maxConnTotal) {
        if (maxConnTotal <= 0) {
            throw new IllegalArgumentException("maxConnPerToTal must be greater than 0");
        }
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public RestClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        if (maxConnPerRoute <= 0) {
            throw new IllegalArgumentException("maxConnPerRoute must be greater than 0");
        }
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public RestClientBuilder setFailureListener(RestClient.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public RestClientBuilder setMaxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
        if (maxRetryTimeoutMillis <= 0) {
            throw new IllegalArgumentException("maxRetryTimeoutMillis must be greater than 0");
        }
        this.maxRetryTimeout = maxRetryTimeoutMillis;
        return this;
    }

    public RestClientBuilder setHttpClientConfigCallback(HttpClientConfigCallback httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public RestClientBuilder setRequestConfigCallback(RequestConfigCallback requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public RestClientBuilder setPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        String cleanPathPrefix = pathPrefix;
        if (!cleanPathPrefix.startsWith("/")) {
            cleanPathPrefix = "/" + cleanPathPrefix;
        }
        if (cleanPathPrefix.endsWith("/") && (cleanPathPrefix = cleanPathPrefix.substring(0, cleanPathPrefix.length() - 1)).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        if (cleanPathPrefix.isEmpty() || "/".equals(cleanPathPrefix)) {
            throw new IllegalArgumentException("pathPrefix must not be empty or '/': [" + pathPrefix + "]");
        }
        this.pathPrefix = cleanPathPrefix;
        return this;
    }

    public RestClient build() {
        RestClientBuilder.refreshSecureMode();
        if (this.failureListener == null) {
            this.failureListener = new RestClient.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(new PrivilegedAction<CloseableHttpAsyncClient>(){

            @Override
            public CloseableHttpAsyncClient run() {
                return RestClientBuilder.this.createHttpClient();
            }
        });
        RestClient restClient = new RestClient(this, httpClient, this.maxRetryTimeout, this.defaultHeaders, this.hosts, this.pathPrefix, this.failureListener);
        try {
            httpClient.start();
            if (this.isSecureMode) {
                this.authenticate(restClient);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Authenticate restClient failed.", (Throwable)e);
            if (restClient != null) {
                try {
                    restClient.close();
                }
                catch (IOException e1) {
                    LOG.error((Object)"Close restClient failed while authenticate restClient.", (Throwable)e1);
                }
            }
            throw new RuntimeException(e);
        }
        return restClient;
    }

    public HttpHost[] shuffle(HttpHost[] hosts) {
        if (hosts == null || hosts.length == 0) {
            return null;
        }
        int hostsIndex = 0;
        for (int i = 0; i < hosts.length / 2; ++i) {
            hostsIndex = ThreadLocalRandom.current().nextInt(hosts.length);
            HttpHost tmp = hosts[i];
            hosts[i] = hosts[hostsIndex];
            hosts[hostsIndex] = tmp;
        }
        return hosts;
    }

    public static synchronized void getTGT() {
        try {
            String jaasAppName1 = System.getProperty("elasticsearch.kerberos.jaas.appname", "Client");
            String jaasAppName2 = System.getProperty("elasticsearch.kerberos.jaas.appname", "EsClient");
            AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(jaasAppName1);
            if (null == entries || entries.length <= 0) {
                entries = Configuration.getConfiguration().getAppConfigurationEntry(jaasAppName2);
            }
            if (null == entries || entries.length <= 0) {
                LOG.error((Object)"Please generate EsClient loginContext in jaas.conf file for ES to get TGT.");
                throw new IllegalArgumentException(String.valueOf("EsClient loginContext is not configured properly in jaas.conf file,please set the correct content."));
            }
            HashMap options = new HashMap();
            for (AppConfigurationEntry entry : entries) {
                options.putAll(entry.getOptions());
            }
            subj = new Subject();
            Krb5LoginModule krb5 = new Krb5LoginModule();
            krb5.initialize(subj, null, null, options);
            krb5.login();
            krb5.commit();
            LOG.info((Object)"Get kerberos TGT successfully.");
        }
        catch (LoginException e) {
            LOG.error((Object)"Get kerberos TGT failed.");
            throw new RuntimeException(e);
        }
    }

    private static long getTgtValidityPeriod(KerberosTicket kerberosTicket) {
        Date endTime = kerberosTicket.getEndTime();
        Date startTime = kerberosTicket.getStartTime();
        if (null == endTime || null == startTime) {
            return -1L;
        }
        return endTime.getTime() - startTime.getTime();
    }

    private static synchronized KerberosTicket getKerberosTicket(Subject subject) {
        KerberosTicket kerberosTicket = null;
        if (null == subject) {
            LOG.debug((Object)"The subject is invalid.");
            return null;
        }
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        if (null == privateCredentials) {
            LOG.debug((Object)"The privateCredentials is null.");
            return null;
        }
        for (Object privateCredential : privateCredentials) {
            if (!(privateCredential instanceof KerberosTicket)) continue;
            kerberosTicket = (KerberosTicket)privateCredential;
            return kerberosTicket;
        }
        return kerberosTicket;
    }

    public static synchronized boolean subjectWillExpire(Subject subject) {
        boolean willExpired;
        if (null == subject || null == subject.getPrincipals() || null == subject.getPrivateCredentials()) {
            LOG.debug((Object)"The subject is invalid.");
            return true;
        }
        KerberosTicket kerberosTicket = RestClientBuilder.getKerberosTicket(subject);
        if (null == kerberosTicket) {
            LOG.debug((Object)"The kerberosTicket is null.");
            return true;
        }
        long tgtWillExpireTime = null == kerberosTicket.getEndTime() ? -1L : kerberosTicket.getEndTime().getTime();
        long tgtValidityPeriod = RestClientBuilder.getTgtValidityPeriod(kerberosTicket);
        if (tgtWillExpireTime <= 0L || tgtWillExpireTime < System.currentTimeMillis() || tgtValidityPeriod <= 0L) {
            LOG.debug((Object)"TgtWillExpireTime is invalid.");
            return true;
        }
        boolean bl = willExpired = (double)(tgtWillExpireTime - System.currentTimeMillis()) < (double)tgtValidityPeriod * 0.25;
        if (willExpired) {
            LOG.debug((Object)"TGT will expire!");
        }
        return willExpired;
    }

    private synchronized void authenticate(RestClient restClient) throws Exception {
        for (int times = 0; RestClientBuilder.subjectWillExpire(subj) && times < 3; ++times) {
            LOG.debug((Object)"Subject is not ok ,retry get new TGT.");
            RestClientBuilder.getTGT();
        }
        int index = 0;
        for (int times1 = 0; null == this.serverRealm && times1 < 3; ++times1) {
            this.serverRealm = this.getServerRealm(this.hosts[index].toHostString());
            index = index < this.hosts.length - 1 ? ++index : 0;
        }
        if (null == this.serverRealm) {
            throw new IllegalArgumentException("Get ServerRealm failed.");
        }
        restClient.setServerRealm(this.serverRealm);
        LOG.info((Object)"Initialize the client successfully.");
    }

    public static synchronized byte[] initiateSecurityContext(Subject subject, final String servicePrincipalName) {
        byte[] token = Subject.doAs(subject, new PrivilegedAction<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] run() {
                GSSContext context = null;
                try {
                    context = RestClientBuilder.getGssContext(servicePrincipalName);
                    context.requestMutualAuth(true);
                    context.requestCredDeleg(true);
                    byte[] tokenNew = new byte[]{};
                    byte[] byArray = context.initSecContext(tokenNew, 0, tokenNew.length);
                    return byArray;
                }
                catch (GSSException e) {
                    LOG.error((Object)"Init secure context failed.", (Throwable)e);
                    byte[] byArray = null;
                    return byArray;
                }
                finally {
                    if (context != null) {
                        try {
                            context.dispose();
                        }
                        catch (GSSException e2) {
                            LOG.error((Object)"Dispose secure context failed.", (Throwable)e2);
                        }
                    }
                }
            }
        });
        return token;
    }

    private static GSSContext getGssContext(String servicePrincipalName) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(servicePrincipalName, new Oid(KERBEROS_V5_PRINCIPAL_NAME));
        Oid oid = new Oid(SPNEGO_OID);
        GSSContext context = manager.createContext(serverName.canonicalize(oid), oid, null, 0);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServerRealm(String hostAndPort) {
        String serverRealm = null;
        InputStream is = null;
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setSSLHostnameVerifier(HOSTNAME_VERIFIER);
            builder.setSSLContext(SSL_CONTEXT);
            CloseableHttpClient client = builder.build();
            HttpGet httpGet = new HttpGet(SCHEME_HTTPS + hostAndPort + ELASTICSEARCH_SERVERREALM_PATH);
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (200 == httpStatus) {
                is = response.getEntity().getContent();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[64];
                int size = -1;
                while (-1 != (size = is.read(buffer))) {
                    os.write(buffer, 0, size);
                }
                serverRealm = os.toString(StandardCharsets.UTF_8.displayName());
                LOG.info((Object)("Success to get the service realm " + serverRealm));
            } else {
                LOG.error((Object)("Cannot get server realm at  " + hostAndPort));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Get server realm failed.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Close http response input stream failed.", (Throwable)e);
                }
            }
        }
        return serverRealm;
    }

    private CloseableHttpAsyncClient createHttpClient() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(1000).setSocketTimeout(30000).setConnectionRequestTimeout(500);
        if (this.requestConfigCallback != null) {
            requestConfigBuilder = this.requestConfigCallback.customizeRequestConfig(requestConfigBuilder);
        }
        try {
            int maxConnPerRouteNow = 0;
            maxConnPerRouteNow = this.maxConnPerRoute > 1 ? this.maxConnPerRoute : 100;
            int maxConnTotalNow = this.maxConnTotal > 1 ? this.maxConnTotal : 1000;
            LOG.debug((Object)("maxConnPerRouteNow is " + maxConnPerRouteNow));
            LOG.debug((Object)("maxConnTotalNow is " + maxConnTotalNow));
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setMaxConnPerRoute(maxConnPerRouteNow).setMaxConnTotal(maxConnTotalNow).setSSLContext(SSLContext.getDefault());
            if (this.httpClientConfigCallback != null) {
                httpClientBuilder = this.httpClientConfigCallback.customizeHttpClient(httpClientBuilder);
            }
            if (this.isSecureMode) {
                this.wrapSecureHttpAsyncClientBuilder(httpClientBuilder);
            }
            final HttpAsyncClientBuilder finalBuilder = httpClientBuilder;
            return AccessController.doPrivileged(new PrivilegedAction<CloseableHttpAsyncClient>(){

                @Override
                public CloseableHttpAsyncClient run() {
                    return finalBuilder.build();
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not create the default ssl context", e);
        }
    }

    private void wrapSecureHttpAsyncClientBuilder(HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setSSLContext(SSL_CONTEXT);
        httpClientBuilder.setDefaultAuthSchemeRegistry(AUTH_SCHEME_REGISTRY);
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)CREDENTIALS_PROVIDER);
        httpClientBuilder.setSSLHostnameVerifier(HOSTNAME_VERIFIER);
    }

    static {
        HOSTNAME_VERIFIER = new NoopHostnameVerifier();
        CREDENTIALS_PROVIDER = new BasicCredentialsProvider();
        CREDENTIALS_PROVIDER.setCredentials(AuthScope.ANY, new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        try {
            SSL_CONTEXT = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOG.error((Object)"Init ssl context failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
        RestClientBuilder.refreshSecureMode();
    }

    public static interface HttpClientConfigCallback {
        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder var1);
    }

    public static interface RequestConfigCallback {
        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder var1);
    }
}

