/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpPipelinedMessage;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.nio.ByteBufUtils;
import org.elasticsearch.http.nio.NioHttpRequest;
import org.elasticsearch.rest.RestStatus;

public class NioHttpResponse
extends DefaultFullHttpResponse
implements HttpResponse,
HttpPipelinedMessage {
    private final int sequence;
    private final NioHttpRequest request;

    NioHttpResponse(NioHttpRequest request, RestStatus status, BytesReference content) {
        super(request.nettyRequest().protocolVersion(), HttpResponseStatus.valueOf((int)status.getStatus()), ByteBufUtils.toByteBuf(content));
        this.sequence = request.sequence();
        this.request = request;
    }

    public void addHeader(String name, String value) {
        this.headers().add(name, (Object)value);
    }

    public boolean containsHeader(String name) {
        return this.headers().contains(name);
    }

    public int getSequence() {
        return this.sequence;
    }

    public NioHttpRequest getRequest() {
        return this.request;
    }
}

