/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio.cors;

import io.netty.handler.codec.http.HttpMethod;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.elasticsearch.http.nio.cors.NioCorsConfig;

public final class NioCorsConfigBuilder {
    Optional<Set<String>> origins;
    Optional<Pattern> pattern;
    final boolean anyOrigin;
    boolean enabled = true;
    boolean allowCredentials;
    long maxAge;
    final Set<HttpMethod> requestMethods = new HashSet<HttpMethod>();
    final Set<String> requestHeaders = new HashSet<String>();
    final Map<CharSequence, Callable<?>> preflightHeaders = new HashMap();
    boolean shortCircuit;

    public static NioCorsConfigBuilder forAnyOrigin() {
        return new NioCorsConfigBuilder();
    }

    public static NioCorsConfigBuilder forPattern(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("CORS pattern cannot be null");
        }
        return new NioCorsConfigBuilder(pattern);
    }

    public static NioCorsConfigBuilder forOrigins(String ... origins) {
        return new NioCorsConfigBuilder(origins);
    }

    NioCorsConfigBuilder(String ... origins) {
        this.origins = Optional.of(new LinkedHashSet<String>(Arrays.asList(origins)));
        this.pattern = Optional.empty();
        this.anyOrigin = false;
    }

    NioCorsConfigBuilder() {
        this.anyOrigin = true;
        this.origins = Optional.empty();
        this.pattern = Optional.empty();
    }

    NioCorsConfigBuilder(Pattern pattern) {
        this.pattern = Optional.of(pattern);
        this.origins = Optional.empty();
        this.anyOrigin = false;
    }

    public NioCorsConfigBuilder disable() {
        this.enabled = false;
        return this;
    }

    public NioCorsConfigBuilder allowCredentials() {
        this.allowCredentials = true;
        return this;
    }

    public NioCorsConfigBuilder maxAge(long max) {
        this.maxAge = max;
        return this;
    }

    public NioCorsConfigBuilder allowedRequestMethods(HttpMethod ... methods) {
        this.requestMethods.addAll(Arrays.asList(methods));
        return this;
    }

    public NioCorsConfigBuilder allowedRequestHeaders(String ... headers) {
        this.requestHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    public NioCorsConfigBuilder shortCircuit() {
        this.shortCircuit = true;
        return this;
    }

    public NioCorsConfig build() {
        if (this.preflightHeaders.isEmpty()) {
            this.preflightHeaders.put("date", DateValueGenerator.INSTANCE);
            this.preflightHeaders.put("content-length", new ConstantValueGenerator("0"));
        }
        return new NioCorsConfig(this);
    }

    private static final class DateValueGenerator
    implements Callable<Date> {
        static final DateValueGenerator INSTANCE = new DateValueGenerator();

        private DateValueGenerator() {
        }

        @Override
        public Date call() throws Exception {
            return new Date();
        }
    }

    private static final class ConstantValueGenerator
    implements Callable<Object> {
        private final Object value;

        private ConstantValueGenerator(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        @Override
        public Object call() {
            return this.value;
        }
    }
}

