/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.MessageEventDefinition;

public class MessageEventDefinitionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "messageEventDefinition";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Event)) {
            return;
        }
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        BpmnXMLUtil.addXMLLocation((BaseElement)eventDefinition, xtr);
        eventDefinition.setMessageRef(xtr.getAttributeValue(null, "messageRef"));
        eventDefinition.setMessageExpression(BpmnXMLUtil.getAttributeValue("messageExpression", xtr));
        if (!StringUtils.isEmpty((CharSequence)eventDefinition.getMessageRef())) {
            int indexOfP = eventDefinition.getMessageRef().indexOf(58);
            if (indexOfP != -1) {
                String prefix = eventDefinition.getMessageRef().substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                String messageRef = eventDefinition.getMessageRef().substring(indexOfP + 1);
                if (resolvedNamespace == null) {
                    messageRef = prefix + ":" + messageRef;
                } else if (!resolvedNamespace.equalsIgnoreCase(model.getTargetNamespace())) {
                    messageRef = resolvedNamespace + ":" + messageRef;
                }
                eventDefinition.setMessageRef(messageRef);
            } else {
                eventDefinition.setMessageRef(eventDefinition.getMessageRef());
            }
        }
        BpmnXMLUtil.parseChildElements("messageEventDefinition", (BaseElement)eventDefinition, xtr, model);
        ((Event)parentElement).getEventDefinitions().add(eventDefinition);
    }
}

