/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.nodes.ValueNode;

public final class DynamicNewInstanceTypeFlow
extends TypeFlow<ValueNode> {
    protected final BytecodeLocation allocationSite;
    protected TypeFlow<?> newTypeFlow;
    protected final AnalysisContext allocationContext;

    public DynamicNewInstanceTypeFlow(TypeFlow<?> newTypeFlow, ValueNode node, BytecodeLocation allocationLabel) {
        super(node, null);
        this.allocationSite = allocationLabel;
        this.allocationContext = null;
        this.newTypeFlow = newTypeFlow;
    }

    private DynamicNewInstanceTypeFlow(BigBang bb, DynamicNewInstanceTypeFlow original, MethodFlowsGraph methodFlows, AnalysisContext allocationContext) {
        super(original, methodFlows);
        this.allocationSite = original.allocationSite;
        this.allocationContext = allocationContext;
        this.newTypeFlow = methodFlows.lookupCloneOf(bb, original.newTypeFlow);
    }

    @Override
    public TypeFlow<ValueNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        AnalysisContext enclosingContext = methodFlows.context();
        AnalysisContext allocContext = bb.contextPolicy().allocationContext(enclosingContext, (Integer)PointstoOptions.MaxHeapContextDepth.getValue(bb.getOptions()));
        return new DynamicNewInstanceTypeFlow(bb, this, methodFlows, allocContext);
    }

    @Override
    public void initClone(BigBang bb) {
        assert (this.isClone());
        this.newTypeFlow.addObserver(bb, this);
    }

    @Override
    public void onObservedUpdate(BigBang bb) {
        assert (this.isClone());
        TypeState newTypeState = this.newTypeFlow.getState();
        TypeState currentTypeState = this.getState();
        TypeState resultState = newTypeState.typesStream().filter(t -> !currentTypeState.containsType((AnalysisType)t)).map(type -> TypeState.forAllocation(bb, (ValueNode)this.source, this.allocationSite, type, this.allocationContext)).reduce(TypeState.forEmpty(), (s1, s2) -> TypeState.forUnion(bb, s1, s2));
        assert (!resultState.canBeNull());
        this.addState(bb, resultState);
    }

    public TypeFlow<?> newTypeFlow() {
        return this.newTypeFlow;
    }

    public BytecodeLocation allocationSite() {
        return this.allocationSite;
    }

    public AnalysisContext allocationContext() {
        return this.allocationContext;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("DynamicNewInstanceFlow<").append(this.getState()).append(">");
        return str.toString();
    }
}

