/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize.kryo;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.messaging.serialize.AbstractDecoder;
import org.gradle.messaging.serialize.Decoder;

public class KryoBackedDecoder
extends AbstractDecoder
implements Decoder,
Closeable {
    private final Input input;
    private final InputStream inputStream;
    private long extraSkipped;

    public KryoBackedDecoder(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public KryoBackedDecoder(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.input = new Input(this.inputStream, bufferSize);
    }

    protected int maybeReadBytes(byte[] buffer, int offset, int count) {
        return this.input.read(buffer, offset, count);
    }

    protected long maybeSkip(long count) throws IOException {
        int remaining = this.input.limit() - this.input.position();
        if (remaining == 0) {
            long skipped = this.inputStream.skip(count);
            if (skipped > 0L) {
                this.extraSkipped += skipped;
            }
            return skipped;
        }
        if (count <= (long)remaining) {
            this.input.setPosition(this.input.position() + (int)count);
            return count;
        }
        this.input.setPosition(this.input.limit());
        return remaining;
    }

    private RuntimeException maybeEndOfStream(KryoException e) throws EOFException {
        if (e.getMessage().equals("Buffer underflow.")) {
            throw (EOFException)new EOFException().initCause(e);
        }
        throw e;
    }

    public byte readByte() throws EOFException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public void readBytes(byte[] buffer, int offset, int count) throws EOFException {
        try {
            this.input.readBytes(buffer, offset, count);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public long readLong() throws EOFException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public long readSmallLong() throws EOFException, IOException {
        try {
            return this.input.readLong(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public int readInt() throws EOFException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public int readSmallInt() throws EOFException {
        try {
            return this.input.readInt(true);
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public boolean readBoolean() throws EOFException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public String readString() throws EOFException {
        return this.readNullableString();
    }

    public String readNullableString() throws EOFException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw this.maybeEndOfStream(e);
        }
    }

    public long getReadPosition() {
        return (long)this.input.total() + this.extraSkipped;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

