/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.backlog.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class Log4jSyslogBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected Logger logger = null;
    protected Level downLevel = Level.WARN;
    protected Level upLevel = Level.WARN;

    public Log4jSyslogBackLogHandler(Logger logger) throws SyslogRuntimeException {
        this.logger = logger;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Logger logger, boolean appendReason) {
        this.logger = logger;
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class loggerClass) {
        if (loggerClass == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null");
        }
        this.logger = Logger.getLogger((Class)loggerClass);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class loggerClass, boolean appendReason) {
        if (loggerClass == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null");
        }
        this.logger = Logger.getLogger((Class)loggerClass);
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        this.logger = Logger.getLogger((String)loggerName);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, boolean appendReason) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        this.logger = Logger.getLogger((String)loggerName);
        this.appendReason = appendReason;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, LoggerFactory loggerFactory) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null");
        }
        this.logger = Logger.getLogger((String)loggerName, (LoggerFactory)loggerFactory);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String loggerName, LoggerFactory loggerFactory, boolean appendReason) {
        if (loggerName == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null");
        }
        this.logger = Logger.getLogger((String)loggerName, (LoggerFactory)loggerFactory);
        this.appendReason = appendReason;
        this.initialize();
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        if (this.logger == null) {
            throw new SyslogRuntimeException("logger cannot be null");
        }
    }

    protected static Level getLog4jLevel(int level) {
        switch (level) {
            case 7: {
                return Level.DEBUG;
            }
            case 6: {
                return Level.INFO;
            }
            case 5: {
                return Level.INFO;
            }
            case 4: {
                return Level.WARN;
            }
            case 3: {
                return Level.ERROR;
            }
            case 2: {
                return Level.ERROR;
            }
            case 1: {
                return Level.ERROR;
            }
            case 0: {
                return Level.FATAL;
            }
        }
        return Level.WARN;
    }

    @Override
    public void down(SyslogIF syslog, String reason) {
        this.logger.log((Priority)this.downLevel, (Object)("Syslog protocol \"" + syslog.getProtocol() + "\" is down: " + reason));
    }

    @Override
    public void up(SyslogIF syslog) {
        this.logger.log((Priority)this.upLevel, (Object)("Syslog protocol \"" + syslog.getProtocol() + "\" is up"));
    }

    @Override
    public void log(SyslogIF syslog, int level, String message, String reason) throws SyslogRuntimeException {
        Level log4jLevel = Log4jSyslogBackLogHandler.getLog4jLevel(level);
        String combinedMessage = this.combine(syslog, level, message, reason);
        this.logger.log((Priority)log4jLevel, (Object)combinedMessage);
    }
}

