/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.event;

import java.net.InetAddress;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.graylog2.syslog4j.server.impl.event.SyslogServerEvent;

public class CiscoSyslogServerEvent
extends SyslogServerEvent {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy MMM ppd HH:mm:ss[.SSS][ zzz]", Locale.ROOT).withZone(ZoneOffset.UTC);
    private int sequenceNumber = 0;

    public CiscoSyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        this.initialize(message, length, inetAddress);
        this.parse();
    }

    public CiscoSyslogServerEvent(String message, InetAddress inetAddress) {
        this.initialize(message, inetAddress);
        this.parse();
    }

    @Override
    protected void parsePriority() {
        int i;
        if (this.message.charAt(0) == '<' && (i = this.message.indexOf(">")) <= 4 && i > -1) {
            String priorityStr = this.message.substring(1, i);
            int priority = 0;
            try {
                priority = Integer.parseInt(priorityStr);
                this.facility = priority >> 3;
                this.level = priority - (this.facility << 3);
                this.message = this.message.substring(i + 1);
                this.parseSequenceNumber();
                this.parseDate();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parseHost();
        }
    }

    private void parseSequenceNumber() {
        int i = this.message.indexOf(58);
        if (i > -1) {
            String sequenceNumberStr = this.message.substring(0, i);
            if (sequenceNumberStr.isEmpty()) {
                this.message = this.message.substring(i + 1);
            } else {
                try {
                    this.sequenceNumber = Integer.parseInt(sequenceNumberStr);
                    this.message = this.message.substring(i + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void parseHost() {
        if (this.message.indexOf(37) < 1) {
            this.host = "";
        } else {
            int i = this.message.indexOf(32);
            if (i > -1) {
                this.host = this.message.substring(0, i).trim();
                char c = this.message.charAt(i);
                while (c == ' ' || c == ':') {
                    c = this.message.charAt(++i);
                }
                this.message = this.message.substring(i);
            }
        }
    }

    @Override
    protected void parseDate() {
        while (this.message.charAt(0) == ' ') {
            this.message = this.message.substring(1);
        }
        if (this.message.charAt(0) == '*') {
            this.message = this.message.substring(1);
        }
        int dateLength = this.message.indexOf(": ");
        if (this.message.length() > dateLength) {
            boolean isYearMissing = Character.isLetter(this.message.charAt(0));
            String originalDate = this.message.substring(0, dateLength);
            DateTimeFormatter formatter = DEFAULT_FORMATTER;
            if (Character.isDigit(this.message.charAt(7)) && Character.isDigit(this.message.charAt(8)) && Character.isDigit(this.message.charAt(9)) && Character.isDigit(this.message.charAt(10))) {
                dateLength = 20;
                isYearMissing = false;
                originalDate = this.message.substring(0, dateLength);
                formatter = DateTimeFormatter.ofPattern("MMM ppd yyyy HH:mm:ss", Locale.ROOT).withZone(ZoneOffset.UTC);
            }
            try {
                if (isYearMissing) {
                    String year = Integer.toString(Calendar.getInstance().get(1));
                    String modifiedDate = year + " " + originalDate;
                    ZonedDateTime dateTime = ZonedDateTime.parse(modifiedDate, formatter);
                    this.date = Date.from(dateTime.toInstant());
                } else {
                    ZonedDateTime dateTime = ZonedDateTime.parse(originalDate, formatter);
                    this.date = Date.from(dateTime.toInstant());
                }
                this.message = this.message.substring(dateLength + 1);
            }
            catch (DateTimeParseException pe) {
                this.date = new Date();
            }
        }
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }
}

