/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.event;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.syslog4j.server.SyslogServerEventIF;

public class FortiGateSyslogEvent
implements SyslogServerEventIF {
    private static final Pattern PRI_PATTERN = Pattern.compile("^<(\\d{1,3})>(.*)$");
    private static final Pattern KV_PATTERN = Pattern.compile("(\\w+)=([^\\s\"]*)");
    private static final Pattern QUOTED_KV_PATTERN = Pattern.compile("(\\w+)=\"([^\"]*)\"");
    private final String rawEvent;
    private Date date;
    private int facility;
    private int level;
    private String host;
    private String message;
    private Charset charSet = StandardCharsets.UTF_8;
    private Map<String, String> fields = Collections.emptyMap();

    public FortiGateSyslogEvent(String rawEvent) {
        this.rawEvent = Objects.requireNonNull(rawEvent, "rawEvent");
        this.parse(rawEvent);
    }

    private void parse(String event) {
        Matcher matcher = PRI_PATTERN.matcher(event);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid Fortigate syslog message");
        }
        String priority = matcher.group(1);
        String message = matcher.group(2);
        this.parsePriority(priority);
        this.setMessage(message);
        this.parseFields(message);
        this.parseDate(this.fields.get("date"), this.fields.get("time"));
        this.setHost(this.fields.get("devname"));
    }

    private void parsePriority(String priorityString) {
        try {
            int priority = Integer.parseInt(priorityString);
            this.setFacility(priority / 8);
            this.setLevel(priority % 8);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Couldn't parse message priority", e);
        }
    }

    private void parseFields(String event) {
        HashMap<String, String> fields = new HashMap<String, String>();
        Matcher matcher = KV_PATTERN.matcher(event);
        while (matcher.find()) {
            fields.put(matcher.group(1), matcher.group(2));
        }
        Matcher quotedMatcher = QUOTED_KV_PATTERN.matcher(event);
        while (quotedMatcher.find()) {
            fields.put(quotedMatcher.group(1), quotedMatcher.group(2));
        }
        this.setFields(fields);
    }

    private void parseDate(String date, String time) {
        if (date != null && time != null) {
            ZonedDateTime dateTime = ZonedDateTime.of(LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC)), LocalTime.parse(time, DateTimeFormatter.ISO_LOCAL_TIME.withZone(ZoneOffset.UTC)), ZoneOffset.UTC);
            this.setDate(Date.from(dateTime.toInstant()));
        } else {
            this.setDate(new Date());
        }
    }

    @Override
    public byte[] getRaw() {
        return this.rawEvent.getBytes(this.charSet);
    }

    @Override
    public int getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(int facility) {
        this.facility = Objects.requireNonNull(Integer.valueOf(facility), "facility");
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = Objects.requireNonNull(date, "date");
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = Objects.requireNonNull(Integer.valueOf(level), "level");
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean isHostStrippedFromMessage() {
        return false;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = Objects.requireNonNull(message, "message");
    }

    @Override
    public String getCharSet() {
        return this.charSet.name();
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = Charset.forName(charSet);
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void setFields(Map<String, String> fields) {
        this.fields = Objects.requireNonNull(fields, "fields");
    }
}

