/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.spi.jpa;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.jpa.event.internal.jpa.ListenerFactoryStandardImpl;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;

public class ListenerFactoryBuilder {
    private static final String CDI_LISTENER_FACTORY_STANDARD_CLASS = "org.hibernate.jpa.event.internal.jpa.ListenerFactoryBeanManagerStandardImpl";
    private static final String CDI_LISTENER_FACTORY_DELAYED_CLASS = "org.hibernate.jpa.event.internal.jpa.ListenerFactoryBeanManagerDelayedImpl";
    private static final String CDI_LISTENER_FACTORY_METHOD_NAME = "fromBeanManagerReference";

    public static ListenerFactory buildListenerFactory(SessionFactoryOptions options) {
        Object beanManagerRef = options.getBeanManagerReference();
        if (beanManagerRef == null) {
            return new ListenerFactoryStandardImpl();
        }
        boolean delayAccessToCdi = (Boolean)((ConfigurationService)options.getServiceRegistry().getService(ConfigurationService.class)).getSetting("hibernate.delay_cdi_access", StandardConverters.BOOLEAN, (Object)false);
        if (delayAccessToCdi) {
            return ListenerFactoryBuilder.buildDelayedBeanManagerListenerFactory(beanManagerRef);
        }
        return ListenerFactoryBuilder.buildStandardBeanManagerListenerFactory(beanManagerRef);
    }

    private static ListenerFactory buildStandardBeanManagerListenerFactory(Object beanManagerRef) {
        return ListenerFactoryBuilder.buildBeanManagerListenerFactory(beanManagerRef, CDI_LISTENER_FACTORY_STANDARD_CLASS);
    }

    private static ListenerFactory buildDelayedBeanManagerListenerFactory(Object beanManagerRef) {
        return ListenerFactoryBuilder.buildBeanManagerListenerFactory(beanManagerRef, CDI_LISTENER_FACTORY_DELAYED_CLASS);
    }

    private static ListenerFactory buildBeanManagerListenerFactory(Object beanManagerRef, String listenerClass) {
        try {
            Class<?> beanManagerListenerFactoryClass = ListenerFactoryBuilder.class.getClassLoader().loadClass(listenerClass);
            Method beanManagerListenerFactoryBuilderMethod = beanManagerListenerFactoryClass.getMethod(CDI_LISTENER_FACTORY_METHOD_NAME, Object.class);
            try {
                return (ListenerFactory)beanManagerListenerFactoryBuilderMethod.invoke(null, beanManagerRef);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate BeanManager ListenerFactory class [" + listenerClass + "] to handle CDI extensions", (Throwable)e);
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new HibernateException("Could not access BeanManager ListenerFactory class [" + listenerClass + "] to handle CDI extensions", e);
        }
    }
}

