/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class IndexMetaData
implements Serializable {
    private String indexName;
    private Set<IndexColumn> columnName = new LinkedHashSet<IndexColumn>();
    private boolean unique;

    public boolean contains(String column) {
        return this.columnName.stream().anyMatch(indexColumn -> indexColumn.getColumn().equals(column));
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Set<IndexColumn> getColumnName() {
        return this.columnName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setColumnName(Set<IndexColumn> columnName) {
        this.columnName = columnName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public static class IndexColumn
    implements Serializable {
        private String column;
        private String sort;

        public static IndexColumn of(String column, String sort) {
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.setColumn(column);
            indexColumn.setSort(sort);
            return indexColumn;
        }

        public String getColumn() {
            return this.column;
        }

        public String getSort() {
            return this.sort;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }
    }
}

