/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta;

import java.io.Serializable;
import java.sql.JDBCType;
import org.hswebframework.ezorm.core.ValueConverter;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetaData;
import org.hswebframework.ezorm.core.meta.ColumnMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.converter.DefaultValueConverter;

public class RDBColumnMetaData
extends AbstractColumnMetaData
implements ColumnMetaData,
Serializable,
Cloneable,
Comparable<RDBColumnMetaData> {
    private static final DefaultValueConverter DEFAULT_VALUE_CONVERTER = new DefaultValueConverter();
    private String dataType;
    private int length;
    private int precision;
    private int scale;
    private boolean notNull;
    private boolean primaryKey;
    private String columnDefinition;
    private JDBCType jdbcType;
    private int sortIndex;

    public RDBColumnMetaData() {
    }

    public RDBColumnMetaData(String name, Class javaType, String dataType, JDBCType jdbcType) {
        this.name = name;
        this.javaType = javaType;
        this.dataType = dataType;
        this.jdbcType = jdbcType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public RDBTableMetaData getTableMetaData() {
        return (RDBTableMetaData)super.getTableMetaData();
    }

    public String getFullName() {
        return this.tableMetaData == null ? this.getName() : this.tableMetaData.getName() + "." + this.getName();
    }

    public String getFullAliasName() {
        return this.tableMetaData == null ? this.getAlias() : this.tableMetaData.getAlias() + "." + this.getAlias();
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public ValueConverter getValueConverter() {
        if (this.valueConverter == null) {
            this.valueConverter = DEFAULT_VALUE_CONVERTER;
        }
        return super.getValueConverter();
    }

    @Override
    public int compareTo(RDBColumnMetaData o) {
        return Integer.compare(this.sortIndex, o.getSortIndex());
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isNotNull() {
        if (!this.notNull && this.isPrimaryKey()) {
            this.notNull = true;
        }
        return this.notNull;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public RDBColumnMetaData clone() {
        RDBColumnMetaData column = new RDBColumnMetaData();
        column.name = this.name;
        column.alias = this.alias;
        column.comment = this.comment;
        column.javaType = this.javaType;
        column.jdbcType = this.jdbcType;
        column.dataType = this.dataType;
        column.properties = this.properties;
        column.optionConverter = this.optionConverter;
        column.tableMetaData = this.tableMetaData;
        column.sortIndex = this.sortIndex;
        column.length = this.length;
        column.scale = this.scale;
        column.precision = this.precision;
        column.notNull = this.notNull;
        column.primaryKey = this.primaryKey;
        column.columnDefinition = this.columnDefinition;
        column.defaultValue = this.defaultValue;
        column.valueConverter = this.valueConverter;
        return column;
    }

    public String toString() {
        return "{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", comment='" + this.comment + '\'' + ", dataType='" + this.dataType + '\'' + '}';
    }
}

