/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.builder;

import org.hswebframework.ezorm.rdb.meta.IndexMetaData;
import org.hswebframework.ezorm.rdb.meta.RDBTableMetaData;
import org.hswebframework.ezorm.rdb.meta.builder.TableBuilder;

public class IndexBuilder {
    private TableBuilder tableBuilder;
    private RDBTableMetaData table;
    private IndexMetaData index = new IndexMetaData();

    public IndexBuilder(TableBuilder tableBuilder, RDBTableMetaData table) {
        this.tableBuilder = tableBuilder;
        this.table = table;
    }

    public IndexBuilder name(String indexName) {
        this.index.setIndexName(indexName);
        return this;
    }

    public IndexBuilder unique() {
        this.index.setUnique(true);
        return this;
    }

    public IndexBuilder column(String column) {
        return this.column(column, null);
    }

    public IndexBuilder column(String column, String sort) {
        this.index.getColumnName().add(IndexMetaData.IndexColumn.of(column, sort));
        return this;
    }

    public TableBuilder commit() {
        this.table.getIndexes().add(this.index);
        return this.tableBuilder;
    }
}

