/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.meta.converter;

import java.beans.ConstructorProperties;
import java.sql.JDBCType;
import org.hswebframework.ezorm.core.ValueConverter;

public class BooleanValueConverter
implements ValueConverter {
    private JDBCType jdbcType;

    public Object getData(Object value) {
        if (this.jdbcType == JDBCType.BOOLEAN || value == null) {
            return value;
        }
        if (Boolean.TRUE.equals(value)) {
            return 1;
        }
        if (Boolean.FALSE.equals(value)) {
            return 0;
        }
        return value;
    }

    public Object getValue(Object data) {
        if (null == data) {
            return false;
        }
        if (data instanceof Boolean) {
            return data;
        }
        return "1".equals(String.valueOf(data)) || "true".equals(String.valueOf(data));
    }

    @ConstructorProperties(value={"jdbcType"})
    public BooleanValueConverter(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
    }
}

