/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.util.HashMap;
import java.util.Map;
import org.hswebframework.ezorm.rdb.meta.RDBDatabaseMetaData;
import org.hswebframework.ezorm.rdb.render.SqlRender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleDeleteSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleInsertSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSelectSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleSelectTotalSqlRender;
import org.hswebframework.ezorm.rdb.render.support.simple.SimpleUpdateSqlRender;

public abstract class AbstractRDBDatabaseMetaData
extends RDBDatabaseMetaData {
    protected Map<SqlRender.TYPE, SqlRender> renderMap = new HashMap<SqlRender.TYPE, SqlRender>();
    protected Dialect dialect;

    public AbstractRDBDatabaseMetaData(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void init() {
        this.putRenderer(SqlRender.TYPE.DELETE, new SimpleDeleteSqlRender(this.getDialect()));
        this.putRenderer(SqlRender.TYPE.INSERT, new SimpleInsertSqlRender());
        this.putRenderer(SqlRender.TYPE.SELECT, new SimpleSelectSqlRender(this.getDialect()));
        this.putRenderer(SqlRender.TYPE.UPDATE, new SimpleUpdateSqlRender(this.getDialect()));
        this.putRenderer(SqlRender.TYPE.SELECT_TOTAL, new SimpleSelectTotalSqlRender(this.getDialect()));
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public <T> SqlRender<T> getRenderer(SqlRender.TYPE type) {
        SqlRender render = this.renderMap.get((Object)type);
        if (render == null) {
            throw new UnsupportedOperationException((Object)((Object)type) + " is not support");
        }
        return render;
    }

    public void putRenderer(SqlRender.TYPE type, SqlRender sqlRender) {
        this.renderMap.put(type, sqlRender);
    }
}

