/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.render.dialect;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.ezorm.core.param.ClassFieldTerm;
import org.hswebframework.ezorm.core.param.SqlTerm;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.meta.RDBColumnMetaData;
import org.hswebframework.ezorm.rdb.render.SqlAppender;
import org.hswebframework.ezorm.rdb.render.dialect.Dialect;
import org.hswebframework.ezorm.rdb.render.dialect.RenderPhase;
import org.hswebframework.ezorm.rdb.render.dialect.function.SqlFunction;
import org.hswebframework.ezorm.rdb.render.dialect.term.BoostTermTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultDialect
implements Dialect {
    private static final Logger log = LoggerFactory.getLogger(DefaultDialect.class);
    protected Map<String, Dialect.TermTypeMapper> termTypeMappers = new HashMap<String, Dialect.TermTypeMapper>();
    protected Map<String, Dialect.DataTypeMapper> dataTypeMappers = new HashMap<String, Dialect.DataTypeMapper>();
    protected Map<String, SqlFunction> functions = new HashMap<String, SqlFunction>();
    protected Dialect.DataTypeMapper defaultDataTypeMapper = null;
    protected Map<String, JDBCType> jdbcTypeMap = new HashMap<String, JDBCType>();
    private boolean preparePagingSql = Boolean.getBoolean("easyorm.paging.prepare");

    public DefaultDialect() {
        this.termTypeMappers.put("eq", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "=#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("not", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "!=#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("like", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> {
            SqlAppender sqlAppender = new SqlAppender();
            boolean reverse = term.getOptions().contains("reverse");
            boolean startWith = term.getOptions().contains("startWith");
            boolean endWith = term.getOptions().contains("endWith");
            Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
            String columnName = this.buildColumnName(tableAlias, column.getName());
            if (reverse) {
                SqlFunction concat = dialect.getFunction("concat");
                if (concat != null) {
                    ArrayList<String> params = new ArrayList<String>();
                    if (endWith) {
                        params.add("'%'");
                    }
                    params.add(columnName);
                    if (startWith) {
                        params.add("'%'");
                    }
                    columnName = startWith || endWith ? concat.apply(SqlFunction.Param.of(RenderPhase.where, params)) : columnName;
                }
                sqlAppender.add("#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}", " LIKE ", columnName);
            } else {
                sqlAppender.add(columnName, " LIKE #{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}");
            }
            return sqlAppender;
        }));
        this.termTypeMappers.put("nlike", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> {
            SqlAppender sqlAppender = new SqlAppender();
            boolean reverse = term.getOptions().contains("reverse");
            String columnName = this.buildColumnName(tableAlias, column.getName());
            if (reverse) {
                boolean startWith = term.getOptions().contains("startWith");
                boolean endWith = term.getOptions().contains("endWith");
                Dialect dialect = column.getTableMetaData().getDatabaseMetaData().getDialect();
                SqlFunction concat = dialect.getFunction("concat");
                if (concat != null) {
                    ArrayList<String> params = new ArrayList<String>();
                    if (endWith) {
                        params.add("'%'");
                    }
                    params.add(columnName);
                    if (startWith) {
                        params.add("'%'");
                    }
                    columnName = startWith || endWith ? concat.apply(SqlFunction.Param.of(RenderPhase.where, params)) : columnName;
                }
                sqlAppender.add("#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}", " NOT LIKE ", columnName);
            } else {
                sqlAppender.add(columnName, " NOT LIKE #{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}");
            }
            return sqlAppender;
        }));
        this.termTypeMappers.put("isnull", (wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), " IS NULL"));
        this.termTypeMappers.put("notnull", (wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), " IS NOT NULL"));
        this.termTypeMappers.put("gt", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), ">#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("lt", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "<#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("gte", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), ">=#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("lte", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "<=#{", wherePrefix, term instanceof ClassFieldTerm ? "" : ".value}")));
        this.termTypeMappers.put("empty", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "=''")));
        this.termTypeMappers.put("nempty", BoostTermTypeMapper.notSupportArray((wherePrefix, term, column, tableAlias) -> new SqlAppender().add(this.buildColumnName(tableAlias, column.getName()), "!=''")));
        this.termTypeMappers.put("btw", BoostTermTypeMapper.supportArray((wherePrefix, term, column, tableAlias) -> {
            SqlAppender sqlAppender = new SqlAppender();
            List<Object> objects = this.param2list(term.getValue());
            if (objects.size() == 1) {
                objects.add(objects.get(0));
            }
            term.setValue(objects);
            sqlAppender.add(this.buildColumnName(tableAlias, column.getName()), " ").addSpc("BETWEEN").add("#{", wherePrefix, ".value[0]}").add(" AND ", "#{", wherePrefix, ".value[1]}");
            return sqlAppender;
        }));
        this.termTypeMappers.put("nbtw", BoostTermTypeMapper.supportArray((wherePrefix, term, column, tableAlias) -> {
            SqlAppender sqlAppender = new SqlAppender();
            List<Object> objects = this.param2list(term.getValue());
            if (objects.size() == 1) {
                objects.add(objects.get(0));
            }
            term.setValue(objects);
            sqlAppender.add(this.buildColumnName(tableAlias, column.getName()), " ").addSpc("NOT BETWEEN").add("#{", wherePrefix, ".value[0]}").add(" AND ", "#{", wherePrefix, ".value[1]}");
            return sqlAppender;
        }));
        this.termTypeMappers.put("in", BoostTermTypeMapper.supportArray((wherePrefix, term, column, tableAlias) -> {
            List<Object> values = this.param2list(term.getValue());
            term.setValue(values);
            SqlAppender appender = new SqlAppender();
            appender.add(tableAlias, ".").addSpc(column.getName()).add("IN(");
            for (int i = 0; i < values.size(); ++i) {
                appender.add("#{", wherePrefix, ".value[", i, "]}", ",");
            }
            appender.removeLast();
            appender.add(")");
            return appender;
        }));
        this.termTypeMappers.put("nin", BoostTermTypeMapper.supportArray((wherePrefix, term, column, tableAlias) -> {
            List<Object> values = this.param2list(term.getValue());
            term.setValue(values);
            SqlAppender appender = new SqlAppender();
            appender.add(tableAlias, ".").addSpc(column.getName()).add("NOT IN(");
            for (int i = 0; i < values.size(); ++i) {
                appender.add("#{", wherePrefix, ".value[", i, "]}", ",");
            }
            appender.removeLast();
            appender.add(")");
            return appender;
        }));
    }

    @Override
    public SqlFunction getFunction(String name) {
        return this.functions.get(name);
    }

    @Override
    public SqlFunction installFunction(String name, SqlFunction function) {
        return this.functions.put(name, function);
    }

    @Override
    public SqlAppender buildCondition(String wherePrefix, Term term, RDBColumnMetaData column, String tableAlias) {
        if (term instanceof SqlTerm) {
            SqlTerm sqlTerm = (SqlTerm)term;
            String sql = sqlTerm.getSql();
            if (sql == null) {
                sql = sqlTerm.getColumn();
            }
            if (sql == null) {
                return new SqlAppender();
            }
            Dialect.TermTypeMapper mapper = Dialect.TermTypeMapper.sql(sqlTerm.getSql(), sqlTerm.getParam());
            return mapper.accept(wherePrefix, (Term)sqlTerm, column, tableAlias);
        }
        if (term.getValue() instanceof Dialect.TermTypeMapper) {
            return ((Dialect.TermTypeMapper)term.getValue()).accept(wherePrefix, term, column, tableAlias);
        }
        Dialect.TermTypeMapper mapper = this.termTypeMappers.get(term.getTermType());
        if (mapper == null) {
            mapper = this.termTypeMappers.get("eq");
        }
        return mapper.accept(wherePrefix, term, column, tableAlias);
    }

    protected List<Object> param2list(Object value) {
        if (value == null) {
            return new ArrayList<Object>();
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        if (value.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])value));
        }
        return new ArrayList<Object>(Collections.singletonList(value));
    }

    @Override
    public void setTermTypeMapper(String termType, Dialect.TermTypeMapper mapper) {
        this.termTypeMappers.put(termType.toLowerCase(), mapper);
    }

    @Override
    public boolean isSupportTermType(String termType) {
        return this.termTypeMappers.containsKey(termType);
    }

    @Override
    public void setDataTypeMapper(JDBCType jdbcType, Dialect.DataTypeMapper mapper) {
        this.dataTypeMappers.put(jdbcType.getName(), mapper);
    }

    public void setJdbcTypeMapping(String dataType, JDBCType jdbcType) {
        this.jdbcTypeMap.put(dataType, jdbcType);
    }

    @Override
    public String buildDataType(RDBColumnMetaData columnMetaData) {
        if (columnMetaData.getJdbcType() == null) {
            return null;
        }
        Dialect.DataTypeMapper mapper = this.dataTypeMappers.get(columnMetaData.getJdbcType().getName());
        if (null == mapper) {
            mapper = this.defaultDataTypeMapper;
        }
        return mapper.getDataType(columnMetaData);
    }

    @Override
    public JDBCType getJdbcType(String dataType) {
        JDBCType jdbcType;
        block3: {
            try {
                jdbcType = JDBCType.valueOf(dataType.toUpperCase());
            }
            catch (Exception e) {
                if (dataType.contains("(")) {
                    dataType = dataType.substring(0, dataType.indexOf("("));
                }
                if ((jdbcType = this.jdbcTypeMap.get(dataType.toLowerCase())) != null) break block3;
                log.warn("can not parse jdbcType:{}", (Object)dataType);
                jdbcType = JDBCType.OTHER;
            }
        }
        return jdbcType;
    }

    @Override
    public String doPaging(String sql, int pageIndex, int pageSize) {
        return this.doPaging(sql, pageIndex, pageSize, this.preparePagingSql);
    }

    public void setPreparePagingSql(boolean preparePagingSql) {
        this.preparePagingSql = preparePagingSql;
    }

    public boolean isPreparePagingSql() {
        return this.preparePagingSql;
    }
}

